/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.server.util;

import com.jxdinfo.hussar.df.common.constant.DfEngineColumnType;
import com.mysql.cj.MysqlType;
import java.sql.JDBCType;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import oracle.jdbc.OracleType;

public class DfEngineColumnTypeUtil {
    private static final List<DfEngineColumnType> DF_ENGINE_COLUMN_TYPES = new ArrayList<DfEngineColumnType>();

    public static Optional<DfEngineColumnType> getEngineColumnType(String dataType) {
        return DF_ENGINE_COLUMN_TYPES.stream().filter(x -> x.getDataType().equalsIgnoreCase(dataType)).findFirst();
    }

    public static Optional<DfEngineColumnType> getEngineColumnTypeByJdbcType(int jdbcType) {
        JDBCType jdbcTypeEnum = JDBCType.valueOf(jdbcType);
        return DF_ENGINE_COLUMN_TYPES.stream().filter(x -> x.getJdbcType() == jdbcTypeEnum).findFirst();
    }

    static {
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.INTEGER, MysqlType.INT, OracleType.NUMBER, Integer.class.getName(), "int"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.VARCHAR, MysqlType.VARCHAR, OracleType.VARCHAR2, String.class.getName(), "string"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.VARCHAR, MysqlType.VARCHAR, OracleType.VARCHAR2, String.class.getName(), "arrayPrimary"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.VARCHAR, MysqlType.VARCHAR, OracleType.VARCHAR2, String.class.getName(), "treeObject"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.DOUBLE, MysqlType.DOUBLE, OracleType.NUMBER, Double.class.getName(), "double"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.TIMESTAMP, MysqlType.DATETIME, OracleType.TIMESTAMP, LocalDateTime.class.getName(), "date"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.TINYINT, MysqlType.TINYINT, OracleType.CHAR, Boolean.class.getName(), "boolean"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.BIGINT, MysqlType.BIGINT, OracleType.LONG, Long.class.getName(), "long"));
        DF_ENGINE_COLUMN_TYPES.add(new DfEngineColumnType(JDBCType.LONGVARCHAR, MysqlType.TEXT, OracleType.CLOB, String.class.getName(), "text"));
    }
}

