/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.server.table.service.impl;

import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataColumnService;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataTableService;
import com.jxdinfo.hussar.df.common.constant.HussarDfType;
import com.jxdinfo.hussar.df.common.properties.DfProperties;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetModelBase;
import com.jxdinfo.hussar.df.data.set.api.model.ProjectionField;
import com.jxdinfo.hussar.df.data.set.api.table.service.DfTableService;
import com.jxdinfo.hussar.df.data.set.api.table.vo.DataSetTierTable;
import com.jxdinfo.hussar.df.data.set.server.table.util.DfTableTransFormUtil;
import com.jxdinfo.hussar.df.data.set.server.table.vo.DataSetTableVo;
import com.jxdinfo.hussar.df.data.set.server.util.DataSetUtil;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.DatasourceConfigDTO;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.service.DatasourceDataService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.engine.api.entity.ModelRelationship;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelRelationshipService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DfTableServiceImpl
implements DfTableService {
    @Resource
    private MetadataTableService metadataTableService;
    @Resource
    private ModelRelationshipService modelRelationshipService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private MetadataColumnService metadataColumnService;
    @Resource
    private ISysFormService formService;
    @Resource
    private DatasourceDataService datasourceDataService;
    @Autowired
    private DfProperties dfProperties;
    @Autowired
    private DynamicDatasourceService datasourceService;

    public Object list(Long id, String type) throws IOException, LcdpException {
        if (HussarDfType.LOW_CODE.getType().equals(this.dfProperties.getHussarType())) {
            return this.lowCodeList(id, type);
        }
        return this.noCodeList();
    }

    public List<DataSetTierTable> sqlList(Long id, String type) throws IOException, LcdpException {
        if (HussarDfType.LOW_CODE.getType().equals(this.dfProperties.getHussarType())) {
            return this.lowCodeSqlList(id, type);
        }
        return this.noCodeSqlList();
    }

    public List<ProjectionField> dataSetColumn(Long dataSetId) throws IOException, LcdpException {
        DataSetModelBase dataSetModelBase = DataSetUtil.getDataModelBase(dataSetId);
        return dataSetModelBase.getProjection();
    }

    public List<DatasourceConfigDTO> getDataSourceList() throws IOException {
        List datasourceConfigDTOS = this.datasourceDataService.getList();
        if (this.dfProperties.isNoCode()) {
            String currentDatasourceName = this.datasourceService.getCurrentDatasourceName();
            datasourceConfigDTOS = datasourceConfigDTOS.stream().filter(e -> HussarUtils.equals((Object)currentDatasourceName, (Object)e.getName())).collect(Collectors.toList());
        }
        return datasourceConfigDTOS;
    }

    private List<DataSetTableVo> noCodeList() {
        List forms = this.formService.list();
        List applications = this.sysApplicationService.list();
        List modelRelationships = this.modelRelationshipService.list();
        List metadataTables = this.metadataTableService.list();
        List metadataColumns = this.metadataColumnService.list();
        HashMap<Long, SysApplication> applicationMap = new HashMap<Long, SysApplication>();
        HashMap<String, SysForm> formMap = new HashMap<String, SysForm>();
        HashMap<Long, DataSetTableVo> dataSetTableVoHashMap = new HashMap<Long, DataSetTableVo>();
        HashMap<Long, MetadataTable> metadataTableMap = new HashMap<Long, MetadataTable>();
        HashMap<Long, ModelRelationship> modelRelationshipMap = new HashMap<Long, ModelRelationship>();
        HashMap<Long, Map<Long, List<DataSetTableVo>>> dataSetTableVoMap = new HashMap<Long, Map<Long, List<DataSetTableVo>>>();
        for (SysApplication application : applications) {
            applicationMap.put(application.getId(), application);
        }
        for (SysForm form : forms) {
            formMap.put(form.getTableName(), form);
        }
        for (MetadataTable metadataTable : metadataTables) {
            SysApplication application;
            metadataTableMap.put(metadataTable.getTableId(), metadataTable);
            SysForm form = (SysForm)formMap.get(metadataTable.getTableAlias());
            if (HussarUtils.isEmpty((Object)form) || HussarUtils.isEmpty((Object)(application = (SysApplication)applicationMap.get(form.getAppId())))) continue;
            DataSetTableVo dataSetTableVo = DfTableTransFormUtil.transformTable(metadataTable);
            dataSetTableVo.setAppId(form.getAppId());
            dataSetTableVo.setAppName(application.getAppName());
            dataSetTableVoHashMap.put(dataSetTableVo.getTableId(), dataSetTableVo);
            this.addDataSetTableVoMap(dataSetTableVoMap, form.getAppId(), metadataTable.getTableId(), dataSetTableVo);
        }
        for (ModelRelationship modelRelationship : modelRelationships) {
            modelRelationshipMap.put(modelRelationship.getRelatedId(), modelRelationship);
        }
        for (ModelRelationship modelRelationship : modelRelationships) {
            DataSetTableVo parentDataSetTableVo;
            ModelRelationship parentModelRelationship;
            Long parentId = modelRelationship.getParentId();
            if (HussarUtils.isEmpty((Object)parentId) || HussarUtils.isEmpty((Object)(parentModelRelationship = (ModelRelationship)modelRelationshipMap.get(parentId))) || HussarUtils.isEmpty((Object)(parentDataSetTableVo = (DataSetTableVo)dataSetTableVoHashMap.get(parentModelRelationship.getTableId())))) continue;
            MetadataTable metadataTable = (MetadataTable)metadataTableMap.get(modelRelationship.getTableId());
            DataSetTableVo dataSetTableVo = (DataSetTableVo)dataSetTableVoHashMap.get(modelRelationship.getTableId());
            if (!HussarUtils.isEmpty((Object)dataSetTableVo)) continue;
            dataSetTableVo = DfTableTransFormUtil.transformTable(metadataTable);
            dataSetTableVoHashMap.put(dataSetTableVo.getTableId(), dataSetTableVo);
            this.addDataSetTableVoMap(dataSetTableVoMap, parentDataSetTableVo.getAppId(), parentDataSetTableVo.getTableId(), dataSetTableVo);
            dataSetTableVo.setParentTabName(parentDataSetTableVo.getName());
            dataSetTableVo.setParentTabComm(parentDataSetTableVo.getComment());
            dataSetTableVo.setAppName(parentDataSetTableVo.getAppName());
        }
        for (MetadataColumn metadataColumn : metadataColumns) {
            DataSetTableVo dataSetTableVo = (DataSetTableVo)dataSetTableVoHashMap.get(metadataColumn.getTableId());
            if (HussarUtils.isEmpty((Object)dataSetTableVo)) continue;
            dataSetTableVo.addFields(DfTableTransFormUtil.transformField(metadataColumn));
        }
        return this.transFormMapToList(dataSetTableVoMap);
    }

    private List<DataSetTierTable> noCodeSqlList() {
        DataSetTierTable appInfo;
        ArrayList<DataSetTierTable> appTables = new ArrayList<DataSetTierTable>();
        List forms = this.formService.list();
        List applications = this.sysApplicationService.list();
        List metadataTables = this.metadataTableService.list();
        List metadataColumns = this.metadataColumnService.list();
        HashMap<Long, DataSetTierTable> applicationMap = new HashMap<Long, DataSetTierTable>();
        HashMap<String, DataSetTierTable> formMap = new HashMap<String, DataSetTierTable>();
        HashMap<Long, DataSetTierTable> tableMap = new HashMap<Long, DataSetTierTable>();
        for (SysApplication application : applications) {
            appInfo = new DataSetTierTable();
            appInfo.setName(application.getAppCode());
            appInfo.setCode(application.getAppCode());
            appInfo.setCommon(application.getAppName());
            appInfo.setType("1");
            applicationMap.put(application.getId(), appInfo);
        }
        for (SysForm form : forms) {
            DataSetTierTable appInf = (DataSetTierTable)applicationMap.get(form.getAppId());
            formMap.put(form.getTableName(), appInf);
        }
        for (MetadataTable metadataTable : metadataTables) {
            appInfo = (DataSetTierTable)formMap.get(metadataTable.getTableName());
            if (appInfo == null) continue;
            DataSetTierTable table = new DataSetTierTable();
            table.setName(metadataTable.getTableName());
            table.setCode(metadataTable.getTableName());
            table.setCommon(metadataTable.getTableDec());
            table.setType("2");
            if (appInfo.getChildren() == null || appInfo.getChildren().isEmpty()) {
                appInfo.addChild(table);
                appTables.add(appInfo);
            } else {
                appInfo.addChild(table);
            }
            tableMap.put(metadataTable.getTableId(), table);
        }
        for (MetadataColumn metadataColumn : metadataColumns) {
            DataSetTierTable table = (DataSetTierTable)tableMap.get(metadataColumn.getTableId());
            if (table == null) continue;
            DataSetTierTable field = new DataSetTierTable();
            field.setName(metadataColumn.getColumnName());
            field.setCode(table.getName() + "_" + metadataColumn.getColumnName());
            field.setCommon(metadataColumn.getColumnComment());
            field.setType("3");
            field.setDataType(metadataColumn.getJdbcType());
            table.addChild(field);
        }
        return appTables;
    }

    private void addDataSetTableVoMap(Map<Long, Map<Long, List<DataSetTableVo>>> dataSetTableVoMap, Long appId, Long masterTableId, DataSetTableVo dataSetTableVo) {
        List<DataSetTableVo> dataSetTableVos;
        Map<Long, List<DataSetTableVo>> appMap = dataSetTableVoMap.get(appId);
        if (HussarUtils.isEmpty(appMap)) {
            appMap = new HashMap<Long, List<DataSetTableVo>>();
            dataSetTableVoMap.put(appId, appMap);
        }
        if (HussarUtils.isEmpty(dataSetTableVos = appMap.get(masterTableId))) {
            dataSetTableVos = new ArrayList<DataSetTableVo>();
            appMap.put(masterTableId, dataSetTableVos);
        }
        dataSetTableVos.add(dataSetTableVo);
    }

    private List<DataSetTableVo> transFormMapToList(Map<Long, Map<Long, List<DataSetTableVo>>> dataSetTableVoMap) {
        ArrayList<DataSetTableVo> dataSetTableVos = new ArrayList<DataSetTableVo>();
        for (Map.Entry<Long, Map<Long, List<DataSetTableVo>>> appEntry : dataSetTableVoMap.entrySet()) {
            Map<Long, List<DataSetTableVo>> tableMap = appEntry.getValue();
            for (Map.Entry<Long, List<DataSetTableVo>> tableEntry : tableMap.entrySet()) {
                List<DataSetTableVo> dataSetTableVoList = tableEntry.getValue();
                dataSetTableVos.addAll(dataSetTableVoList);
            }
        }
        return dataSetTableVos;
    }

    private List<TableInfo> lowCodeList(Long id, String type) throws IOException, LcdpException {
        return this.datasourceDataService.getTableInfoById(id, type);
    }

    private List<DataSetTierTable> lowCodeSqlList(Long id, String type) throws IOException, LcdpException {
        ArrayList<DataSetTierTable> tables = new ArrayList<DataSetTierTable>();
        List tableInfos = this.datasourceDataService.getTableInfoById(id, type);
        for (TableInfo tableInfo : tableInfos) {
            DataSetTierTable table = new DataSetTierTable();
            table.setName(tableInfo.getName());
            table.setCode(tableInfo.getName());
            table.setCommon(tableInfo.getComment());
            table.setType("2");
            tables.add(table);
            if (HussarUtils.isEmpty((Object)tableInfo.getFields())) continue;
            for (TableField tableField : tableInfo.getFields()) {
                DataSetTierTable field = new DataSetTierTable();
                field.setName(tableField.getName());
                field.setCode(tableInfo.getName() + "_" + tableField.getName());
                field.setCommon(tableField.getComment());
                field.setDataType(tableField.getType());
                field.setType("3");
                table.addChild(field);
            }
        }
        return tables;
    }
}

