/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.server.dataset.service.impl;

import com.jxdinfo.hussar.df.data.set.api.dataset.service.DataSetService;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetModel;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetQueryModel;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetSortModel;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetTableField;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetTables;
import com.jxdinfo.hussar.df.data.set.api.model.JoinSubset;
import com.jxdinfo.hussar.df.data.set.api.model.JoinTable;
import com.jxdinfo.hussar.df.data.set.api.model.ProjectionField;
import com.jxdinfo.hussar.df.data.set.server.util.DataSetUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class DataSetServiceImpl
implements DataSetService {
    public ApiResponse<String> generateSql(DataSetModel dataSetModel) {
        StringBuilder stringBuilder;
        StringBuilder sql = new StringBuilder();
        if (dataSetModel.getTables() == null || HussarUtils.isEmpty((Object)dataSetModel.getTables()) || dataSetModel.getTables().size() == 0) {
            return ApiResponse.fail((String)"\u6570\u636e\u96c6\u672a\u9009\u62e9\u8868");
        }
        sql.append("SELECT ");
        if (dataSetModel.getProjection() == null || !HussarUtils.isNotEmpty((Object)dataSetModel.getProjection()) || dataSetModel.getProjection().size() == 0) {
            return ApiResponse.fail((String)"\u6570\u636e\u96c6\u5b57\u6bb5\u914d\u7f6e\u9519\u8bef");
        }
        sql.append((CharSequence)this.combineField(dataSetModel));
        if (HussarUtils.isEmpty((Object)dataSetModel.getRelationship()) && dataSetModel.getTables().size() > 1) {
            return ApiResponse.fail((String)"\u6570\u636e\u96c6\u672a\u914d\u7f6e\u5173\u8054\u5173\u7cfb");
        }
        if (dataSetModel.getTables().size() == 1) {
            sql.append("\n").append("FROM ");
            sql.append(((DataSetTables)dataSetModel.getTables().get(0)).getName()).append("\n");
        }
        if (dataSetModel.getRelationship() != null && HussarUtils.isNotEmpty((Object)dataSetModel.getRelationship()) && dataSetModel.getRelationship().size() != 0) {
            sql.append("\n").append("FROM ");
            stringBuilder = this.convertJoin(dataSetModel.getRelationship());
            if (HussarUtils.isBlank((CharSequence)stringBuilder)) {
                return ApiResponse.fail((String)"\u6570\u636e\u96c6\u5173\u8054\u914d\u7f6e\u9519\u8bef");
            }
            sql.append((CharSequence)stringBuilder);
        }
        if (dataSetModel.getQuery() != null && HussarUtils.isNotEmpty((Object)dataSetModel.getQuery()) && dataSetModel.getQuery().size() != 0 && !"".equals((stringBuilder = this.convertquery(dataSetModel.getQuery())).toString())) {
            sql.append("WHERE ").append((CharSequence)stringBuilder);
        }
        if (dataSetModel.getSort() != null && HussarUtils.isNotEmpty((Object)dataSetModel.getSort()) && dataSetModel.getSort().size() != 0) {
            stringBuilder = this.convertSort(dataSetModel.getSort());
            if (HussarUtils.isBlank((CharSequence)stringBuilder)) {
                return ApiResponse.fail((String)"\u6392\u5e8f\u6761\u4ef6\u914d\u7f6e\u9519\u8bef");
            }
            sql.append((CharSequence)stringBuilder);
        }
        return ApiResponse.success((Object)sql.toString(), (String)"\u67e5\u8be2\u6210\u529f\uff01");
    }

    public StringBuilder combineField(DataSetModel dataSetModel) {
        List projectionFields = dataSetModel.getProjection();
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (DataSetTables dataSetTables : dataSetModel.getTables()) {
            for (DataSetTableField dataSetTableField : dataSetTables.getFields()) {
                HashMap field = new HashMap();
                String fieldName = dataSetTables.getName() + "." + dataSetTableField.getName();
                fieldMap.put(dataSetTableField.getColumnId(), fieldName);
            }
        }
        for (ProjectionField projectionField : projectionFields) {
            if ("default".equals(projectionField.getType())) {
                sql.append(projectionField.getTable()).append(".").append(projectionField.getField());
                if (HussarUtils.isNotEmpty((Object)projectionField.getFieldAlias())) {
                    sql.append(" AS ").append(projectionField.getFieldAlias());
                }
                sql.append(",").append("\n");
                continue;
            }
            if (!"calc".equals(projectionField.getType())) continue;
            String expression = projectionField.getExpression();
            String expressionSql = DataSetUtil.replacePlaceholders(expression, fieldMap);
            sql.append(expressionSql);
            sql.append(" AS '").append(projectionField.getFieldAlias()).append("'").append(",").append("\n");
        }
        if (!sql.toString().isEmpty()) {
            sql.setLength(sql.length() - 2);
        }
        return sql;
    }

    public StringBuilder convertJoin(List<JoinTable> joinTables) {
        StringBuilder sql = new StringBuilder();
        int joinTableNum = 1;
        for (JoinTable joinTable : joinTables) {
            int times = 1;
            if (HussarUtils.isBlank((CharSequence)joinTable.getLeftTable()) || HussarUtils.isBlank((CharSequence)joinTable.getRightTable())) {
                return new StringBuilder();
            }
            String joinType = null;
            switch (joinTable.getJoinType()) {
                case "left": {
                    joinType = "LEFT JOIN";
                    break;
                }
                case "right": {
                    joinType = "RIGHT JOIN";
                    break;
                }
                case "inner": {
                    joinType = "INNER JOIN";
                    break;
                }
            }
            if (joinTableNum == 1) {
                sql.append(joinTable.getLeftTable()).append(" ").append(joinType).append(" ").append(joinTable.getRightTable()).append(" ON ");
            } else {
                sql.append(joinType).append(" ").append(joinTable.getRightTable()).append(" ON ");
            }
            for (JoinSubset joinSubset : joinTable.getChildren()) {
                sql.append(joinTable.getLeftTable()).append(".").append(joinSubset.getLeftField()).append(" ").append(joinSubset.getCondition()).append(" ").append(joinTable.getRightTable()).append(".").append(joinSubset.getRightField()).append(" ").append("\n");
                if (times != joinTable.getChildren().size()) {
                    sql.append(joinSubset.getPreCondition()).append(" ");
                }
                ++times;
            }
            ++joinTableNum;
        }
        return sql;
    }

    public StringBuilder convertquery(List<DataSetQueryModel> filterList) {
        StringBuilder sql = new StringBuilder();
        int i = 0;
        for (DataSetQueryModel tableFilter : filterList) {
            tableFilter.setValue(this.fieldType(tableFilter.getFieldType(), tableFilter.getValue()));
            if ("row".equals(tableFilter.getType())) {
                if (!HussarUtils.isNotEmpty((Object)tableFilter.getTable()) || !HussarUtils.isNotEmpty((Object)tableFilter.getField()) || !HussarUtils.isNotEmpty((Object)tableFilter.getValue())) continue;
                sql.append(tableFilter.getTable()).append(".");
                sql.append((CharSequence)this.getQueryByType(tableFilter));
                if (++i != filterList.size()) continue;
                sql.setLength(sql.length() - (tableFilter.getPreCondition().length() + 1));
                continue;
            }
            if (!"child".equals(tableFilter.getType()) || !HussarUtils.isNotEmpty((Object)tableFilter.getChildren())) continue;
            sql.append("(");
            sql.append((CharSequence)this.convertquery(tableFilter.getChildren())).append(")");
        }
        return sql;
    }

    public Object fieldType(String fieldType, Object fieldValue) {
        switch (fieldType.toUpperCase()) {
            case "CHAR": 
            case "VARCHAR": 
            case "TEXT": 
            case "TINYTEXT": 
            case "MEDIUMTEXT": 
            case "LONGTEXT": 
            case "ENUM": 
            case "STRING": {
                return "'" + fieldValue + "'";
            }
            case "DATE": 
            case "TIME": 
            case "YEAR": 
            case "DATETIME": 
            case "TIMESTAMP": {
                return "'" + fieldValue + "'";
            }
            case "INT": 
            case "NUM": 
            case "SMALLINT": 
            case "MEDIUMINT": 
            case "INTEGER": 
            case "BIGINT": 
            case "LONG": {
                return fieldValue;
            }
            case "FLOAT": 
            case "DOUBLE": 
            case "DECIMAL": {
                return fieldValue;
            }
            case "BIT": 
            case "TINYINT": 
            case "BOOLEAN": {
                return fieldValue;
            }
        }
        return "'" + fieldValue + "'";
    }

    public StringBuilder getQueryByType(DataSetQueryModel tableFilter) {
        StringBuilder sql = new StringBuilder();
        switch (tableFilter.getCondition()) {
            case ">": 
            case "<": 
            case "=": 
            case "!=": 
            case "<=": 
            case ">=": {
                sql.append(tableFilter.getField()).append(" ").append(tableFilter.getCondition()).append(" ").append(tableFilter.getValue()).append(" ").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "in": 
            case "not in": {
                sql.append(tableFilter.getField()).append(" ").append(tableFilter.getCondition()).append(" (").append(tableFilter.getValue()).append(")").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "full_like": {
                sql.append(tableFilter.getField()).append(" ").append("LIKE").append(" '%").append(tableFilter.getValue().toString().replace("'", "")).append("%'").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "left_like": {
                sql.append(tableFilter.getField()).append(" ").append("LIKE").append(" '").append(tableFilter.getValue().toString().replace("'", "")).append("%'").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "right_like": {
                sql.append(tableFilter.getField()).append(" ").append("LIKE").append(" '%").append(tableFilter.getValue().toString().replace("'", "")).append("'").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "regexp": {
                sql.append(tableFilter.getField()).append(" ").append("REGEXP ").append(" ").append(tableFilter.getValue()).append(" ").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
        }
        return sql;
    }

    public StringBuilder convertSort(List<DataSetSortModel> sortConditionList) {
        StringBuilder sql = new StringBuilder();
        sql.append("ORDER BY ");
        for (DataSetSortModel joinSort : sortConditionList) {
            if (DataSetUtil.haveNullFiled(joinSort)) {
                return new StringBuilder();
            }
            sql.append(joinSort.getTable()).append(".").append(joinSort.getField()).append(" ").append(joinSort.getDirection()).append(",").append("\n");
        }
        sql.deleteCharAt(sql.length() - 2);
        return sql;
    }
}

