/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.server.dataset.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.CustomSqlDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.df.common.constant.DfEngineColumnType;
import com.jxdinfo.hussar.df.common.properties.DfProperties;
import com.jxdinfo.hussar.df.data.set.api.dataset.service.DataSetPushService;
import com.jxdinfo.hussar.df.data.set.api.dataset.service.DataSetService;
import com.jxdinfo.hussar.df.data.set.api.dto.HeRelationDTO;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetModel;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetSuncModel;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetTableField;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetTables;
import com.jxdinfo.hussar.df.data.set.api.model.ProjectionField;
import com.jxdinfo.hussar.df.data.set.api.processor.DataSetProcessor;
import com.jxdinfo.hussar.df.data.set.server.util.DataSetUtil;
import com.jxdinfo.hussar.df.data.set.server.util.DfDataModelUtil;
import com.jxdinfo.hussar.df.data.set.server.util.DfEngineColumnTypeUtil;
import com.jxdinfo.hussar.df.data.set.server.util.DfExternalApiUtil;
import com.jxdinfo.hussar.df.data.set.server.util.DfOperationUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.require.engine.utils.LrEngineUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSetPushPushServiceImpl
implements DataSetPushService {
    private static final Logger logger = LoggerFactory.getLogger(DataSetPushPushServiceImpl.class);
    @Autowired
    private DfProperties dfProperties;
    @Autowired
    private DataSetService dataSetService;

    public ApiResponse<Boolean> publishDataSet(Long modelId) throws IOException, LcdpException {
        DataSetProcessor processor = DataSetUtil.processor(DataSetUtil.getDataSetType(modelId));
        processor.sync(String.valueOf(modelId));
        processor.publish(String.valueOf(modelId));
        return ApiResponse.success((Object)true);
    }

    public void getmetaColumn(List<ProjectionField> projectionFields, TableInfoDto tableInfo, List<MetadataColumn> metaColumnList) {
        for (ProjectionField projectionField : projectionFields) {
            for (MetadataColumn metadataColumn : tableInfo.getColumnList()) {
                if (!projectionField.getField().equals(metadataColumn.getColumnName()) || !projectionField.getTable().equals(metadataColumn.getTableName())) continue;
                metadataColumn.setColumnAlias(projectionField.getFieldAlias());
                metaColumnList.add(metadataColumn);
            }
        }
    }

    public void syncData(DataSetModel dataSetModel) throws IOException, LcdpException {
        String dataSourceId = String.valueOf(dataSetModel.getDataSourceId());
        if (dataSetModel.getTables().size() > 1) {
            DataSetSuncModel dataSetSuncModel = this.getDataSetSuncModel(dataSetModel);
            DataSetTables masterTable = dataSetSuncModel.getMasterTable();
            this.sync(masterTable, dataSourceId);
            List salveTable = dataSetSuncModel.getSavleTable();
            for (DataSetTables dataSetTables : salveTable) {
                this.sync(dataSetTables, dataSourceId);
            }
            this.syncMasterModel(dataSetModel);
        } else {
            this.sync((DataSetTables)dataSetModel.getTables().get(0), dataSourceId);
            this.syncModel(dataSetModel, ((DataSetTables)dataSetModel.getTables().get(0)).getName());
        }
    }

    public void noCodesync(DataSetModel dataSetModel) throws IOException, LcdpException {
        if (dataSetModel.getTables().size() > 1) {
            this.syncMasterModel(dataSetModel);
        } else {
            this.syncModel(dataSetModel, ((DataSetTables)dataSetModel.getTables().get(0)).getName());
        }
    }

    public ApiResponse<Object> previewData(DataSetModel dataSetModel) throws IOException, LcdpException {
        if (ToolUtil.isEmpty((Object)dataSetModel.getTables())) {
            return ApiResponse.fail((String)"\u6570\u636e\u96c6\u672a\u9009\u62e9\u8868");
        }
        if (this.dfProperties.isLowCode()) {
            this.syncData(dataSetModel);
        } else {
            this.noCodesync(dataSetModel);
        }
        String sql = (String)this.dataSetService.generateSql(dataSetModel).getData();
        HussarDdlService hussarDdlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        ArrayList<MetadataColumn> metaColumnList = new ArrayList<MetadataColumn>();
        List dataSetTablesList = dataSetModel.getTables();
        List projectionFields = dataSetModel.getProjection();
        String pollName = null;
        for (DataSetTables dataSetTables : dataSetTablesList) {
            TableInfoDto tableInfo = DfExternalApiUtil.getTableByName(dataSetTables.getName(), false);
            pollName = tableInfo.getPollName();
            this.getmetaColumn(projectionFields, tableInfo, metaColumnList);
        }
        CustomSqlDto customSqlDto = new CustomSqlDto();
        customSqlDto.setSql(sql);
        customSqlDto.setColumnList(metaColumnList);
        customSqlDto.setPollName(pollName);
        Page page = new Page((long)dataSetModel.getPage().intValue(), (long)dataSetModel.getPageSize().intValue());
        page.setOptimizeCountSql(false);
        customSqlDto.setPage(page);
        Object object = hussarDdlService.customSql(customSqlDto);
        return ApiResponse.success((Object)object);
    }

    public void syncModel(DataSetModel dataSetModel, String tableName) {
        ModelRelateService modelRelateService = (ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class);
        ArrayList<ModelPublishDTO> resultList = new ArrayList<ModelPublishDTO>();
        ModelPublishDTO mpdto = DfOperationUtil.ModelToEngine(dataSetModel, tableName);
        mpdto.setType("single");
        resultList.add(mpdto);
        modelRelateService.save(resultList);
    }

    public DataSetSuncModel getDataSetSuncModel(DataSetModel dataSetModel) {
        List dataSetTables = dataSetModel.getTables();
        ArrayList<DataSetTables> slaveTables = new ArrayList<DataSetTables>();
        DataSetSuncModel dataSetSuncModel = new DataSetSuncModel();
        DataSetTables masterTable = null;
        for (DataSetTables dataSetTable : dataSetTables) {
            if (dataSetTable.isPrimaryTable()) {
                masterTable = dataSetTable;
                continue;
            }
            slaveTables.add(dataSetTable);
        }
        dataSetSuncModel.setTfModelId(String.valueOf(dataSetModel.getDataSetId()));
        dataSetSuncModel.setMasterTable(masterTable);
        dataSetSuncModel.setTfmodelname(dataSetModel.getDataSetCode());
        dataSetSuncModel.setSavleTable(slaveTables);
        dataSetSuncModel.setRelationShip(dataSetModel.getRelationship());
        dataSetSuncModel.setProjectionFieldList(dataSetModel.getProjection());
        return dataSetSuncModel;
    }

    public void syncMasterModel(DataSetModel dataSetModel) {
        DataSetSuncModel dataSetSuncModel = this.getDataSetSuncModel(dataSetModel);
        List relationships = dataSetModel.getRelationship();
        ModelPublishDTO masterTableInfo = DfOperationUtil.MasterModelToEngine(dataSetModel.getProjection(), dataSetSuncModel.getMasterTable(), dataSetModel.getDataSetCode(), String.valueOf(dataSetModel.getDataSetId()));
        if (ToolUtil.isNotEmpty((Object)masterTableInfo)) {
            masterTableInfo.setParamName(DfDataModelUtil.convertToCamelCase(dataSetSuncModel.getMasterTable().getName()));
        }
        masterTableInfo.setType("master");
        HeRelationDTO relationDTO = DfDataModelUtil.slaveRelationSync(masterTableInfo, dataSetSuncModel, relationships, "master");
        ArrayList<ModelPublishDTO> resultList = new ArrayList<ModelPublishDTO>();
        resultList.add(relationDTO.getMasterPublishDTO());
        resultList.addAll(relationDTO.getSlavePublishDTO());
        ((ModelRelateService)SpringUtil.getBean(ModelRelateService.class)).save(resultList);
    }

    public void sync(DataSetTables dataSetTables, String dataSourceId) {
        MetadataParam metadataParam = this.getMetadataParam(dataSetTables, dataSourceId);
        TableInfoDto tableInfoByTableName = DfExternalApiUtil.getTableByName(dataSetTables.getName(), false);
        if (tableInfoByTableName == null) {
            DfExternalApiUtil.insertTableInfo(metadataParam);
        } else {
            Long tableId = tableInfoByTableName.getTableId();
            metadataParam.getTableInfo().setTableId(tableId);
            DfExternalApiUtil.updateTableInfo(metadataParam);
        }
    }

    public MetadataParam getMetadataParam(DataSetTables dataSetTable, String dataSourceId) {
        MetadataParam metadataParam = new MetadataParam();
        metadataParam.setTableInfo(this.getTableInfoDto(dataSetTable, Long.parseLong(dataSourceId)));
        metadataParam.setColumnInfo(this.getColumnInfoDto(dataSetTable.getFields(), dataSetTable.getTableId()));
        return metadataParam;
    }

    public TableInfoDto getTableInfoDto(DataSetTables dataSetTable, long dataSourceId) {
        TableInfoDto tableInfoDto = new TableInfoDto();
        tableInfoDto.setTableName(dataSetTable.getName());
        tableInfoDto.setTableAlias(dataSetTable.getTableAlias());
        tableInfoDto.setTableDec(dataSetTable.getDescription());
        SysDataSource datasource = DfExternalApiUtil.getDataSourceId(dataSourceId);
        tableInfoDto.setPollName(datasource.getDbName());
        tableInfoDto.setDatasourceId(Long.valueOf(dataSourceId));
        return tableInfoDto;
    }

    public List<ColumnInfoDto> getColumnInfoDto(List<DataSetTableField> dataSetTableFields, String tableId) {
        ArrayList<ColumnInfoDto> columnInfoDtos = new ArrayList<ColumnInfoDto>();
        if (this.dfProperties.isLowCode()) {
            tableId = String.valueOf(LrEngineUtil.nextId());
        }
        for (DataSetTableField dataSetTableField : dataSetTableFields) {
            ColumnInfoDto columnInfoDto = new ColumnInfoDto();
            columnInfoDto.setColumnName(dataSetTableField.getRealName());
            columnInfoDto.setColumnAlias(dataSetTableField.getName());
            columnInfoDto.setColumnComment(dataSetTableField.getComment());
            if ("PRI".equals(dataSetTableField.getPrimarys())) {
                columnInfoDto.setPurpose("1");
            }
            columnInfoDto.setDataLength(dataSetTableField.getDataLength());
            columnInfoDto.setDataDot(dataSetTableField.getDataDot());
            columnInfoDto.setDataIsEmpty(Integer.valueOf(dataSetTableField.isDataIsEmpty() ? 1 : 0));
            Optional<DfEngineColumnType> engineColumnType = DfEngineColumnTypeUtil.getEngineColumnType(this.getDataType(dataSetTableField.getType()));
            if (engineColumnType.isPresent()) {
                columnInfoDto.setJdbcType(engineColumnType.get().getJdbcType().getName());
                columnInfoDto.setDataType(engineColumnType.get().getJdbcType().getName());
                columnInfoDto.setJavaType(engineColumnType.get().getJavaType());
            }
            columnInfoDto.setTableId(Long.valueOf(tableId));
            columnInfoDtos.add(columnInfoDto);
        }
        return columnInfoDtos;
    }

    public String getDataType(String dataType) {
        switch (dataType.toUpperCase()) {
            case "CHAR": 
            case "VARCHAR": 
            case "ENUM": 
            case "STRING": {
                return "String";
            }
            case "DATE": 
            case "TIME": 
            case "YEAR": 
            case "DATETIME": 
            case "TIMESTAMP": {
                return "date";
            }
            case "INT": 
            case "NUM": 
            case "SMALLINT": 
            case "MEDIUMINT": 
            case "INTEGER": 
            case "BIGINT": 
            case "LONG": {
                return "int";
            }
            case "FLOAT": 
            case "DOUBLE": 
            case "DECIMAL": {
                return "double";
            }
            case "BIT": 
            case "TINYINT": 
            case "BOOLEAN": {
                return "BOOLEAN";
            }
            case "TEXT": 
            case "TINYTEXT": 
            case "MEDIUMTEXT": 
            case "LONGTEXT": {
                return "text";
            }
        }
        return dataType;
    }
}

