/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cloud.common.xss.core;

import cn.hutool.core.util.StrUtil;
import com.jxdinfo.hussar.cloud.common.xss.config.HussarXssProperties;
import com.jxdinfo.hussar.cloud.common.xss.core.XssCleanIgnore;
import com.jxdinfo.hussar.cloud.common.xss.core.XssHolder;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class XssCleanInterceptor
extends HandlerInterceptorAdapter {
    private final HussarXssProperties xssProperties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!this.xssProperties.isEnabled()) {
            return true;
        }
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        if (!StrUtil.equalsAnyIgnoreCase((CharSequence)request.getMethod(), (CharSequence[])new CharSequence[]{HttpMethod.POST.name(), HttpMethod.PUT.name()})) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        XssCleanIgnore xssCleanIgnore = (XssCleanIgnore)AnnotationUtils.findAnnotation((Method)handlerMethod.getMethod(), XssCleanIgnore.class);
        if (xssCleanIgnore == null) {
            XssHolder.setEnable();
        }
        return true;
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) {
        XssHolder.remove();
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        XssHolder.remove();
    }

    public XssCleanInterceptor(HussarXssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }
}

