/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cloud.common.xss;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.jxdinfo.hussar.cloud.common.xss.config.HussarXssProperties;
import com.jxdinfo.hussar.cloud.common.xss.core.FormXssClean;
import com.jxdinfo.hussar.cloud.common.xss.core.JacksonXssClean;
import com.jxdinfo.hussar.cloud.common.xss.core.XssCleanInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={HussarXssProperties.class})
@ConditionalOnProperty(value={"security.xss.enabled"}, havingValue="true", matchIfMissing=true)
public class HussarXssAutoConfiguration
implements WebMvcConfigurer {
    private final HussarXssProperties xssProperties;

    @Bean
    public FormXssClean formXssClean() {
        return new FormXssClean();
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer xssJacksonCustomizer() {
        return builder -> builder.deserializerByType(String.class, (JsonDeserializer)new JacksonXssClean());
    }

    public void addInterceptors(InterceptorRegistry registry) {
        XssCleanInterceptor interceptor = new XssCleanInterceptor(this.xssProperties);
        registry.addInterceptor((HandlerInterceptor)interceptor).addPathPatterns(this.xssProperties.getPathPatterns()).excludePathPatterns(this.xssProperties.getExcludePatterns()).order(Integer.MAX_VALUE);
    }

    public HussarXssAutoConfiguration(HussarXssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }
}

