/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cloud.common.gateway.support;

import cn.hutool.cache.Cache;
import cn.hutool.cache.CacheUtil;
import com.jxdinfo.hussar.cloud.common.gateway.vo.RouteDefinitionVo;
import java.util.ArrayList;
import java.util.List;

public final class RouteCacheHolder {
    private static Cache<String, RouteDefinitionVo> cache = CacheUtil.newLFUCache((int)50);

    public static List<RouteDefinitionVo> getRouteList() {
        ArrayList<RouteDefinitionVo> routeList = new ArrayList<RouteDefinitionVo>();
        cache.forEach(route -> routeList.add((RouteDefinitionVo)route));
        return routeList;
    }

    public static void setRouteList(List<RouteDefinitionVo> routeList) {
        routeList.forEach(route -> cache.put((Object)route.getId(), route));
    }

    public static void removeRouteList() {
        cache.clear();
    }

    private RouteCacheHolder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

