/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cloud.common.gateway.support;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.hussar.cloud.common.gateway.support.RouteCacheHolder;
import com.jxdinfo.hussar.cloud.common.gateway.vo.RouteDefinitionVo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionRepository;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class RedisRouteDefinitionWriter
implements RouteDefinitionRepository {
    private static final Logger log = LoggerFactory.getLogger(RedisRouteDefinitionWriter.class);
    private final RedisTemplate redisTemplate;

    public Mono<Void> save(Mono<RouteDefinition> route) {
        return route.flatMap(r -> {
            RouteDefinitionVo vo = new RouteDefinitionVo();
            BeanUtils.copyProperties((Object)r, (Object)vo);
            log.info("\u4fdd\u5b58\u8def\u7531\u4fe1\u606f{}", (Object)vo);
            this.redisTemplate.opsForHash().put((Object)"global:gateway_route_key", (Object)r.getId(), (Object)vo);
            this.redisTemplate.convertAndSend("gateway_jvm_route_reload_topic", (Object)"\u65b0\u589e\u8def\u7531\u4fe1\u606f,\u7f51\u5173\u7f13\u5b58\u66f4\u65b0");
            return Mono.empty();
        });
    }

    public Mono<Void> delete(Mono<String> routeId) {
        routeId.subscribe(id -> {
            log.info("\u5220\u9664\u8def\u7531\u4fe1\u606f{}", id);
            this.redisTemplate.opsForHash().delete((Object)"global:gateway_route_key", new Object[]{id});
        });
        this.redisTemplate.convertAndSend("gateway_jvm_route_reload_topic", (Object)"\u5220\u9664\u8def\u7531\u4fe1\u606f,\u7f51\u5173\u7f13\u5b58\u66f4\u65b0");
        return Mono.empty();
    }

    public Flux<RouteDefinition> getRouteDefinitions() {
        List<RouteDefinitionVo> routeList = RouteCacheHolder.getRouteList();
        if (CollUtil.isNotEmpty(routeList)) {
            log.debug("\u5185\u5b58 \u4e2d\u8def\u7531\u5b9a\u4e49\u6761\u6570\uff1a {}\uff0c {}", (Object)routeList.size(), routeList);
            return Flux.fromIterable(routeList);
        }
        List values = this.redisTemplate.opsForHash().values((Object)"global:gateway_route_key");
        log.debug("redis \u4e2d\u8def\u7531\u5b9a\u4e49\u6761\u6570\uff1a {}\uff0c {}", (Object)values.size(), (Object)values);
        RouteCacheHolder.setRouteList(values);
        return Flux.fromIterable((Iterable)values);
    }

    public RedisRouteDefinitionWriter(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

