/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cloud.common.gateway.rule;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.jxdinfo.hussar.cloud.common.gateway.rule.GrayLoadBalancer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.gateway.support.NotFoundException;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class VersionGrayLoadBalancer
implements GrayLoadBalancer {
    private static final Logger log = LoggerFactory.getLogger(VersionGrayLoadBalancer.class);
    private DiscoveryClient discoveryClient;

    @Override
    public ServiceInstance choose(String serviceId, ServerHttpRequest request) {
        List instances = this.discoveryClient.getInstances(serviceId);
        if (CollUtil.isEmpty((Collection)instances)) {
            log.warn("No instance available for {}", (Object)serviceId);
            throw new NotFoundException("No instance available for " + serviceId);
        }
        String reqVersion = request.getHeaders().getFirst("VERSION");
        if (StrUtil.isBlank((CharSequence)reqVersion)) {
            return (ServiceInstance)instances.get(RandomUtil.randomInt((int)instances.size()));
        }
        for (ServiceInstance instance : instances) {
            Map metadata = instance.getMetadata();
            String targetVersion = MapUtil.getStr((Map)metadata, (Object)"VERSION");
            if (!reqVersion.equalsIgnoreCase(targetVersion)) continue;
            log.debug("gray requst match success :{} {}", (Object)reqVersion, (Object)instance);
            return instance;
        }
        return (ServiceInstance)instances.get(RandomUtil.randomInt((int)instances.size()));
    }

    public VersionGrayLoadBalancer(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }
}

