/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cloud.common.gateway.configuration;

import com.jxdinfo.hussar.cloud.common.gateway.filter.GrayReactiveLoadBalancerClientFilter;
import com.jxdinfo.hussar.cloud.common.gateway.rule.GrayLoadBalancer;
import com.jxdinfo.hussar.cloud.common.gateway.rule.VersionGrayLoadBalancer;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.gateway.config.GatewayReactiveLoadBalancerClientAutoConfiguration;
import org.springframework.cloud.gateway.config.LoadBalancerProperties;
import org.springframework.cloud.gateway.filter.ReactiveLoadBalancerClientFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={LoadBalancerProperties.class})
@ConditionalOnProperty(value={"gray.rule.enabled"}, havingValue="true")
@AutoConfigureBefore(value={GatewayReactiveLoadBalancerClientAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
public class GrayLoadBalancerClientConfiguration {
    @Bean
    public ReactiveLoadBalancerClientFilter gatewayLoadBalancerClientFilter(GrayLoadBalancer grayLoadBalancer, LoadBalancerProperties properties) {
        return new GrayReactiveLoadBalancerClientFilter(properties, grayLoadBalancer);
    }

    @Bean
    public GrayLoadBalancer grayLoadBalancer(DiscoveryClient discoveryClient) {
        return new VersionGrayLoadBalancer(discoveryClient);
    }
}

