/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cloud.common.gateway.configuration;

import com.jxdinfo.hussar.cloud.common.core.util.HussarCoreSpringContextHolder;
import com.jxdinfo.hussar.cloud.common.gateway.exception.RouteCheckException;
import com.jxdinfo.hussar.cloud.common.gateway.support.DynamicRouteHealthIndicator;
import com.jxdinfo.hussar.cloud.common.gateway.support.RouteCacheHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.gateway.config.GatewayProperties;
import org.springframework.cloud.gateway.config.PropertiesRouteDefinitionLocator;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

@Configuration
@ComponentScan(value={"com.jxdinfo.hussar.cloud.common.gateway"})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
public class DynamicRouteAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DynamicRouteAutoConfiguration.class);

    @Bean
    public PropertiesRouteDefinitionLocator propertiesRouteDefinitionLocator() {
        return new PropertiesRouteDefinitionLocator(new GatewayProperties());
    }

    @Bean
    public RedisMessageListenerContainer redisContainer(RedisConnectionFactory redisConnectionFactory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(redisConnectionFactory);
        container.addMessageListener((message, bytes) -> {
            log.warn("\u63a5\u6536\u5230\u91cd\u65b0JVM \u91cd\u65b0\u52a0\u8f7d\u8def\u7531\u4e8b\u4ef6");
            RouteCacheHolder.removeRouteList();
            HussarCoreSpringContextHolder.publishEvent((ApplicationEvent)new RefreshRoutesEvent((Object)this));
        }, (Topic)new ChannelTopic("gateway_jvm_route_reload_topic"));
        return container;
    }

    @Bean
    public DynamicRouteHealthIndicator healthIndicator(RedisTemplate redisTemplate) {
        if (!redisTemplate.hasKey((Object)"global:gateway_route_key").booleanValue()) {
            throw new RouteCheckException("\u8def\u7531\u4fe1\u606f\u672a\u521d\u59cb\u5316\uff0c\u7f51\u5173\u542f\u52a8\u5931\u8d25");
        }
        return new DynamicRouteHealthIndicator(redisTemplate);
    }
}

