/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.fss.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.fss.common.auth.CredentialsProvider;
import com.jxdinfo.fss.common.auth.DefaultCredentialProvider;
import com.jxdinfo.fss.internal.FSSOperation;
import com.jxdinfo.fss.internal.TokenOperation;
import com.jxdinfo.fss.model.DeleteRequest;
import com.jxdinfo.fss.model.DownloadRequest;
import com.jxdinfo.fss.model.ExceptionResponse;
import com.jxdinfo.fss.model.ResponseResult;
import com.jxdinfo.fss.model.UploadRequest;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class FileOperation
extends FSSOperation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseResult simpleUpload(UploadRequest uploadRequest, String token, String md5) {
        ResponseResult fileResult = new ResponseResult();
        CloseableHttpClient httpclient = null;
        CloseableHttpResponse response = null;
        try {
            httpclient = HttpClients.createDefault();
            URI uri = new URIBuilder().setScheme(uploadRequest.getScheme()).setHost(this.endpoint).setPath(uploadRequest.getPath()).build();
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setHeader("Authorization", token);
            HttpEntity reqEntity = null;
            if (uploadRequest.getFile() != null) {
                File file = uploadRequest.getFile();
                FileBody fileBody = new FileBody(file);
                reqEntity = MultipartEntityBuilder.create().setCharset(Charset.forName("utf-8")).addPart("file", (ContentBody)fileBody).addTextBody("fileMD5", md5).addTextBody("fileType", (String)uploadRequest.getMetadata().get("fileType")).build();
            } else {
                InputStream input = uploadRequest.getInputStream();
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.setCharset(Charset.forName("utf-8"));
                builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                builder.addBinaryBody("file", input, ContentType.create((String)"multipart/form-data"), (String)uploadRequest.getMetadata().get("fileName"));
                builder.addTextBody("fileMD5", md5);
                builder.addTextBody("fileType", (String)uploadRequest.getMetadata().get("fileType"));
                reqEntity = builder.build();
            }
            httpPost.setEntity(reqEntity);
            response = httpclient.execute((HttpUriRequest)httpPost);
            ExceptionResponse exceptionResponse = (ExceptionResponse)JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()), ExceptionResponse.class);
            fileResult.setExceptionResponse(exceptionResponse);
            fileResult.setCallbackResponseBody(response.getEntity().getContent());
            System.out.println("===============\u6587\u4ef6\u4e0a\u4f20\u6210\u529f===============");
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpclient != null) {
                    httpclient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseResult simpleDownload(DownloadRequest downloadRequest, HttpServletResponse httpResponse, String token) {
        ResponseResult fileResult = new ResponseResult();
        CloseableHttpClient httpclient = null;
        CloseableHttpResponse response = null;
        try {
            httpclient = HttpClients.createDefault();
            URI uri = new URIBuilder().setScheme(downloadRequest.getScheme()).setHost(this.endpoint).setPath(downloadRequest.getPath()).setParameter("fileId", CollectionUtil.join(downloadRequest.getKeys(), (CharSequence)",")).build();
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("Authorization", token);
            response = httpclient.execute((HttpUriRequest)httpGet);
            fileResult.setHttpEntity(response.getEntity());
            System.out.println("===============\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f===============");
            BufferedInputStream bis = null;
            FilterOutputStream bos = null;
            try {
                bis = new BufferedInputStream(fileResult.getHttpEntity().getContent());
                httpResponse.addHeader("Content-Disposition", "attachment;filename=" + FileOperation.getFileName(response));
                httpResponse.setContentType("multipart/form-data");
                bos = new BufferedOutputStream((OutputStream)httpResponse.getOutputStream());
                int byteRead = 0;
                byte[] b = new byte[5120];
                while ((byteRead = ((InputStream)bis).read(b)) != -1) {
                    ((BufferedOutputStream)bos).write(b, 0, byteRead);
                }
                ((BufferedOutputStream)bos).flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (null != bis) {
                        ((InputStream)bis).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (null != bos) {
                        bos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return fileResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseResult fileDelete(DeleteRequest deleteRequest, String token) {
        ResponseResult fileResult = new ResponseResult();
        CloseableHttpClient httpclient = null;
        CloseableHttpResponse response = null;
        try {
            httpclient = HttpClients.createDefault();
            URI uri = new URIBuilder().setScheme(deleteRequest.getScheme()).setHost(this.endpoint).setPath(deleteRequest.getPath()).setParameter("fileId", CollectionUtil.join(deleteRequest.getKeys(), (CharSequence)",")).build();
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("Authorization", token);
            response = httpclient.execute((HttpUriRequest)httpGet);
            ExceptionResponse exceptionResponse = (ExceptionResponse)JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()), ExceptionResponse.class);
            fileResult.setExceptionResponse(exceptionResponse);
            fileResult.setCallbackResponseBody(response.getEntity().getContent());
            System.out.println("===============\u6587\u4ef6\u5220\u9664\u6210\u529f===============");
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpclient != null) {
                    httpclient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileResult;
    }

    public UploadRequest packageRequest(UploadRequest uploadRequest) throws IOException {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        if (uploadRequest.getInputStream() != null) {
            metadata.put("fileName", uploadRequest.getFileName());
            metadata.put("fileSize", Long.toString(uploadRequest.getInputStream().available() / 1024));
            metadata.put("fileType", FileOperation.getType(uploadRequest.getFileName()));
        } else if (uploadRequest.getFile() != null) {
            File file = uploadRequest.getFile();
            metadata.put("fileName", file.getName());
            metadata.put("fileSize", Long.toString(file.length()));
            metadata.put("fileType", FileOperation.getType(file.getName()));
        }
        uploadRequest.setMetadata(metadata);
        return uploadRequest;
    }

    private static String getType(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "UnKnown";
        }
        return fileName.substring(index + 1);
    }

    private static String getFileName(CloseableHttpResponse response) {
        NameValuePair param;
        HeaderElement[] values;
        Header contentHeader = response.getFirstHeader("Content-Disposition");
        String filename = null;
        if (contentHeader != null && (values = contentHeader.getElements()).length == 1 && (param = values[0].getParameterByName("filename")) != null) {
            try {
                filename = new String(param.getValue().toString().getBytes("UTF-8"), "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return filename;
    }

    private TokenOperation getTokenOperation() {
        return new TokenOperation(super.getCredsProvider());
    }

    public FileOperation(CredentialsProvider credsProvider) {
        super(credsProvider);
    }

    private static DefaultCredentialProvider getDefaultCredentialProvider(String accessKeyId, String secretAccessKey) {
        return new DefaultCredentialProvider(accessKeyId, secretAccessKey);
    }

    public ResponseResult checkFileExis(UploadRequest uploadRequest, String token) throws IOException {
        String md5;
        ResponseResult fileResult = new ResponseResult();
        ExceptionResponse exceptionResponse = new ExceptionResponse(500, "");
        InputStream inputStream = null;
        inputStream = null != uploadRequest.getFile() ? new FileInputStream(uploadRequest.getFile()) : uploadRequest.getInputStream();
        InputStream fileInputStream = inputStream;
        if (uploadRequest.getFileMD5() != null && !"".equals(uploadRequest.getFileMD5())) {
            md5 = uploadRequest.getFileMD5();
        } else {
            ByteArrayOutputStream baos = FileOperation.cloneInputStream(inputStream);
            fileInputStream = new ByteArrayInputStream(baos.toByteArray());
            ByteArrayInputStream md5InputStream = new ByteArrayInputStream(baos.toByteArray());
            md5 = this.getFileMD5(md5InputStream);
        }
        CloseableHttpClient httpclient = null;
        CloseableHttpResponse response = null;
        try {
            httpclient = HttpClients.createDefault();
            URI uri = new URIBuilder().setScheme(uploadRequest.getScheme()).setHost(this.endpoint).setPath(uploadRequest.getCheckPath()).setParameter("fileMD5", md5).setParameter("fileName", uploadRequest.getFileName()).build();
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("Authorization", token);
            response = httpclient.execute((HttpUriRequest)httpGet);
            exceptionResponse = (ExceptionResponse)JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()), ExceptionResponse.class);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (exceptionResponse.getCode() == 200) {
            fileResult.setExceptionResponse(exceptionResponse);
            return fileResult;
        }
        if (exceptionResponse.getCode() == 6008) {
            uploadRequest.setInputStream(fileInputStream);
            return this.simpleUpload(uploadRequest, token, md5);
        }
        fileResult.setExceptionResponse(exceptionResponse);
        return fileResult;
    }

    private static ByteArrayOutputStream cloneInputStream(InputStream input) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = input.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            return baos;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getFileMD5(InputStream inputStream) {
        String MD5 = "";
        try {
            BufferedInputStream fis = new BufferedInputStream(inputStream);
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            int length = -1;
            while ((length = fis.read(buffer)) != -1) {
                md.update(buffer, 0, length);
            }
            BigInteger bigInt = new BigInteger(1, md.digest());
            MD5 = bigInt.toString(16);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return MD5;
    }
}

