/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.fss;

import com.jxdinfo.fss.FSS;
import com.jxdinfo.fss.common.auth.CredentialsProvider;
import com.jxdinfo.fss.internal.FileOperation;
import com.jxdinfo.fss.internal.TokenOperation;
import com.jxdinfo.fss.model.DeleteRequest;
import com.jxdinfo.fss.model.DownloadRequest;
import com.jxdinfo.fss.model.ResponseResult;
import com.jxdinfo.fss.model.UploadRequest;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

public class FSSClient
implements FSS {
    private CredentialsProvider credsProvider;
    private String endpoint;
    private FileOperation fileOperation;
    private TokenOperation tokenOperation;

    public FSSClient(String endpoint, CredentialsProvider credsProvider) {
        this.credsProvider = credsProvider;
        this.initOperations();
        this.setEndpoint(endpoint);
    }

    private void initOperations() {
        this.fileOperation = new FileOperation(this.credsProvider);
        this.tokenOperation = new TokenOperation(this.credsProvider);
    }

    public synchronized void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        this.fileOperation.setEndpoint(endpoint);
        this.tokenOperation.setEndpoint(endpoint);
    }

    public ResponseResult simpleUpload(UploadRequest uploadRequest) throws IOException {
        String token = this.tokenOperation.getToken();
        return this.fileOperation.checkFileExis(this.fileOperation.packageRequest(uploadRequest), token);
    }

    public ResponseResult simpleDownload(DownloadRequest downloadRequest, HttpServletResponse httpResponse) {
        String token = this.tokenOperation.getToken();
        return this.fileOperation.simpleDownload(downloadRequest, httpResponse, token);
    }

    public ResponseResult deleteFile(DeleteRequest deleteRequest) {
        String token = this.tokenOperation.getToken();
        return this.fileOperation.fileDelete(deleteRequest, token);
    }

    public String getEndpoint() {
        return this.endpoint;
    }
}

