/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.word.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.Strings;
import com.jxdinfo.document.word.bean.PageRequestBody;
import com.jxdinfo.document.word.dao.WordEditorDetailsMapper;
import com.jxdinfo.document.word.dao.WordModelInfoMapper;
import com.jxdinfo.document.word.dto.WordModelInfoDto;
import com.jxdinfo.document.word.enums.OwnErrorEnum;
import com.jxdinfo.document.word.model.WordEditorDetails;
import com.jxdinfo.document.word.model.WordModelInfo;
import com.jxdinfo.document.word.service.WordModelInfoService;
import com.jxdinfo.document.word.util.PageUtils;
import com.jxdinfo.document.word.vo.WordModelInfoSearchVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="com.jxdinfo.document.word.service.impl.wordModelInfoServiceImpl")
public class WordModelInfoServiceImpl
extends HussarServiceImpl<WordModelInfoMapper, WordModelInfo>
implements WordModelInfoService {
    @Resource
    private WordModelInfoMapper mapper;
    @Resource
    private WordEditorDetailsMapper wordEditorDetailsMapper;

    public ApiResponse<Page<WordModelInfo>> hussarQueryPage(PageRequestBody<WordModelInfo> pageRequestBody) {
        Page page = PageUtils.checkAndGenPage(pageRequestBody);
        WordModelInfo wordModelInfo = (WordModelInfo)pageRequestBody.getParams();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)wordModelInfo);
        queryWrapper.ne(HussarDelflagEntity::getDelFlag, (Object)"1");
        Page list = (Page)this.mapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        List records = list.getRecords();
        List<WordModelInfo> wordModelInfos = WordModelInfoServiceImpl.buildTree(records);
        list.setRecords(wordModelInfos);
        return ApiResponse.success((Object)list);
    }

    public static List<WordModelInfo> buildTree(List<WordModelInfo> allNodes) {
        ArrayList<WordModelInfo> rootNodes = new ArrayList<WordModelInfo>();
        for (WordModelInfo node : allNodes) {
            if (!HussarUtils.isEmpty((Object)node.getParentModelId())) continue;
            rootNodes.add(node);
        }
        for (WordModelInfo rootNode : rootNodes) {
            WordModelInfoServiceImpl.findChildren(rootNode, allNodes);
        }
        return rootNodes;
    }

    private static void findChildren(WordModelInfo parentNode, List<WordModelInfo> allNodes) {
        ArrayList<WordModelInfo> children = new ArrayList<WordModelInfo>();
        for (WordModelInfo node : allNodes) {
            if (!String.valueOf(parentNode.getId()).equals(String.valueOf(node.getParentModelId()))) continue;
            children.add(node);
            WordModelInfoServiceImpl.findChildren(node, allNodes);
        }
        if (!children.isEmpty()) {
            parentNode.setChildModelInfo(children);
        }
    }

    public ApiResponse<WordModelInfoSearchVo> getWordModelInfoById(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(WordModelInfo::getId, (Object)id)).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        List list = this.mapper.selectList((Wrapper)lambdaQueryWrapper);
        WordModelInfoSearchVo wordModelInfoSearchVo = new WordModelInfoSearchVo();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            wordModelInfoSearchVo.setModelId(((WordModelInfo)list.get(0)).getId());
            wordModelInfoSearchVo.setModelName(((WordModelInfo)list.get(0)).getModelName());
            wordModelInfoSearchVo.setModelCode(((WordModelInfo)list.get(0)).getModelCode());
            wordModelInfoSearchVo.setGroupId(((WordModelInfo)list.get(0)).getGroupId());
            wordModelInfoSearchVo.setModelVersion(((WordModelInfo)list.get(0)).getModelVersion());
            wordModelInfoSearchVo.setModelStatus(((WordModelInfo)list.get(0)).getModelStatus());
            wordModelInfoSearchVo.setEditStatus(((WordModelInfo)list.get(0)).getEditStatus());
            wordModelInfoSearchVo.setValidTime(((WordModelInfo)list.get(0)).getValidTime());
            wordModelInfoSearchVo.setDelFlag(((WordModelInfo)list.get(0)).getDelFlag());
            wordModelInfoSearchVo.setCreator(((WordModelInfo)list.get(0)).getCreator());
            wordModelInfoSearchVo.setLastEditor(((WordModelInfo)list.get(0)).getLastEditor());
            wordModelInfoSearchVo.setCreateTime(((WordModelInfo)list.get(0)).getCreateTime());
            wordModelInfoSearchVo.setLastTime(((WordModelInfo)list.get(0)).getLastTime());
        }
        LambdaQueryWrapper detailQueryWrapper = new LambdaQueryWrapper();
        detailQueryWrapper.eq(WordEditorDetails::getDocId, (Object)id);
        List details = this.wordEditorDetailsMapper.selectList((Wrapper)detailQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)details)) {
            wordModelInfoSearchVo.setDetailContent(((WordEditorDetails)details.get(0)).getDetailContent());
            wordModelInfoSearchVo.setDetailOptions(((WordEditorDetails)details.get(0)).getDetailOptions());
        }
        return ApiResponse.success((Object)wordModelInfoSearchVo);
    }

    @HussarTransactional
    public ApiResponse<Long> update(WordModelInfoDto wordModelInfoDto) {
        if (HussarUtils.isEmpty((Object)wordModelInfoDto.getId())) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WordModelInfo::getId, (Object)wordModelInfoDto.getId());
        WordModelInfo wordModelInfo = new WordModelInfo();
        wordModelInfo.setId(wordModelInfoDto.getId());
        wordModelInfo.setModelName(wordModelInfoDto.getModelName());
        wordModelInfo.setGroupId(wordModelInfoDto.getGroupId());
        wordModelInfo.setModelCode(wordModelInfoDto.getModelCode());
        wordModelInfo.setModelVersion(wordModelInfoDto.getModelVersion());
        wordModelInfo.setModelStatus(wordModelInfoDto.getModelStatus());
        wordModelInfo.setEditStatus(wordModelInfoDto.getEditStatus());
        wordModelInfo.setValidTime(wordModelInfoDto.getValidTime());
        int rowInfo = this.mapper.update(wordModelInfo, (Wrapper)queryWrapper);
        WordEditorDetails wordEditorDetails = new WordEditorDetails();
        wordEditorDetails.setDetailContent(wordModelInfoDto.getDetailContent());
        wordEditorDetails.setDetailOptions(wordModelInfoDto.getDetailOptions());
        LambdaQueryWrapper detailQueryWrapper = new LambdaQueryWrapper();
        detailQueryWrapper.eq(WordEditorDetails::getDocId, (Object)wordModelInfoDto.getId());
        int rowDetail = this.wordEditorDetailsMapper.update(wordEditorDetails, (Wrapper)detailQueryWrapper);
        return ApiResponse.success((Object)wordModelInfoDto.getId());
    }

    @HussarTransactional
    public ApiResponse<Long> add(WordModelInfoDto wordModelInfoDto) {
        if (Strings.isNullOrEmpty((String)wordModelInfoDto.getModelName())) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        WordModelInfo wordModelInfo = new WordModelInfo();
        Long modelId = IdUtil.getSnowflakeNextId();
        wordModelInfo.setId(modelId);
        wordModelInfo.setModelName(wordModelInfoDto.getModelName());
        wordModelInfo.setGroupId(wordModelInfoDto.getGroupId());
        wordModelInfo.setModelCode(wordModelInfoDto.getModelCode());
        wordModelInfo.setModelVersion(wordModelInfoDto.getModelVersion());
        wordModelInfo.setModelStatus(wordModelInfoDto.getModelStatus());
        wordModelInfo.setEditStatus(wordModelInfoDto.getEditStatus());
        wordModelInfo.setValidTime(wordModelInfoDto.getValidTime());
        int row = this.mapper.insert(wordModelInfo);
        WordEditorDetails wordEditorDetails = new WordEditorDetails();
        wordEditorDetails.setDocId(modelId);
        wordEditorDetails.setDetailContent(wordModelInfoDto.getDetailContent());
        wordEditorDetails.setDetailOptions(wordModelInfoDto.getDetailOptions());
        int row2 = this.wordEditorDetailsMapper.insert(wordEditorDetails);
        return ApiResponse.success((Object)modelId);
    }

    public ApiResponse<Long> addModelInfo(WordModelInfoDto wordModelInfoDto) {
        if (Strings.isNullOrEmpty((String)wordModelInfoDto.getModelName())) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        WordModelInfo wordModelInfo = new WordModelInfo();
        Long modelId = IdUtil.getSnowflakeNextId();
        wordModelInfo.setId(modelId);
        wordModelInfo.setModelName(wordModelInfoDto.getModelName());
        wordModelInfo.setGroupId(wordModelInfoDto.getGroupId());
        wordModelInfo.setModelCode(wordModelInfoDto.getModelCode());
        wordModelInfo.setModelVersion(wordModelInfoDto.getModelVersion());
        wordModelInfo.setModelStatus(wordModelInfoDto.getModelStatus());
        wordModelInfo.setEditStatus(wordModelInfoDto.getEditStatus());
        wordModelInfo.setValidTime(wordModelInfoDto.getValidTime());
        wordModelInfo.setDetailsId(wordModelInfoDto.getDetailsId());
        int row = this.mapper.insert(wordModelInfo);
        return ApiResponse.success((Object)modelId);
    }

    @HussarTransactional
    public ApiResponse<Boolean> delete(List<Long> ids) {
        if (HussarUtils.isEmpty(ids)) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        ArrayList<WordModelInfo> wordModelInfoList = new ArrayList<WordModelInfo>();
        for (Long id : ids) {
            WordModelInfo wordModelInfo = new WordModelInfo();
            wordModelInfo.setId(id);
            wordModelInfo.setDelFlag("1");
            wordModelInfoList.add(wordModelInfo);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.in(WordModelInfo::getParentModelId, ids)).set(HussarDelflagEntity::getDelFlag, (Object)"1");
        this.update((Wrapper)updateWrapper);
        return ApiResponse.success((Object)this.updateBatchById(wordModelInfoList));
    }

    public WordModelInfo getByWordDetailId(String wordDetailsId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(WordModelInfo::getDetailsId, (Object)wordDetailsId);
        List wordModelInfos = this.mapper.selectList((Wrapper)wrapper);
        if (!wordModelInfos.isEmpty()) {
            return (WordModelInfo)wordModelInfos.get(0);
        }
        return null;
    }

    public Long copyWordModelInfo(WordModelInfo oldWordModelInfo, Long editorDetailsId, Long copyParentModelInfoId) {
        if (HussarUtils.isNotEmpty((Object)oldWordModelInfo)) {
            WordModelInfo wordModelInfo = new WordModelInfo();
            Long modelId = IdUtil.getSnowflakeNextId();
            wordModelInfo.setId(modelId);
            wordModelInfo.setModelName(oldWordModelInfo.getModelName());
            wordModelInfo.setGroupId(oldWordModelInfo.getGroupId());
            wordModelInfo.setModelCode(oldWordModelInfo.getModelCode());
            wordModelInfo.setModelVersion(oldWordModelInfo.getModelVersion());
            wordModelInfo.setModelStatus(oldWordModelInfo.getModelStatus());
            wordModelInfo.setEditStatus(oldWordModelInfo.getEditStatus());
            wordModelInfo.setValidTime(oldWordModelInfo.getValidTime());
            if (HussarUtils.isNotEmpty((Object)editorDetailsId)) {
                wordModelInfo.setDetailsId(String.valueOf(editorDetailsId));
            }
            wordModelInfo.setParentModelId(copyParentModelInfoId);
            boolean isSuccess = this.saveOrUpdate((BaseEntity)wordModelInfo);
            if (isSuccess) {
                return wordModelInfo.getId();
            }
        }
        return null;
    }
}

