/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.word.controller;

import com.jxdinfo.document.word.dto.WordEditSavedVersionDto;
import com.jxdinfo.document.word.model.WordEditHistory;
import com.jxdinfo.document.word.service.IWordEditHistoryService;
import com.jxdinfo.document.word.service.IWordEditSavedVersionService;
import com.jxdinfo.document.word.vo.WordEditSavedVersionListVo;
import com.jxdinfo.document.word.vo.WordEditSavedVersionVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.jxdinfo.document.word.controller.WordEditHistoryController")
@RequestMapping(value={"/hussarDocument/word/editHistory"})
@AuditLog(moduleName="\u7f16\u8f91\u5386\u53f2\u8bb0\u5f55\u8868")
@Api(tags={"\u7f16\u8f91\u5386\u53f2\u8bb0\u5f55\u63a7\u5236\u5668"})
public class WordEditHistoryController {
    @Resource
    private IWordEditHistoryService wordEditHistoryService;
    @Resource
    private IWordEditSavedVersionService wordEditSavedVersionService;

    @GetMapping(value={"/getHistoryList"})
    @AuditLog(moduleName="\u7f16\u8f91\u5386\u53f2\u8bb0\u5f55\u8868", eventDesc="\u8868\u683c\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperation(value="\u67e5\u8be2\u7f16\u8f91\u5386\u53f2\u8bb0\u5f55\u8868\u4fe1\u606f")
    public ApiResponse<List<WordEditHistory>> queryWordEditHistory(@RequestParam Long docId) {
        List wordEditHistoryList = this.wordEditHistoryService.queryWordEditHistory(docId);
        if (HussarUtils.isNotEmpty((Object)wordEditHistoryList)) {
            return ApiResponse.success((Object)wordEditHistoryList);
        }
        return ApiResponse.fail((String)"\u6682\u65e0\u6570\u636e");
    }

    @GetMapping(value={"/rollbackHistoryLastVersion"})
    public ApiResponse<String> rollbackHistoryLastVersion(@RequestParam Long historyId) {
        this.wordEditHistoryService.rollbackWordEditHistoryLastVersion(historyId);
        return ApiResponse.success((String)"\u8fd8\u539f\u6210\u529f");
    }

    @GetMapping(value={"/queryEditSavedVersionList"})
    public ApiResponse<List<WordEditSavedVersionListVo>> queryEditSavedVersionList(@RequestParam(required=false) Long docId) {
        return this.wordEditSavedVersionService.queryHistoryList(docId);
    }

    @GetMapping(value={"/changeHistoryName"})
    public ApiResponse<String> changeHistoryName(@RequestParam Long versionId, @RequestParam String versionName) {
        boolean isUpdate = this.wordEditSavedVersionService.update(versionId, versionName);
        return isUpdate ? ApiResponse.success((String)"\u4fee\u6539\u6210\u529f") : ApiResponse.fail((String)"\u4fee\u6539\u5931\u8d25");
    }

    @PostMapping(value={"/saveEditSavedVersion"})
    public ApiResponse<String> saveEditSavedVersion(@RequestBody WordEditSavedVersionDto dto) {
        return this.wordEditSavedVersionService.save(dto);
    }

    @GetMapping(value={"/getWordEditSavedVersionDetail"})
    public ApiResponse<WordEditSavedVersionVo> getWordEditSavedVersionDetail(@RequestParam(value="versionId") String versionId) {
        if (HussarUtils.isEmpty((Object)versionId)) {
            return ApiResponse.fail((String)"versionId\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.wordEditSavedVersionService.getHistoryDetail(versionId);
    }

    @GetMapping(value={"/deleteSavedVersionById"})
    public ApiResponse<String> deleteSavedVersionById(@RequestParam(value="versionId") String versionId) {
        return this.wordEditSavedVersionService.delete(versionId);
    }
}

