/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.word.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.base.Strings;
import com.jxdinfo.document.word.dao.WordModelGroupInfoMapper;
import com.jxdinfo.document.word.dto.WordModelGroupInfoDto;
import com.jxdinfo.document.word.enums.OwnErrorEnum;
import com.jxdinfo.document.word.model.WordModelGroupInfo;
import com.jxdinfo.document.word.service.WordModelGroupInfoService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.document.word.service.impl.wordModelGroupInfoServiceImpl")
public class WordModelGroupInfoServiceImpl
implements WordModelGroupInfoService {
    @Resource
    private WordModelGroupInfoMapper mapper;

    public ApiResponse<List<WordModelGroupInfo>> getList(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(WordModelGroupInfo::getParentId, (Object)id)).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        List list = this.mapper.selectList((Wrapper)lambdaQueryWrapper);
        return ApiResponse.success((Object)list);
    }

    @HussarTransactional
    public ApiResponse<Integer> update(WordModelGroupInfoDto wordModelGroupInfoDto) {
        if (HussarUtils.isEmpty((Object)wordModelGroupInfoDto.getId())) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        WordModelGroupInfo wordModelGroupInfo = new WordModelGroupInfo();
        wordModelGroupInfo.setId(wordModelGroupInfoDto.getId());
        wordModelGroupInfo.setGroupName(wordModelGroupInfoDto.getGroupName());
        wordModelGroupInfo.setParentId(wordModelGroupInfoDto.getParentId());
        wordModelGroupInfo.setShowSeq(wordModelGroupInfoDto.getShowSeq());
        wordModelGroupInfo.setRoot(wordModelGroupInfoDto.getRoot());
        wordModelGroupInfo.setLeaf(wordModelGroupInfoDto.getLeaf());
        wordModelGroupInfo.setDelFlag("0");
        wordModelGroupInfo.setLastEditor(BaseSecurityUtil.getUser().getId());
        wordModelGroupInfo.setLastTime(LocalDateTime.now());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WordModelGroupInfo::getId, (Object)wordModelGroupInfoDto.getId());
        int row = this.mapper.update(wordModelGroupInfo, (Wrapper)queryWrapper);
        return ApiResponse.success((Object)row);
    }

    @HussarTransactional
    public ApiResponse<Integer> add(WordModelGroupInfoDto wordModelGroupInfoDto) {
        if (Strings.isNullOrEmpty((String)wordModelGroupInfoDto.getGroupName()) || HussarUtils.isEmpty((Object)wordModelGroupInfoDto.getParentId())) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        WordModelGroupInfo wordModelGroupInfo = new WordModelGroupInfo();
        wordModelGroupInfo.setId(wordModelGroupInfoDto.getId());
        wordModelGroupInfo.setGroupName(wordModelGroupInfoDto.getGroupName());
        wordModelGroupInfo.setParentId(wordModelGroupInfoDto.getParentId());
        wordModelGroupInfo.setShowSeq(wordModelGroupInfoDto.getShowSeq());
        wordModelGroupInfo.setRoot(wordModelGroupInfoDto.getRoot());
        wordModelGroupInfo.setLeaf(wordModelGroupInfoDto.getLeaf());
        int row = this.mapper.insert(wordModelGroupInfo);
        return ApiResponse.success((Object)row);
    }

    @HussarTransactional
    public ApiResponse<Integer> delete(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        int row = this.mapper.deleteById(id);
        return ApiResponse.success((Object)row);
    }
}

