/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.word.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.document.common.CommonDocumentInterface;
import com.jxdinfo.document.common.DocumentType;
import com.jxdinfo.document.common.dto.AttachmentInfoDto;
import com.jxdinfo.document.common.dto.DocumentErrorDto;
import com.jxdinfo.document.common.dto.DocumentSaveDetailsDto;
import com.jxdinfo.document.common.enums.DocumentErrorCodeEnum;
import com.jxdinfo.document.common.factory.DocumentConnectorFactory;
import com.jxdinfo.document.common.factory.DocumentFactory;
import com.jxdinfo.document.common.model.DocDataBindInfo;
import com.jxdinfo.document.common.model.DocImportCtx;
import com.jxdinfo.document.common.model.DocumentAttachmentModel;
import com.jxdinfo.document.common.model.GenerateReportParam;
import com.jxdinfo.document.common.model.WordDocTypeInfo;
import com.jxdinfo.document.common.model.WordModelGroupInfo;
import com.jxdinfo.document.common.service.IDocumentConnectorService;
import com.jxdinfo.document.common.service.IDocumentInfoService;
import com.jxdinfo.document.common.service.IFileService;
import com.jxdinfo.document.common.service.IWordCoreService;
import com.jxdinfo.document.common.service.WordModelGroupInfoService;
import com.jxdinfo.document.common.service.impl.DocumentDataBindServiceImpl;
import com.jxdinfo.document.common.service.impl.WordTypeInfoServiceImpl;
import com.jxdinfo.document.common.util.DocumentExportUtil;
import com.jxdinfo.document.common.util.FileUtil;
import com.jxdinfo.document.common.vo.DocumentDetailsVo;
import com.jxdinfo.document.common.vo.DocumentSaveDetailsVo;
import com.jxdinfo.document.common.vo.DocumentSplitVo;
import com.jxdinfo.document.common.vo.ImportStatusVo;
import com.jxdinfo.document.editor.core.word.constant.WordConstant;
import com.jxdinfo.document.editor.core.word.util.DealImageSizeUtil;
import com.jxdinfo.document.word.dao.WordEditorDetailsMapper;
import com.jxdinfo.document.word.dao.WordModelInfoMapper;
import com.jxdinfo.document.word.dto.WordEditorDetailsDto;
import com.jxdinfo.document.word.dto.WordModelInfoDto;
import com.jxdinfo.document.word.enums.OwnErrorEnum;
import com.jxdinfo.document.word.model.WordEditorDetails;
import com.jxdinfo.document.word.model.WordModelInfo;
import com.jxdinfo.document.word.service.IWordDocExportService;
import com.jxdinfo.document.word.service.WordDetailOperationService;
import com.jxdinfo.document.word.service.WordPdfRelationshipService;
import com.jxdinfo.document.word.service.impl.WordDocImportServiceImpl;
import com.jxdinfo.document.word.service.impl.WordEditorDetailsServiceImpl;
import com.jxdinfo.document.word.service.impl.WordModelInfoServiceImpl;
import com.jxdinfo.document.word.utils.DocumentSplitOfUtil;
import com.jxdinfo.document.word.utils.JSExecutor;
import com.jxdinfo.document.word.utils.TypeUtils;
import com.jxdinfo.document.word.vo.WordEditorDetailsVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.document.word.service.impl.WordReportDocumentImpl")
public class WordReportDocumentImpl
implements CommonDocumentInterface,
InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(WordReportDocumentImpl.class);
    @Resource
    private IWordCoreService wordCoreService;
    @Resource
    private WordEditorDetailsServiceImpl wordEditorDetailsService;
    @Resource
    private WordModelInfoServiceImpl wordModelInfoService;
    @Resource
    private IWordDocExportService wordDocExportService;
    @Resource
    private WordPdfRelationshipService wordPdfRelationshipService;
    @Resource
    private IDocumentInfoService documentInfoService;
    @Resource
    private WordTypeInfoServiceImpl wordTypeInfoService;
    @Resource
    private WordDocImportServiceImpl wordDocImportService;
    @Resource
    private DocumentDataBindServiceImpl documentDataBindService;
    @Resource
    private IFileService fileService;
    @Resource
    private WordModelGroupInfoService wordModelGroupInfoService;
    @Resource
    private WordDetailOperationService wordDetailOperationService;

    public DocumentDetailsVo queryDocumentDetail(Long docId) {
        WordEditorDetails wordEditorDetails;
        DocumentDetailsVo documentDetailsVo = new DocumentDetailsVo();
        HashMap<String, Object> extendResult = new HashMap<String, Object>();
        WordModelInfo wordModelInfo = (WordModelInfo)this.wordModelInfoService.getById(docId);
        documentDetailsVo.setType(0);
        documentDetailsVo.setDocumentName(wordModelInfo.getModelName());
        if (HussarUtils.isNotEmpty((Object)wordModelInfo)) {
            extendResult.put("docId", wordModelInfo.getId());
            extendResult.put("groupId", wordModelInfo.getGroupId());
            extendResult.put("modelName", wordModelInfo.getModelName());
            documentDetailsVo.setId(wordModelInfo.getId());
        }
        if (HussarUtils.isNotEmpty((Object)(wordEditorDetails = (WordEditorDetails)this.wordEditorDetailsService.getById((Serializable)((Object)wordModelInfo.getDetailsId()))))) {
            documentDetailsVo.setContent(wordEditorDetails.getDetailContent());
            extendResult.put("detailOptions", wordEditorDetails.getDetailOptions());
        }
        LambdaQueryWrapper wordModelInfoLambdaQueryWrapper = new LambdaQueryWrapper();
        wordModelInfoLambdaQueryWrapper.eq(WordModelInfo::getParentModelId, (Object)docId);
        List wordModelInfos = ((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectList((Wrapper)wordModelInfoLambdaQueryWrapper);
        if (ToolUtil.isNotEmpty((Object)wordModelInfos)) {
            ArrayList<Long> businessIds = new ArrayList<Long>();
            for (WordModelInfo modelInfo : wordModelInfos) {
                businessIds.add(Long.valueOf(modelInfo.getDetailsId()));
            }
            List wordEditorDetailsList = ((WordEditorDetailsMapper)this.wordEditorDetailsService.getBaseMapper()).selectBatchIds(businessIds);
            extendResult.put("childDetails", wordEditorDetailsList);
        }
        documentDetailsVo.setExtendResult(extendResult);
        return documentDetailsVo;
    }

    public Object queryOffice(Long docId) {
        List<WordModelInfo> wordModelInfos;
        WordEditorDetails wordEditorDetails;
        WordEditorDetailsVo wordEditorDetailsVo = new WordEditorDetailsVo();
        HashMap<String, Object> extendResult = new HashMap<String, Object>();
        WordModelInfo wordModelInfo = (WordModelInfo)((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectById(docId);
        if (HussarUtils.isNotEmpty((Object)wordModelInfo)) {
            extendResult.put("docId", wordModelInfo.getId());
            extendResult.put("groupId", wordModelInfo.getGroupId());
            extendResult.put("modelName", wordModelInfo.getModelName());
        }
        if (HussarUtils.isNotEmpty((Object)(wordEditorDetails = (WordEditorDetails)this.wordEditorDetailsService.getById((Serializable)((Object)wordModelInfo.getDetailsId()))))) {
            wordEditorDetailsVo.setWordEditorDetail(wordEditorDetails);
            wordEditorDetailsVo.setDetailsId(wordEditorDetails.getId());
        }
        if (ToolUtil.isNotEmpty(wordModelInfos = this.getChild(docId))) {
            ArrayList<Long> dtlIds = new ArrayList<Long>();
            this.traverseWordModelTreeForListId(wordModelInfos, dtlIds);
            List allEditorDetailsList = ((WordEditorDetailsMapper)this.wordEditorDetailsService.getBaseMapper()).selectBatchIds(dtlIds);
            ArrayList<Long> businessIds = new ArrayList<Long>();
            for (WordModelInfo modelInfo : wordModelInfos) {
                businessIds.add(Long.valueOf(modelInfo.getDetailsId()));
            }
            List wordEditorDetailsList = ((WordEditorDetailsMapper)this.wordEditorDetailsService.getBaseMapper()).selectBatchIds(businessIds);
            this.traverseWordModelTree(wordModelInfos, allEditorDetailsList, wordEditorDetailsList);
            extendResult.put("childDetails", wordEditorDetailsList);
        }
        wordEditorDetailsVo.setExtendResult(extendResult);
        ApiResponse dataBindByIdAPI = this.documentDataBindService.getDataBindById(docId);
        if (dataBindByIdAPI.isSuccess() && HussarUtils.isNotEmpty((Object)dataBindByIdAPI.getData())) {
            DocDataBindInfo data = (DocDataBindInfo)dataBindByIdAPI.getData();
            wordEditorDetailsVo.setDatabindDetails(data.getDataBindDetails());
            wordEditorDetailsVo.setWordDataSet(data.getWordDataSet());
            wordEditorDetailsVo.setInterFaceName(data.getInterFaceName());
        }
        return wordEditorDetailsVo;
    }

    public void traverseWordModelTreeForListId(List<WordModelInfo> nodeList, List<Long> list) {
        if (nodeList == null || nodeList.isEmpty()) {
            return;
        }
        for (WordModelInfo node : nodeList) {
            if (HussarUtils.isNotEmpty((Object)node.getDetailsId())) {
                list.add(Long.valueOf(node.getDetailsId()));
            }
            if (node.getChildModelInfo() == null || node.getChildModelInfo().isEmpty()) continue;
            this.traverseWordModelTreeForListId(node.getChildModelInfo(), list);
        }
    }

    public void traverseWordModelTree(List<WordModelInfo> nodeList, List<WordEditorDetails> allWordEditorDetailsList, List<WordEditorDetails> editorDetailsList) {
        for (int i = 0; i < editorDetailsList.size(); ++i) {
            WordEditorDetails wordEditorDetails = editorDetailsList.get(i);
            String detailsId = String.valueOf(wordEditorDetails.getId());
            List<WordModelInfo> childDitInfoList = this.getChildDitInfo(nodeList, detailsId);
            String modelName = this.getModelNameBydetailsId(nodeList, detailsId);
            wordEditorDetails.setModelName(modelName);
            String checkedTitleIds = this.getCheckedTitleIdsBydetailsId(nodeList, detailsId);
            wordEditorDetails.setCheckedTitleIds(checkedTitleIds);
            for (int j = 0; j < childDitInfoList.size(); ++j) {
                WordModelInfo childDitInfo = childDitInfoList.get(j);
                String childDtlId = childDitInfo.getDetailsId();
                List<WordEditorDetails> childDtls = allWordEditorDetailsList.stream().filter(dtl -> childDtlId.equals(String.valueOf(dtl.getId()))).collect(Collectors.toList());
                if (HussarUtils.isNotEmpty((Object)wordEditorDetails.getChildDetails())) {
                    List childDetails = wordEditorDetails.getChildDetails();
                    childDetails.addAll(childDtls);
                    wordEditorDetails.setChildDetails(childDetails);
                } else {
                    wordEditorDetails.setChildDetails(childDtls);
                }
                if (!HussarUtils.isNotEmpty(childDtls)) continue;
                this.traverseWordModelTree(nodeList, allWordEditorDetailsList, childDtls);
            }
        }
    }

    public List<WordModelInfo> getChildDitInfo(List<WordModelInfo> nodeList, String dtlId) {
        if (nodeList == null || nodeList.isEmpty()) {
            return null;
        }
        for (WordModelInfo node : nodeList) {
            List<WordModelInfo> childDitInfo;
            if (dtlId.equals(node.getDetailsId())) {
                return node.getChildModelInfo();
            }
            if (node.getChildModelInfo() == null || node.getChildModelInfo().isEmpty() || (childDitInfo = this.getChildDitInfo(node.getChildModelInfo(), dtlId)) == null) continue;
            return childDitInfo;
        }
        return null;
    }

    private String getModelNameBydetailsId(List<WordModelInfo> nodeList, String detailsId) {
        if (nodeList == null || nodeList.isEmpty()) {
            return "";
        }
        for (WordModelInfo node : nodeList) {
            String modelNameBydetailsId;
            if (detailsId.equals(node.getDetailsId())) {
                return node.getModelName();
            }
            if (node.getChildModelInfo() == null || node.getChildModelInfo().isEmpty() || !HussarUtils.isNotEmpty((Object)(modelNameBydetailsId = this.getModelNameBydetailsId(node.getChildModelInfo(), detailsId)))) continue;
            return modelNameBydetailsId;
        }
        return "";
    }

    private String getCheckedTitleIdsBydetailsId(List<WordModelInfo> nodeList, String detailsId) {
        if (nodeList == null || nodeList.isEmpty()) {
            return "";
        }
        for (WordModelInfo node : nodeList) {
            String checkedTitleIds;
            if (detailsId.equals(node.getDetailsId())) {
                return node.getCheckedTitleIds();
            }
            if (node.getChildModelInfo() == null || node.getChildModelInfo().isEmpty() || !HussarUtils.isNotEmpty((Object)(checkedTitleIds = this.getCheckedTitleIdsBydetailsId(node.getChildModelInfo(), detailsId)))) continue;
            return checkedTitleIds;
        }
        return "";
    }

    private List<WordModelInfo> getChild(Long parentId) {
        LambdaQueryWrapper qy = new LambdaQueryWrapper();
        qy.eq(WordModelInfo::getParentModelId, (Object)parentId);
        qy.ne(HussarDelflagEntity::getDelFlag, (Object)"1");
        List list = this.wordModelInfoService.list((Wrapper)qy);
        if (HussarUtils.isNotEmpty((Object)list)) {
            for (WordModelInfo wordModelInfo : list) {
                Long id = wordModelInfo.getId();
                List<WordModelInfo> child = this.getChild(id);
                wordModelInfo.setChildModelInfo(child);
            }
        }
        return list;
    }

    public Long addBlankDocument(String documentName, String type) {
        String defaultName = "\u65e0\u6807\u9898\u6587\u6863";
        if (HussarUtils.isNotEmpty((Object)documentName)) {
            defaultName = documentName;
        }
        WordEditorDetails emptyWord = new WordEditorDetails();
        Long wordEditorDetailId = IdUtil.getSnowflakeNextId();
        emptyWord.setId(wordEditorDetailId);
        emptyWord.setDocId(null);
        emptyWord.setExtendedInfo("1");
        emptyWord.setDetailOptions("{\"settingInfo\":{\"waterInfo\":{\"hideSelf\":false,\"selectType\":\"1\",\"waterType\":\"2\",\"waterStyle\":false,\"imageWater\":{\"checked\":false,\"zoom\":\"auto\",\"erosion\":true,\"fileId\":\"\",\"rotate\":\"horizontal\"},\"textWater\":{\"checked\":false,\"content\":\"\",\"rotate\":\"horizontal\",\"fontFamily\":\"SimSun\",\"fontSize\":\"12pt\",\"transparency\":50,\"color\":\"#8F8F8F\"}},\"shading\":\"#ffffff\",\"pagingSeal\":{\"imgSrc\":\"\"},\"threads\":[],\"showThreads\":true,\"textBoxBorderMap\":{}},\"imgStyleMap\":{\"changeState\":false},\"userAgent\":\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36\",\"firstOpenAfterImport\":false,\"docRules\":{\"style\":[],\"visible\":[]},\"listMarkOption\":{\"marginLeftArr\":[],\"customListMark\":[{\"name\":\"none\",\"example\":\"\u65e0\u5217\u8868\"}]}}");
        emptyWord.setDetailContent("{\"type\":\"doc\",\"attrs\":{\"isBindData\":false},\"content\":[{\"type\":\"section\",\"attrs\":{\"HTMLAttributes\":null,\"id\":\"section-default\",\"pageOption\":{\"label\":\"A4\",\"width\":20.99,\"height\":29.77,\"direction\":\"vertical\",\"left\":3.18,\"right\":3.18,\"top\":2.54,\"bottom\":2.54,\"headerTop\":1.5,\"footerBottom\":1.75,\"isdefault\":true,\"gutterPlace\":\"left\",\"gutterWidth\":0},\"headerFooterState\":\"show\",\"pagesNum\":1,\"headerInfo\":{\"headerOption\":{\"first\":false,\"oddEven\":false},\"headerItem\":{\"common\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"odd\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"even\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"first\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"}}},\"footerInfo\":{\"footerOption\":{\"first\":false,\"oddEven\":false},\"footerItem\":{\"common\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"odd\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"even\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"first\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"}}},\"headerOption\":{\"first\":false,\"oddEven\":false},\"footerOption\":{\"first\":false,\"oddEven\":false},\"sectionOrder\":1},\"content\":[{\"type\":\"paragraph\",\"attrs\":{\"textAlign\":\"justify\",\"fontSize\":\"12pt\",\"lineHeight\":{\"label\":\"\u591a\u500d\u884c\u8ddd\",\"value\":1,\"unitLabel\":\"\u500d\",\"defaultCharValue\":12},\"position\":\"relative\",\"offsetTop\":0,\"actualLineHeight\":1.31,\"marginLeft\":{\"value\":0,\"unitLabel\":\"\u5b57\u7b26\",\"defaultCharValue\":12},\"marginRight\":{\"value\":0,\"unitLabel\":\"\u5b57\u7b26\",\"defaultCharValue\":12},\"marginTop\":{\"value\":0,\"unitLabel\":\"\u884c\",\"defaultCharValue\":12},\"actualMarginTop\":0,\"marginBottom\":{\"value\":0,\"unitLabel\":\"\u884c\",\"defaultCharValue\":12},\"actualMarginBottom\":0,\"marginIndent\":{\"value\":0,\"unitLabel\":\"\u884c\",\"defaultCharValue\":12},\"indent\":{\"label\":\"\u65e0\",\"value\":0,\"unitLabel\":\"\u5b57\u7b26\",\"defaultCharValue\":12},\"bindData\":{\"isBindData\":false,\"dataset\":\"\"},\"paragraphBackground\":null,\"marginTopToCalcY\":0,\"marginBottomToCalcY\":0,\"styleRuleIds\":null,\"visibleRuleIds\":null,\"ruleInfo\":{\"bold\":false,\"italic\":false,\"underline\":false,\"deleteline\":false,\"ruleColor\":null,\"ruleBackground\":null,\"ruleHidden\":false},\"id\":null,\"level\":0,\"y\":0,\"height\":0,\"renderInfo\":{\"rows\":[{\"startIndex\":0,\"height\":21}],\"textNum\":0,\"totalHeight\":21},\"pageBreakPos\":{\"pos\":[],\"textNum\":0},\"tocLevel\":0,\"childDetailsId\":null,\"childDocId\":null,\"childModelName\":null}}]}]}");
        ApiResponse<Integer> rows = this.wordEditorDetailsService.addWordEditorDetail(emptyWord);
        WordModelInfoDto wordModelInfoDto = new WordModelInfoDto();
        wordModelInfoDto.setModelName(defaultName);
        wordModelInfoDto.setGroupId(WordConstant.WORD_EMPTY_MODEL_GROUP_ID_DEFAULT);
        wordModelInfoDto.setDetailsId(String.valueOf(wordEditorDetailId));
        ApiResponse<Long> modelApiResponse = this.wordModelInfoService.addModelInfo(wordModelInfoDto);
        int typeCode = TypeUtils.getTypeCodeByName(type);
        if (typeCode < 0) {
            throw new HussarException("\u65e0\u6548\u7684\u6587\u6863\u7c7b\u578b");
        }
        WordDocTypeInfo wordDocTypeInfo = TypeUtils.createWordDocTypeInfo((Long)modelApiResponse.getData(), defaultName, typeCode, WordConstant.WORD_EMPTY_MODEL_GROUP_ID_DEFAULT);
        this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(wordDocTypeInfo);
        return (Long)modelApiResponse.getData();
    }

    public Long copyDocument(Long docId) {
        WordEditorDetails copyWordDetail = new WordEditorDetails();
        if (HussarUtils.isEmpty((Object)docId)) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        WordModelInfo originalWordModelInfo = (WordModelInfo)this.wordModelInfoService.getById(docId);
        if (HussarUtils.isEmpty((Object)originalWordModelInfo)) {
            throw new HussarException(OwnErrorEnum.SYSTEM_NOT_EXIST.getMsg());
        }
        WordEditorDetails originalWordEditorDetails = (WordEditorDetails)this.wordEditorDetailsService.getById((Serializable)((Object)originalWordModelInfo.getDetailsId()));
        if (HussarUtils.isNotEmpty((Object)originalWordEditorDetails)) {
            long detailId = IdUtil.getSnowflakeNextId();
            copyWordDetail.setId(Long.valueOf(detailId));
            copyWordDetail.setDocId(null);
            copyWordDetail.setDetailContent(originalWordEditorDetails.getDetailContent());
            copyWordDetail.setDetailOptions(originalWordEditorDetails.getDetailOptions());
        }
        ApiResponse<Integer> row = this.wordEditorDetailsService.addWordEditorDetail(copyWordDetail);
        WordModelInfoDto copyWordModelInfo = new WordModelInfoDto();
        copyWordModelInfo.setModelName(originalWordModelInfo.getModelName());
        copyWordModelInfo.setGroupId(originalWordModelInfo.getGroupId());
        copyWordModelInfo.setModelCode(originalWordModelInfo.getModelCode());
        copyWordModelInfo.setModelVersion(originalWordModelInfo.getModelVersion());
        copyWordModelInfo.setModelStatus(originalWordModelInfo.getModelStatus());
        copyWordModelInfo.setEditStatus(originalWordModelInfo.getEditStatus());
        copyWordModelInfo.setValidTime(originalWordModelInfo.getValidTime());
        copyWordModelInfo.setDetailsId(String.valueOf(copyWordDetail.getId()));
        ApiResponse<Long> longApiResponse = this.wordModelInfoService.addModelInfo(copyWordModelInfo);
        LambdaQueryWrapper wordModelInfoLambdaQueryWrapper = new LambdaQueryWrapper();
        wordModelInfoLambdaQueryWrapper.eq(WordModelInfo::getParentModelId, (Object)docId);
        List childWordModelInfoList = ((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectList((Wrapper)wordModelInfoLambdaQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)childWordModelInfoList)) {
            Long copyParentModelInfoId = (Long)longApiResponse.getData();
            for (WordModelInfo childWordModelInfo : childWordModelInfoList) {
                WordEditorDetails childEditorDetails = (WordEditorDetails)this.wordEditorDetailsService.getById((Serializable)((Object)childWordModelInfo.getDetailsId()));
                Long copyChildEditorDetailsId = null;
                if (HussarUtils.isNotEmpty((Object)childEditorDetails)) {
                    copyChildEditorDetailsId = this.wordEditorDetailsService.copyEditorDetails(childEditorDetails);
                }
                Long copyChildModelInfoId = this.wordModelInfoService.copyWordModelInfo(childWordModelInfo, copyChildEditorDetailsId, copyParentModelInfoId);
                this.wordTypeInfoService.copyWordTypeInfo(childWordModelInfo.getId(), copyChildModelInfoId, DocumentType.WORD_REPORT.getTypeCode(), originalWordModelInfo.getGroupId(), copyParentModelInfoId);
                this.documentDataBindService.copyDataBind(childWordModelInfo.getId(), copyChildModelInfoId);
            }
        }
        List docTypeInfoList = this.wordTypeInfoService.queryList(docId);
        String modelName = "\u65e0\u6807\u9898\u6587\u6863";
        int typeCode = DocumentType.WORD_REPORT.getTypeCode();
        if (HussarUtils.isNotEmpty((Object)docTypeInfoList)) {
            modelName = ((WordDocTypeInfo)docTypeInfoList.get(0)).getReportName();
            typeCode = ((WordDocTypeInfo)docTypeInfoList.get(0)).getReportType();
        }
        WordDocTypeInfo wordDocTypeInfo = TypeUtils.createWordDocTypeInfo((Long)longApiResponse.getData(), modelName, typeCode, originalWordModelInfo.getGroupId());
        this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(wordDocTypeInfo);
        ApiResponse dataBindByIdAPI = this.documentDataBindService.getDataBindById(docId);
        if (dataBindByIdAPI.isSuccess() && HussarUtils.isNotEmpty((Object)dataBindByIdAPI.getData())) {
            DocDataBindInfo dataBindInfo = (DocDataBindInfo)dataBindByIdAPI.getData();
            DocDataBindInfo copyInfo = new DocDataBindInfo();
            copyInfo.setDataBindId((Long)longApiResponse.getData());
            copyInfo.setDocId((Long)longApiResponse.getData());
            copyInfo.setDataBindDetails(dataBindInfo.getDataBindDetails());
            copyInfo.setWordDataSet(dataBindInfo.getWordDataSet());
            copyInfo.setInterFaceName(dataBindInfo.getInterFaceName());
            this.documentDataBindService.insertOrUpdate(copyInfo);
        }
        return (Long)longApiResponse.getData();
    }

    public void downloadDocument(HttpServletResponse response, Long docId) {
        this.wordDocExportService.exportDoc(response, docId);
    }

    public void previewPDF(HttpServletResponse response, Long docId) {
        Long fileId = this.wordPdfRelationshipService.getFileIdByDocId(docId);
        if (fileId == null) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        this.documentInfoService.getFileStreamByFileId(response, fileId);
    }

    public ApiResponse<InputStream> previewPDF(Long docId) {
        Long fileId = this.wordPdfRelationshipService.getFileIdByDocId(docId);
        if (fileId == null) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        return ApiResponse.success((Object)this.documentInfoService.getFileStreamByFileId(fileId));
    }

    public ApiResponse<Long> importDocument(MultipartFile file, Long groupId, String docName) {
        return this.wordDocImportService.importDoc(file, groupId, docName);
    }

    public void exportDocument(HttpServletResponse response, Long docId) {
        this.wordDocExportService.exportDocument(response, docId);
    }

    public DocDataBindInfo getBindConfig(GenerateReportParam generateReportParam) {
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        DocumentFactory.add((String)DocumentType.WORD_REPORT.getTypeName(), (CommonDocumentInterface)this);
    }

    public Long generateReport(Long id, JSONObject report) {
        ApiResponse queryOfficeObj = this.documentInfoService.queryOffice(id.toString());
        if (!queryOfficeObj.isSuccess() || HussarUtils.isEmpty((Object)queryOfficeObj.getData())) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u6587\u4ef6");
        }
        JSONObject officeDataJson = JSON.parseObject((String)HussarUtils.toJson((Object)queryOfficeObj.getData()));
        JSONObject extendResult = officeDataJson.getJSONObject("extendResult");
        String modelName = (String)extendResult.get((Object)"modelName");
        Long groupId = HussarUtils.toLong((Object)extendResult.get((Object)"groupId"));
        String reportName = modelName + "_report";
        String content = (String)report.get((Object)"content");
        String options = (String)report.get((Object)"options");
        HashMap<String, String> reportData = new HashMap<String, String>();
        reportData.put("detailContent", content);
        reportData.put("detailOptions", options);
        ApiResponse<Long> detailIds = this.wordEditorDetailsService.addWordEditorDetail(null, null, reportData);
        Long detailId = (Long)detailIds.getData();
        WordModelInfoDto wordModelInfoDto = new WordModelInfoDto();
        wordModelInfoDto.setModelName(reportName);
        wordModelInfoDto.setGroupId(groupId);
        wordModelInfoDto.setDetailsId(String.valueOf(detailId));
        ApiResponse<Long> modelApiResponse = this.wordModelInfoService.addModelInfo(wordModelInfoDto);
        this.wordTypeInfoService.addOrUpdateWordDocTypeInfo((Long)modelApiResponse.getData(), reportName, 1, groupId);
        if (detailIds.isSuccess() && modelApiResponse.isSuccess() && modelApiResponse.getData() != null) {
            return (Long)modelApiResponse.getData();
        }
        return null;
    }

    public JSONObject executeJsGenerateReportJson(Long id, String data, boolean fullReplace) {
        ApiResponse queryOfficeObj = this.documentInfoService.queryOffice(id.toString());
        if (!queryOfficeObj.isSuccess() || HussarUtils.isEmpty((Object)queryOfficeObj.getData())) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u6587\u4ef6");
        }
        JSONObject officeDataJson = JSON.parseObject((String)HussarUtils.toJson((Object)queryOfficeObj.getData()));
        JSONObject wordEditorDetail = officeDataJson.getJSONObject("wordEditorDetail");
        String detailContent = (String)wordEditorDetail.get((Object)"detailContent");
        String detailOptions = (String)wordEditorDetail.get((Object)"detailOptions");
        JSONObject result = null;
        if (HussarUtils.isNotEmpty((Object)detailContent) && HussarUtils.isNotEmpty((Object)detailOptions)) {
            result = JSExecutor.executeDealReportJS(detailContent, detailOptions, data, fullReplace);
        }
        return result;
    }

    public DocumentSplitVo getDocumentById(Long docId) {
        WordModelInfo parentDocument = (WordModelInfo)this.wordModelInfoService.getById(docId);
        WordEditorDetails parentDocumentDetail = (WordEditorDetails)this.wordEditorDetailsService.getById((Serializable)((Object)parentDocument.getDetailsId()));
        LambdaQueryWrapper wordModelInfoLambdaQueryWrapper = new LambdaQueryWrapper();
        wordModelInfoLambdaQueryWrapper.eq(WordModelInfo::getParentModelId, (Object)docId);
        wordModelInfoLambdaQueryWrapper.ne(HussarDelflagEntity::getDelFlag, (Object)"1");
        wordModelInfoLambdaQueryWrapper.orderByAsc(HussarBaseEntity::getCreateTime);
        List wordModelInfos = ((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectList((Wrapper)wordModelInfoLambdaQueryWrapper);
        List<Object> wordEditorDetails = new ArrayList<WordEditorDetails>();
        if (ToolUtil.isNotEmpty((Object)wordModelInfos)) {
            ArrayList<Long> businessIds = new ArrayList<Long>();
            for (WordModelInfo wordModelInfo : wordModelInfos) {
                businessIds.add(Long.valueOf(wordModelInfo.getDetailsId()));
            }
            wordEditorDetails = ((WordEditorDetailsMapper)this.wordEditorDetailsService.getBaseMapper()).selectBatchIds(businessIds);
        }
        return DocumentSplitOfUtil.of(parentDocument, parentDocumentDetail, wordModelInfos, wordEditorDetails);
    }

    public Long addBlankDocument(String documentName, String type, String groupId) {
        String defaultName = "\u65e0\u6807\u9898\u6587\u6863";
        Long groupIdLong = Long.parseLong(groupId);
        if (HussarUtils.isNotEmpty((Object)documentName)) {
            defaultName = documentName;
        }
        WordEditorDetails emptyWord = new WordEditorDetails();
        Long wordEditorDetailId = IdUtil.getSnowflakeNextId();
        emptyWord.setId(wordEditorDetailId);
        emptyWord.setDocId(null);
        emptyWord.setExtendedInfo("1");
        emptyWord.setDetailOptions("{\"settingInfo\":{\"waterInfo\":{\"hideSelf\":false,\"selectType\":\"1\",\"waterType\":\"2\",\"waterStyle\":false,\"imageWater\":{\"checked\":false,\"zoom\":\"auto\",\"erosion\":true,\"fileId\":\"\",\"rotate\":\"horizontal\"},\"textWater\":{\"checked\":false,\"content\":\"\",\"rotate\":\"horizontal\",\"fontFamily\":\"SimSun\",\"fontSize\":\"12pt\",\"transparency\":50,\"color\":\"#8F8F8F\"}},\"shading\":\"#ffffff\",\"pagingSeal\":{\"imgSrc\":\"\"},\"threads\":[],\"showThreads\":true,\"textBoxBorderMap\":{}},\"imgStyleMap\":{\"changeState\":false},\"userAgent\":\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36\",\"firstOpenAfterImport\":false,\"docRules\":{\"style\":[],\"visible\":[]},\"listMarkOption\":{\"marginLeftArr\":[],\"customListMark\":[{\"name\":\"none\",\"example\":\"\u65e0\u5217\u8868\"}]}}");
        emptyWord.setDetailContent("{\"type\":\"doc\",\"attrs\":{\"isBindData\":false},\"content\":[{\"type\":\"section\",\"attrs\":{\"HTMLAttributes\":null,\"id\":\"section-default\",\"pageOption\":{\"label\":\"A4\",\"width\":20.99,\"height\":29.77,\"direction\":\"vertical\",\"left\":3.18,\"right\":3.18,\"top\":2.54,\"bottom\":2.54,\"headerTop\":1.5,\"footerBottom\":1.75,\"isdefault\":true,\"gutterPlace\":\"left\",\"gutterWidth\":0},\"headerFooterState\":\"show\",\"pagesNum\":1,\"headerInfo\":{\"headerOption\":{\"first\":false,\"oddEven\":false},\"headerItem\":{\"common\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"odd\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"even\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"first\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"}}},\"footerInfo\":{\"footerOption\":{\"first\":false,\"oddEven\":false},\"footerItem\":{\"common\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"odd\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"even\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"first\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"}}},\"headerOption\":{\"first\":false,\"oddEven\":false},\"footerOption\":{\"first\":false,\"oddEven\":false},\"sectionOrder\":1},\"content\":[{\"type\":\"paragraph\",\"attrs\":{\"textAlign\":\"justify\",\"fontSize\":\"12pt\",\"lineHeight\":{\"label\":\"\u591a\u500d\u884c\u8ddd\",\"value\":1,\"unitLabel\":\"\u500d\",\"defaultCharValue\":12},\"position\":\"relative\",\"offsetTop\":0,\"actualLineHeight\":1.31,\"marginLeft\":{\"value\":0,\"unitLabel\":\"\u5b57\u7b26\",\"defaultCharValue\":12},\"marginRight\":{\"value\":0,\"unitLabel\":\"\u5b57\u7b26\",\"defaultCharValue\":12},\"marginTop\":{\"value\":0,\"unitLabel\":\"\u884c\",\"defaultCharValue\":12},\"actualMarginTop\":0,\"marginBottom\":{\"value\":0,\"unitLabel\":\"\u884c\",\"defaultCharValue\":12},\"actualMarginBottom\":0,\"marginIndent\":{\"value\":0,\"unitLabel\":\"\u884c\",\"defaultCharValue\":12},\"indent\":{\"label\":\"\u65e0\",\"value\":0,\"unitLabel\":\"\u5b57\u7b26\",\"defaultCharValue\":12},\"bindData\":{\"isBindData\":false,\"dataset\":\"\"},\"paragraphBackground\":null,\"marginTopToCalcY\":0,\"marginBottomToCalcY\":0,\"styleRuleIds\":null,\"visibleRuleIds\":null,\"ruleInfo\":{\"bold\":false,\"italic\":false,\"underline\":false,\"deleteline\":false,\"ruleColor\":null,\"ruleBackground\":null,\"ruleHidden\":false},\"id\":null,\"level\":0,\"y\":0,\"height\":0,\"renderInfo\":{\"rows\":[{\"startIndex\":0,\"height\":21}],\"textNum\":0,\"totalHeight\":21},\"pageBreakPos\":{\"pos\":[],\"textNum\":0},\"tocLevel\":0,\"childDetailsId\":null,\"childDocId\":null,\"childModelName\":null}}]}]}");
        ApiResponse<Integer> rows = this.wordEditorDetailsService.addWordEditorDetail(emptyWord);
        WordModelInfoDto wordModelInfoDto = new WordModelInfoDto();
        wordModelInfoDto.setModelName(defaultName);
        wordModelInfoDto.setGroupId(Long.valueOf(Long.parseLong(groupId)));
        wordModelInfoDto.setDetailsId(String.valueOf(wordEditorDetailId));
        ApiResponse<Long> modelApiResponse = this.wordModelInfoService.addModelInfo(wordModelInfoDto);
        int typeCode = TypeUtils.getTypeCodeByName(type);
        if (typeCode < 0) {
            throw new HussarException("\u65e0\u6548\u7684\u6587\u6863\u7c7b\u578b");
        }
        WordDocTypeInfo wordDocTypeInfo = TypeUtils.createWordDocTypeInfo((Long)modelApiResponse.getData(), defaultName, typeCode, groupIdLong);
        this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(wordDocTypeInfo);
        return (Long)modelApiResponse.getData();
    }

    public boolean deleteDocument(Long docId) {
        if (docId == null) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        this.wordTypeInfoService.deleteByReportId(docId);
        ApiResponse<Boolean> result = this.wordModelInfoService.delete(Collections.singletonList(docId));
        return result.isSuccess();
    }

    public void downDocument(HttpServletResponse response, Long docId) {
        this.wordDocExportService.exportDocument(response, docId);
    }

    public void insertOrUpdateDocument(Map<String, JSONObject> sysDocumentMap, String docId) {
        JSONObject extendResultObj = sysDocumentMap.get("extendResult");
        String groupId = extendResultObj.getString("groupId");
        String reportName = extendResultObj.getString("modelName");
        JSONObject wordEditorDetailObj = sysDocumentMap.get("wordEditorDetail");
        JSONObject detailsId = sysDocumentMap.get("detailsId");
        WordEditorDetails wordEditorDetails = (WordEditorDetails)JSON.parseObject((String)JSON.toJSONString((Object)wordEditorDetailObj), WordEditorDetails.class);
        this.wordEditorDetailsService.insertOrUpdate(wordEditorDetails);
        WordModelInfo wordModelInfo = new WordModelInfo();
        wordModelInfo.setId(Long.valueOf(Long.parseLong(docId)));
        wordModelInfo.setModelName(reportName);
        wordModelInfo.setGroupId(Long.valueOf(Long.parseLong(groupId)));
        wordModelInfo.setDetailsId(detailsId.toString());
        this.wordModelInfoService.saveOrUpdate((BaseEntity)wordModelInfo);
    }

    public void createDocumentRelationFile(String documentPath, Long docId) {
        ApiResponse bindInfoResponse;
        List wordDocTypeInfoList;
        ApiResponse documentInfoResponse = this.documentInfoService.queryOffice(String.valueOf(docId));
        if (documentInfoResponse.isSuccess() && HussarUtils.isNotEmpty((Object)documentInfoResponse.getData())) {
            FileUtil.writeJsonToFile((String)JSON.toJSONString((Object)documentInfoResponse.getData()), (String)documentPath, (String)"documentInfo.json");
            JSONObject object = JSON.parseObject((String)JSON.toJSONString((Object)documentInfoResponse.getData()));
            JSONObject wordEditorDetailJSONObj = object.getJSONObject("wordEditorDetail");
            JSONObject extendResultJSONObj = object.getJSONObject("extendResult");
            String groupId = extendResultJSONObj.getString("groupId");
            List groupInfoList = this.wordModelGroupInfoService.getAllParentGroupInfoList(Long.parseLong(groupId));
            if (HussarUtils.isNotEmpty((Object)groupInfoList) && HussarUtils.isNotEmpty((Object)groupInfoList)) {
                FileUtil.writeJsonToFile((String)JSON.toJSONString((Object)groupInfoList), (String)documentPath, (String)"documentGroup.json");
            }
            String modelName = extendResultJSONObj.getString("modelName");
            String detailContent = wordEditorDetailJSONObj.getString("detailContent");
            boolean isImageAndFileOutput = true;
            if (isImageAndFileOutput) {
                String attachmentDir = FileUtil.posixPath((String[])new String[]{documentPath, "\u9644\u4ef6"});
                List attachments = DocumentExportUtil.getAttachmentList((String)detailContent);
                if (HussarUtils.isNotEmpty((Object)attachments)) {
                    for (DocumentAttachmentModel attachment : attachments) {
                        try {
                            ApiResponse fileResponse = this.fileService.backgroundDownload(Long.valueOf(Long.parseLong(attachment.getOriginalFileId())));
                            AttachmentInfoDto modelById = this.fileService.getModelById(Long.valueOf(Long.parseLong(attachment.getOriginalFileId())));
                            attachment.setAttachmentType(modelById.getAttachmentType());
                            FileUtil.writeFileToFileFolder((byte[])((byte[])fileResponse.getData()), (String)attachmentDir, (String)attachment.getFileName());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error("\u9644\u4ef6\u6587\u4ef6\u672a\u627e\u5230:" + e);
                        }
                    }
                    FileUtil.writeJsonToFile((String)JSON.toJSONString((Object)attachments), (String)attachmentDir, (String)"attachment.json");
                }
            }
        }
        if (HussarUtils.isNotEmpty((Object)(wordDocTypeInfoList = this.wordTypeInfoService.queryList(docId)))) {
            FileUtil.writeJsonToFile((String)JSON.toJSONString((Object)wordDocTypeInfoList), (String)documentPath, (String)"wordTypeInfo.json");
        }
        if ((bindInfoResponse = this.documentDataBindService.getDataBindById(docId)).isSuccess() && HussarUtils.isNotEmpty((Object)bindInfoResponse.getData())) {
            IDocumentConnectorService documentConnectorService;
            String dataSetJson;
            FileUtil.writeJsonToFile((String)JSON.toJSONString((Object)bindInfoResponse.getData()), (String)documentPath, (String)"dataSetBindInfo.json");
            String wordDataSet = ((DocDataBindInfo)bindInfoResponse.getData()).getWordDataSet();
            List dataSetIdList = DocumentExportUtil.parseWordDataSetJsonToIdList((String)wordDataSet);
            if (HussarUtils.isNotEmpty((Object)dataSetIdList) && HussarUtils.isNotEmpty((Object)(dataSetJson = (documentConnectorService = DocumentConnectorFactory.getInstance()).connectorDSProcessDataSetExport(dataSetIdList)))) {
                FileUtil.writeJsonToFile((String)dataSetJson, (String)documentPath, (String)"dataSet.json");
            }
        }
    }

    public Long importDocumentData(String unZipPath, String importCacheKey, DocImportCtx docImportCtx) {
        ImportStatusVo importStatusVo = (ImportStatusVo)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey);
        Long docId = null;
        String modelName = "";
        try {
            IDocumentConnectorService documentConnectorService;
            Iterator errorResultDtos;
            String reportPath = FileUtil.posixPath((String[])new String[]{unZipPath, "documentInfo.json"});
            String reportGroupPath = FileUtil.posixPath((String[])new String[]{unZipPath, "documentGroup.json"});
            String dataSetBindInfoPath = FileUtil.posixPath((String[])new String[]{unZipPath, "dataSetBindInfo.json"});
            String dataSetPath = FileUtil.posixPath((String[])new String[]{unZipPath, "dataSet.json"});
            String typeInfoPath = FileUtil.posixPath((String[])new String[]{unZipPath, "wordTypeInfo.json"});
            String attachmentFolderPath = FileUtil.posixPath((String[])new String[]{unZipPath, "\u9644\u4ef6"});
            String attachmentListPath = FileUtil.posixPath((String[])new String[]{attachmentFolderPath, "attachment.json"});
            Map sysDocumentMap = (Map)FileUtil.readFileToObject((String)reportPath, Map.class);
            modelName = ((JSONObject)sysDocumentMap.get("extendResult")).getString("modelName");
            if (HussarUtils.isEmpty((Object)sysDocumentMap)) {
                Map<String, DocumentErrorDto> errors = HussarUtils.isNotEmpty((Object)importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
                DocumentErrorDto error = new DocumentErrorDto();
                error.setName(modelName);
                HashMap<String, Integer> reportError = new HashMap<String, Integer>();
                reportError.put("reportError", DocumentErrorCodeEnum.REPORT_NOT_EXIT.getCode());
                error.setError(reportError);
                errors.put(UUID.randomUUID().toString(), error);
                importStatusVo.setData(errors);
                HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
                return null;
            }
            List wordDocTypeInfoList = FileUtil.readFileToArray((String)typeInfoPath, WordDocTypeInfo.class);
            List wordModelGroupInfoList = FileUtil.readFileToArray((String)reportGroupPath, WordModelGroupInfo.class);
            DocDataBindInfo dataBindInfo = (DocDataBindInfo)FileUtil.readFileToObject((String)dataSetBindInfoPath, DocDataBindInfo.class);
            JSONObject dataSet = (JSONObject)FileUtil.readFileToObject((String)dataSetPath, JSONObject.class);
            importStatusVo.setMsg("\u6b63\u5728\u5bfc\u5165" + modelName + "\u6570\u636e\u96c6");
            if (HussarUtils.isNotEmpty((Object)dataSet) && HussarUtils.isNotEmpty((Object)(errorResultDtos = (documentConnectorService = DocumentConnectorFactory.getInstance()).connectorDSImportDataSet(JSON.toJSONString((Object)dataSet))))) {
                Map<String, DocumentErrorDto> errors = HussarUtils.isNotEmpty((Object)importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
                DocumentErrorDto error = new DocumentErrorDto();
                error.setName(modelName);
                if (HussarUtils.isNotEmpty((Object)dataBindInfo)) {
                    error.setId(dataBindInfo.getDocId());
                }
                HashMap reportError = new HashMap();
                reportError.put("dataSetError", errorResultDtos);
                error.setError(reportError);
                errors.put(UUID.randomUUID().toString(), error);
                importStatusVo.setData(errors);
                HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
                return null;
            }
            List attachmentList = FileUtil.readFileToArray((String)attachmentListPath, DocumentAttachmentModel.class);
            if (HussarUtils.isNotEmpty((Object)attachmentList)) {
                for (DocumentAttachmentModel model : attachmentList) {
                    String filePath;
                    File file;
                    MultipartFile multipartFile;
                    ApiResponse uploadResponse;
                    if ("attachment.json".equals(model.getFileName()) || HussarUtils.isEmpty((Object)model.getFileName()) || !(uploadResponse = this.fileService.upload(multipartFile = FileUtil.convertFileToMultipartFile((File)(file = new File(filePath = FileUtil.posixPath((String[])new String[]{attachmentFolderPath, model.getFileName()}))), (String)model.getAttachmentType()))).isSuccess() || !HussarUtils.isNotEmpty((Object)uploadResponse.getData())) continue;
                    AttachmentInfoDto data = (AttachmentInfoDto)uploadResponse.getData();
                    model.setNewFileId(data.getFileId());
                }
                DocumentExportUtil.changeDocumentAttachmentFileId((Map)sysDocumentMap, (List)attachmentList);
            }
            if (HussarUtils.isNotEmpty((Object)docImportCtx.getGroupId())) {
                JSONObject wordEditorDetailObj = (JSONObject)sysDocumentMap.get("wordEditorDetail");
                WordEditorDetails wordEditorDetails = (WordEditorDetails)JSON.parseObject((String)JSON.toJSONString((Object)wordEditorDetailObj), WordEditorDetails.class);
                wordEditorDetails.setId(null);
                ApiResponse<Long> editorResponse = this.wordEditorDetailsService.insertOrUpdate(wordEditorDetails);
                JSONObject extendResultObj = (JSONObject)sysDocumentMap.get("extendResult");
                String reportName = extendResultObj.getString("modelName");
                Long detailsId = (Long)editorResponse.getData();
                Long groupId = Long.parseLong(docImportCtx.getGroupId());
                docId = IdUtil.getSnowflakeNextId();
                WordModelInfo wordModelInfo = new WordModelInfo();
                wordModelInfo.setId(docId);
                wordModelInfo.setModelName(reportName);
                wordModelInfo.setGroupId(groupId);
                wordModelInfo.setDetailsId(String.valueOf(detailsId));
                this.wordModelInfoService.saveOrUpdate((BaseEntity)wordModelInfo);
                if (HussarUtils.isNotEmpty((Object)dataBindInfo)) {
                    dataBindInfo.setDocId(docId);
                    dataBindInfo.setDataBindId(docId);
                    this.documentDataBindService.insertOrUpdate(dataBindInfo);
                }
                if (HussarUtils.isNotEmpty((Object)wordDocTypeInfoList)) {
                    for (WordDocTypeInfo wordDocTypeInfo : wordDocTypeInfoList) {
                        wordDocTypeInfo.setId(null);
                        wordDocTypeInfo.setReportId(docId);
                        wordDocTypeInfo.setGroupId(groupId);
                        wordDocTypeInfo.setParentReportId(wordModelInfo.getParentModelId());
                        this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(wordDocTypeInfo);
                    }
                }
            } else {
                JSONObject extendResultObj;
                if (HussarUtils.isNotEmpty((Object)wordDocTypeInfoList)) {
                    for (WordDocTypeInfo wordDocTypeInfo : wordDocTypeInfoList) {
                        this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(wordDocTypeInfo);
                        docId = wordDocTypeInfo.getReportId();
                    }
                }
                if (HussarUtils.isNotEmpty((Object)wordModelGroupInfoList)) {
                    this.wordModelGroupInfoService.batchInsertOrUpdate(wordModelGroupInfoList);
                }
                if (HussarUtils.isNotEmpty((Object)dataBindInfo)) {
                    this.documentDataBindService.insertOrUpdate(dataBindInfo);
                }
                if (HussarUtils.isNotEmpty((Object)(extendResultObj = (JSONObject)sysDocumentMap.get("extendResult")))) {
                    docId = HussarUtils.isNotEmpty((Object)extendResultObj.getString("docId")) ? Long.parseLong(extendResultObj.getString("docId")) : docId;
                }
                this.documentInfoService.insertOrUpdateDocument(sysDocumentMap);
            }
        }
        catch (Exception e) {
            Map<String, DocumentErrorDto> errors = HussarUtils.isNotEmpty((Object)importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
            DocumentErrorDto error = new DocumentErrorDto();
            error.setName(modelName);
            if (HussarUtils.isNotEmpty(docId)) {
                error.setId(docId);
            }
            HashMap<String, Exception> reportError = new HashMap<String, Exception>();
            reportError.put("documentError", e);
            error.setError(reportError);
            errors.put(UUID.randomUUID().toString(), error);
            importStatusVo.setData(errors);
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
        }
        return docId;
    }

    public Long dealImageSize(Long docId) {
        WordModelInfo wordModelInfo = (WordModelInfo)((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectById(docId);
        WordEditorDetails wordEditorDetails = (WordEditorDetails)this.wordEditorDetailsService.getById((Serializable)((Object)wordModelInfo.getDetailsId()));
        String wordEditorDetail = wordEditorDetails.getDetailContent();
        JSONObject detailContent = JSONObject.parseObject((String)wordEditorDetail);
        ArrayList nodeIdList = new ArrayList();
        DealImageSizeUtil.recursionImageNode((JSONObject)detailContent, nodeIdList);
        wordEditorDetails.setDetailContent(detailContent.toString());
        this.wordEditorDetailsService.update(wordEditorDetails);
        return docId;
    }

    public ApiResponse<Object> generateReport(GenerateReportParam generateReportParam) {
        return this.wordCoreService.generateWordReport(generateReportParam);
    }

    public ApiResponse<DocumentSaveDetailsVo> saveWordEditorDetail(DocumentSaveDetailsDto documentSaveDetailsDto) {
        WordEditorDetailsDto bean;
        ApiResponse apiResponse;
        Map wordParam = documentSaveDetailsDto.getParam();
        if (HussarUtils.isNotEmpty((Object)wordParam) && HussarUtils.isNotEmpty((Object)(apiResponse = this.wordDetailOperationService.saveWordEditorDetail(bean = (WordEditorDetailsDto)BeanUtil.toBean((Object)wordParam, WordEditorDetailsDto.class)))) && apiResponse.isSuccess()) {
            WordEditorDetailsVo data = (WordEditorDetailsVo)apiResponse.getData();
            DocumentSaveDetailsVo documentSaveDetailsVo = new DocumentSaveDetailsVo();
            if (HussarUtils.isNotEmpty((Object)data)) {
                documentSaveDetailsVo.setResult((Map)((JSONObject)JSONObject.toJSON((Object)data)));
                Map extendResult = data.getExtendResult();
                if (HussarUtils.isNotEmpty((Object)extendResult)) {
                    List infoList;
                    documentSaveDetailsVo.setDocId(extendResult.get("docId").toString());
                    documentSaveDetailsVo.setGroupId(extendResult.get("groupId").toString());
                    documentSaveDetailsVo.setDocName(extendResult.get("modelName").toString());
                    if (HussarUtils.isNotEmpty(extendResult.get("docId")) && HussarUtils.isNotEmpty((Object)(infoList = this.wordTypeInfoService.queryList(Long.valueOf(Long.parseLong(extendResult.get("docId").toString()))))) && !infoList.isEmpty()) {
                        documentSaveDetailsVo.setDocType(((WordDocTypeInfo)infoList.get(0)).getReportType());
                    }
                }
            }
            return ApiResponse.success((Object)documentSaveDetailsVo);
        }
        return null;
    }
}

