/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.word.service.impl;

import com.jxdinfo.document.editor.core.word.factory.WordJsonParseFactory;
import com.jxdinfo.document.word.dao.WordDocInfoMapper;
import com.jxdinfo.document.word.dao.WordEditorDetailsMapper;
import com.jxdinfo.document.word.dto.WordDocInfoDto;
import com.jxdinfo.document.word.model.WordDocInfo;
import com.jxdinfo.document.word.service.WordDocParseService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.document.word.service.impl.wordDocParseServiceImpl")
public class WordDocParseServiceImpl
implements WordDocParseService {
    @Resource
    private WordDocInfoMapper mapper;
    @Resource
    private WordEditorDetailsMapper wordEditorDetailsMapper;

    public ApiResponse<Object> parse(WordDocInfoDto wordDocInfoDto, MultipartFile multipartFile) {
        Map parse = WordJsonParseFactory.get((String)"docx").parse(multipartFile);
        String originalFilename = multipartFile.getOriginalFilename();
        WordDocInfo wordDocInfo = new WordDocInfo();
        String docId = UUID.randomUUID().toString();
        wordDocInfo.setId(Long.valueOf(Long.parseLong(docId)));
        wordDocInfo.setGroupId(wordDocInfoDto.getGroupId());
        wordDocInfo.setDocName(originalFilename);
        wordDocInfo.setCreator(HussarSecurityUtils.getLoginUserDetails().getUserId());
        wordDocInfo.setLastEditor(HussarSecurityUtils.getLoginUserDetails().getUserId());
        wordDocInfo.setDelFlag("0");
        int row = this.mapper.insert(wordDocInfo);
        return ApiResponse.success((String)docId);
    }
}

