/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.word.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.common.CommonDocumentInterface;
import com.jxdinfo.document.common.DocumentType;
import com.jxdinfo.document.common.dto.DocumentSaveDetailsDto;
import com.jxdinfo.document.common.factory.DocumentFactory;
import com.jxdinfo.document.common.model.DocDataBindInfo;
import com.jxdinfo.document.common.model.DocImportCtx;
import com.jxdinfo.document.common.model.GenerateReportParam;
import com.jxdinfo.document.common.service.impl.WordTypeInfoServiceImpl;
import com.jxdinfo.document.common.vo.DocumentDetailsVo;
import com.jxdinfo.document.common.vo.DocumentSaveDetailsVo;
import com.jxdinfo.document.common.vo.DocumentSplitVo;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.FrontendEnum;
import com.jxdinfo.document.excel.tools.core.common.utils.CheckUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.InitDataUtil;
import com.jxdinfo.document.excel.tools.file.service.IOssFileService;
import com.jxdinfo.document.excel.tools.report.impl.ExcelInstanceReportServiceImpl;
import com.jxdinfo.document.excel.tools.word.service.IExcelWordCommonService;
import com.jxdinfo.hussar.application.excel.service.IExcelExporterService;
import com.jxdinfo.hussar.application.reportsnapshot.Vo.SnapShotVo;
import com.jxdinfo.hussar.application.reportsnapshot.model.SysReportSnapshot;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.document.excel.tools.word.service.impl.ExcelInstanceWordServiceImpl")
public class ExcelInstanceWordServiceImpl
implements CommonDocumentInterface,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ExcelInstanceWordServiceImpl.class);
    @Resource
    private ExcelInstanceReportServiceImpl excelInstanceService;
    @Resource
    private IExcelWordCommonService excelWordCommonService;
    @Resource
    private WordTypeInfoServiceImpl wordTypeInfoService;
    @Resource
    private IExcelExporterService excelExporterService;
    @Resource
    private IOssFileService IOssFileService;

    public void checkDocId(Long docId) {
        if (docId == null) {
            throw new IllegalArgumentException(FrontendEnum.RETURN_ID_NULL.getDescription());
        }
    }

    public DocumentDetailsVo queryDocumentDetail(Long reportId) {
        return this.queryOffice(reportId);
    }

    public DocumentDetailsVo queryOffice(Long reportId) {
        logger.info("queryOffice \u542f\u52a8");
        this.checkDocId(reportId);
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u67e5\u8be2\u65b9\u6cd5\uff0c\u8fd4\u56de\u57fa\u7840\u6570\u636e\u4fe1\u606f");
        SysReportSnapshot reportInfo = this.excelInstanceService.getSysReportSnapshotById(reportId);
        DocumentDetailsVo documentDetailsVo = new DocumentDetailsVo();
        documentDetailsVo.setId(reportId);
        documentDetailsVo.setType(DocumentType.EXCEL_REPORT_TOOL_FORM_INSTANCE.getTypeCode());
        documentDetailsVo.setContent(reportInfo.getDesignInformation());
        HashMap<String, Object> extendResult = new HashMap<String, Object>(16);
        extendResult.put("docId", reportId);
        extendResult.put("modelName", reportInfo.getSnapshotName());
        documentDetailsVo.setExtendResult(extendResult);
        return documentDetailsVo;
    }

    public Long addBlankDocument(String documentName, String type) {
        logger.info("\u62a5\u544a\u53ea\u80fd\u751f\u6210 \u65e0\u7a7a\u767d\u521b\u5efa \u542f\u52a8");
        return 0L;
    }

    public Long copyDocument(Long reportId) {
        this.checkDocId(reportId);
        SysReportSnapshot sysReportSnapshotById = this.excelInstanceService.getSysReportSnapshotById(reportId);
        if (sysReportSnapshotById == null) {
            logger.error("\u6839\u636e\u6587\u6863id\u67e5\u8be2\u6587\u6863\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u6392\u67e5\u6587\u6863id\u662f\u5426\u6b63\u786e");
            return 1L;
        }
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u590d\u5236\u65b9\u6cd5\uff0c\u8fd4\u56de\u65b0\u62a5\u544a\u6a21\u677f\u4e3b\u952e");
        SnapShotVo sysReportById = new SnapShotVo();
        sysReportById.setReportId(sysReportSnapshotById.getReportId());
        sysReportById.setSnapshotName(sysReportSnapshotById.getSnapshotName());
        sysReportById.setDesignInformation(sysReportSnapshotById.getDesignInformation());
        sysReportById.setSnapshotName(sysReportSnapshotById.getSnapshotName());
        sysReportById.setDescription(sysReportSnapshotById.getDescription());
        Long newReportId = this.excelInstanceService.copyReport(sysReportById);
        if (newReportId != null) {
            logger.info("\u8c03\u7528\u62a5\u8868\u7684\u590d\u5236\u65b9\u6cd5\uff0c\u8fd4\u56de\u65b0\u62a5\u544a\u4e3b\u952e:{}", (Object)newReportId);
            this.excelWordCommonService.copyDocumentByReport(newReportId.toString(), sysReportSnapshotById.getSnapshotName(), String.valueOf(reportId));
            return reportId;
        }
        return null;
    }

    public void downloadDocument(HttpServletResponse httpServletResponse, Long reportId) {
    }

    public void previewPDF(HttpServletResponse httpServletResponse, Long aLong) {
    }

    public ApiResponse<Long> importDocument(MultipartFile file, Long groupId, String docName) {
        logger.info("importDocument \u62a5\u8868\u5feb\u7167\u65e0\u5bfc\u5165");
        return ApiResponse.success((String)"\u62a5\u8868\u5feb\u7167\u65e0\u5bfc\u5165");
    }

    public void exportDocument(HttpServletResponse httpServletResponse, Long reportId) {
        this.checkDocId(reportId);
        logger.info("exportDocument \u4e0b\u8f7d\u62a5\u8868excel\u6587\u6863\u65b9\u6cd5\u5f00\u59cb");
        Long fileId = this.excelExporterService.exportSnapshotSheet(reportId, new ArrayList(), new ArrayList());
        logger.info("exportDocument \u83b7\u53d6\u62a5\u8868excel\u6587\u6863\u65b9\u6cd5\u7ed3\u675f\uff0c\u8fd4\u56de\u6587\u4ef6id{}", (Object)fileId);
        this.IOssFileService.fileDownload(httpServletResponse, fileId);
    }

    public DocDataBindInfo getBindConfig(GenerateReportParam generateReportParam) {
        return null;
    }

    public Long generateReport(Long aLong, JSONObject jsonObject) {
        return 0L;
    }

    public JSONObject executeJsGenerateReportJson(Long id, String data, boolean fullReplace) {
        return null;
    }

    public DocumentSplitVo getDocumentById(Long aLong) {
        return null;
    }

    public Long addBlankDocument(String documentName, String type, String groupId) {
        if (StringUtils.isBlank((CharSequence)type)) {
            logger.error("type \u53c2\u6570\u7a7a");
        }
        String reportName = StringUtils.isBlank((CharSequence)documentName) ? "\u65e0\u6807\u9898\u6587\u6863" : documentName;
        logger.info("\u6dfb\u52a0\u7a7a\u767d\u6587\u6863addBlankDocument,\u8c03\u7528\u62a5\u8868\u7684\u65b0\u589e\u65b9\u6cd5 addSnapshot \u5f00\u59cb");
        SnapShotVo snapShotVo = new SnapShotVo();
        snapShotVo.setSnapshotName(reportName);
        snapShotVo.setDesignInformation(InitDataUtil.initJsonData());
        Long reportId = this.excelInstanceService.addSnapshot(snapShotVo, groupId);
        logger.info("\u6dfb\u52a0\u7a7a\u767d\u6587\u6863addBlankDocument,\u8c03\u7528\u62a5\u8868\u7684\u65b0\u589e\u65b9\u6cd5 addSnapshot \u7ed3\u675f\uff0c\u8fd4\u56de\u7684\u62a5\u8868\u4e3b\u952e:{}", (Object)reportId);
        return reportId;
    }

    public boolean deleteDocument(Long reportId) {
        this.checkDocId(reportId);
        logger.info("deleteDocument \u5220\u9664\u6587\u6863 \u516c\u5171\u8868 \u5f00\u59cb");
        this.wordTypeInfoService.deleteByReportId(reportId);
        logger.info("deleteDocument \u5220\u9664\u6587\u6863 \u516c\u5171\u8868 \u7ed3\u675f");
        try {
            logger.info("deleteDocument \u5220\u9664\u6587\u6863 \u62a5\u8868\u8868 \u5f00\u59cb");
            boolean result = this.excelInstanceService.delSnapshot(Collections.singletonList(reportId));
            logger.info("deleteDocument \u5220\u9664\u6587\u6863 \u62a5\u8868\u8868 \u7ed3\u675f");
            return result;
        }
        catch (Exception e) {
            logger.error("deleteDocument \u5220\u9664\u6587\u6863 \u62a5\u8868\u8868 \u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public void downDocument(HttpServletResponse httpServletResponse, Long reportId) {
        this.checkDocId(reportId);
        logger.info("downDocument \u4e0b\u8f7d\u62a5\u8868excel\u6587\u6863\u65b9\u6cd5\u5f00\u59cb");
        Long fileId = this.excelExporterService.exportSnapshotSheet(reportId, new ArrayList(), new ArrayList());
        logger.info("downDocument \u83b7\u53d6\u62a5\u8868excel\u6587\u6863\u65b9\u6cd5\u7ed3\u675f\uff0c\u8fd4\u56de\u6587\u4ef6id{}", (Object)fileId);
        this.IOssFileService.fileDownload(httpServletResponse, fileId);
    }

    public void insertOrUpdateDocument(Map<String, JSONObject> sysDocumentMap, String docId) {
        logger.info("insertOrUpdateDocument \u8bf7\u671f\u5f85\u4e0b\u4e2a\u7248\u672c");
    }

    public void createDocumentRelationFile(String documentPath, Long docId) {
        logger.info("createDocumentRelationFile \u8bf7\u671f\u5f85\u4e0b\u4e2a\u7248\u672c");
    }

    public Long importDocumentData(String unZipPath, String cacheKey, DocImportCtx docImportCtx) throws IOException {
        logger.info("importDocumentData \u8bf7\u671f\u5f85\u4e0b\u4e2a\u7248\u672c");
        return null;
    }

    public Long dealImageSize(Long docId) {
        logger.info("dealImageSize \u6682\u4e0d\u5904\u7406");
        return 0L;
    }

    public ApiResponse<Object> generateReport(GenerateReportParam generateReportParam) {
        return null;
    }

    public ApiResponse<DocumentSaveDetailsVo> saveWordEditorDetail(DocumentSaveDetailsDto documentSaveDetailsDto) {
        DocumentSaveDetailsVo result = new DocumentSaveDetailsVo();
        logger.info("saveWordEditorDetail \u8fdb\u5165excel\u62a5\u544a\u7684\u4fdd\u5b58\u6587\u6863");
        String docId = documentSaveDetailsDto.getDocId();
        String groupId = CheckUtil.checkGroupIdGetString((String)documentSaveDetailsDto.getGroupId());
        String docName = documentSaveDetailsDto.getDocName();
        int type = documentSaveDetailsDto.getDocType();
        Map excelParam = documentSaveDetailsDto.getParam();
        if (StringUtils.isBlank((CharSequence)docId)) {
            logger.error("docId \u53c2\u6570\u7a7a,\u8fdb\u5165\u65b0\u589e\u903b\u8f91");
            SnapShotVo addReportSnapshot = new SnapShotVo();
            if (ObjectUtils.isNotEmpty((Object)excelParam) && excelParam.containsKey("content")) {
                String content = (String)excelParam.get("content");
                addReportSnapshot.setDesignInformation(content);
            }
            addReportSnapshot.setSnapshotName(docName);
            Long addId = this.excelInstanceService.addSnapshot(addReportSnapshot, groupId);
            result.setDocId(addId.toString());
        } else {
            logger.error("docId \u53c2\u6570\u4e0d\u4e3a\u7a7a,\u8fdb\u5165\u4fee\u6539\u903b\u8f91");
            SysReportSnapshot byId = this.excelInstanceService.getSysReportSnapshotById(Long.parseLong(docId));
            if (byId == null) {
                logger.error("\u6839\u636e\u6587\u6863id\u67e5\u8be2\u4e0d\u5230\u6587\u6863\uff0c\u8fdb\u884c\u65b0\u589e\u903b\u8f91");
                SnapShotVo updateAddReport = new SnapShotVo();
                if (ObjectUtils.isNotEmpty((Object)excelParam) && excelParam.containsKey("content")) {
                    String content = (String)excelParam.get("content");
                    updateAddReport.setDesignInformation(content);
                }
                updateAddReport.setSnapshotName(docName);
                this.excelInstanceService.addSnapshot(updateAddReport, groupId);
            } else {
                logger.error("\u6839\u636e\u6587\u6863id\u67e5\u8be2\u5230\u6587\u6863\uff0c\u8fdb\u884c\u4fee\u6539\u903b\u8f91");
                if (ObjectUtils.isNotEmpty((Object)excelParam) && excelParam.containsKey("content")) {
                    String content = (String)excelParam.get("content");
                    byId.setDesignInformation(content);
                }
                byId.setSnapshotName(docName);
                this.excelInstanceService.editSnapshot(byId);
                result.setDocId(docId);
            }
        }
        result.setDocName(docName);
        result.setDocType(type);
        result.setGroupId(groupId);
        return ApiResponse.success((Object)result);
    }

    public void afterPropertiesSet() {
        DocumentFactory.add((String)DocumentType.EXCEL_REPORT_TOOL_FORM_INSTANCE.getTypeName(), (CommonDocumentInterface)this);
    }
}

