/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.report.impl;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.document.common.model.GenerateReportParam;
import com.jxdinfo.document.eln.back.util.ElnDataParsingUtil;
import com.jxdinfo.document.eln.back.vo.param.ElnDataParsingParamVo;
import com.jxdinfo.document.excel.tools.core.common.utils.JsonUtil;
import com.jxdinfo.document.excel.tools.core.common.vo.IWorkbookDataVo;
import com.jxdinfo.document.excel.tools.dataset.vo.ExcelDataSetVo;
import com.jxdinfo.document.excel.tools.dataset.vo.ExcelSuperQueryConditionVo;
import com.jxdinfo.hussar.application.dataset.service.IDatasetService;
import com.jxdinfo.hussar.application.excel.Vo.IWorkbookData;
import com.jxdinfo.hussar.application.excel.Vo.IWorksheetData;
import com.jxdinfo.hussar.application.hook.service.IReportHookService;
import com.jxdinfo.hussar.application.report.model.SysReport;
import com.jxdinfo.hussar.dataset.model.DataSetCommonParam;
import com.jxdinfo.hussar.dataset.service.IDataSetEngineService;
import com.jxdinfo.hussar.dataset.vo.DataSetExecuteVO;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ExcelReportHookServiceImpl")
public class ExcelReportHookServiceImpl
implements IReportHookService {
    @Autowired
    private IDatasetService datasetService;
    @Resource
    private IDataSetEngineService dataSetEngineService;
    private static final Logger logger = LoggerFactory.getLogger(ExcelReportHookServiceImpl.class);

    public Long getSysReportBefore(Long reportId, String exParam) {
        return reportId;
    }

    public void getSysReportAfter(SysReport sysReport, String exParam) {
        List<DataSetExecuteVO> dataSetExecuteVOList;
        logger.info("\u6839\u636e\u4e3b\u952e\u67e5\u8be2,\u8fdb\u5165Excel\u62a5\u544a\u7684\u5b9e\u73b0\u65b9\u6cd5 ExcelReportHookServiceImpl.getSysReportAfter");
        if (sysReport == null || StringUtils.isBlank((CharSequence)exParam)) {
            return;
        }
        if (!this.checkExParam(exParam)) {
            return;
        }
        String designInformation = sysReport.getDesignInformation();
        if (StringUtils.isBlank((CharSequence)designInformation)) {
            return;
        }
        String dataSet = sysReport.getDataset();
        if (StringUtils.isBlank((CharSequence)dataSet)) {
            return;
        }
        Map designMap = JsonUtil.asJSONMap((String)designInformation);
        IWorkbookData workbookData = (IWorkbookData)JsonUtil.convertValue(designMap.get("workBook"), (TypeReference)new TypeReference<IWorkbookData>(){});
        ArrayList<DataSetCommonParam> dataSetCommonParams = new ArrayList<DataSetCommonParam>();
        Map<String, List<SuperQueryConditionDto>> superQueryConditionDtoMap = this.getSuperQueryConditionDtoMap(exParam, sysReport);
        String detailContent = this.getDetailContent(exParam);
        logger.info("\u751f\u6210\u62a5\u544a\u4f20\u7684\u52a8\u6001\u6a21\u677f\u53c2\u6570\u503c:detailContent == null {}", (Object)HussarUtils.isEmpty((Object)detailContent));
        List sheetIds = workbookData.getSheetOrder();
        if (CollectionUtils.isNotEmpty((Collection)sheetIds)) {
            for (String sheetId : sheetIds) {
                IWorksheetData sheet = (IWorksheetData)workbookData.getSheets().get(sheetId);
                if (!ObjectUtils.isNotEmpty((Object)sheet) || !HussarUtils.isNotEmpty((Object)this.datasetService.getDataSetCommonParams(sheet, superQueryConditionDtoMap))) continue;
                dataSetCommonParams.addAll(this.datasetService.getDataSetCommonParams(sheet, superQueryConditionDtoMap));
            }
        }
        if (CollectionUtils.isEmpty(dataSetExecuteVOList = this.formatResult(dataSetCommonParams))) {
            return;
        }
        Map<String, String> dataSetMap = this.getDataSetMap(dataSetExecuteVOList);
        ElnDataParsingParamVo elnDataParsingParamVo = new ElnDataParsingParamVo();
        elnDataParsingParamVo.setDataSetJson(JsonUtil.asJSONString(dataSetMap));
        elnDataParsingParamVo.setTemplateJson(HussarUtils.isEmpty((Object)detailContent) ? designInformation : detailContent);
        String newDesignInformation = ElnDataParsingUtil.ElnDataParsing((ElnDataParsingParamVo)elnDataParsingParamVo);
        sysReport.setDesignInformation(newDesignInformation);
    }

    public String getDetailContent(String exParam) {
        if (StringUtils.isBlank((CharSequence)exParam)) {
            return null;
        }
        try {
            Map exParamMap = (Map)JsonUtil.convertValue((Object)exParam, (TypeReference)new TypeReference<Map<String, Object>>(){});
            if (exParamMap.containsKey("generateReportParam")) {
                GenerateReportParam generateReportParam = (GenerateReportParam)JsonUtil.convertValue(exParamMap.get("generateReportParam"), (TypeReference)new TypeReference<GenerateReportParam>(){});
                return this.getDetailContent(generateReportParam);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public String getDetailContent(GenerateReportParam generateReportParam) {
        Map customParams = generateReportParam.getCustomParams();
        if (!customParams.containsKey("detailContent") || MapUtils.isEmpty((Map)customParams)) {
            return null;
        }
        String detailContent = (String)customParams.get("detailContent");
        if (detailContent == null) {
            return null;
        }
        Map oldDesignMap = (Map)JsonUtil.convertValue((Object)detailContent, (TypeReference)new TypeReference<Map<String, Object>>(){});
        IWorkbookDataVo oldWorkbookData = (IWorkbookDataVo)JsonUtil.convertValue(oldDesignMap.get("workBook"), (TypeReference)new TypeReference<IWorkbookDataVo>(){});
        return HussarUtils.isEmpty((Object)oldWorkbookData) ? null : detailContent;
    }

    public Map<String, List<SuperQueryConditionDto>> getSuperQueryConditionDtoMap(String exParam, SysReport sysReport) {
        if (StringUtils.isBlank((CharSequence)exParam)) {
            return new HashMap<String, List<SuperQueryConditionDto>>();
        }
        try {
            Map exParamMap = (Map)JsonUtil.convertValue((Object)exParam, (TypeReference)new TypeReference<Map<String, Object>>(){});
            if (exParamMap.containsKey("generateReportParam")) {
                GenerateReportParam generateReportParam = (GenerateReportParam)JsonUtil.convertValue(exParamMap.get("generateReportParam"), (TypeReference)new TypeReference<GenerateReportParam>(){});
                return this.getSuperQueryConditionDtoMap(generateReportParam, sysReport.getDataset());
            }
        }
        catch (Exception e) {
            return new HashMap<String, List<SuperQueryConditionDto>>();
        }
        return new HashMap<String, List<SuperQueryConditionDto>>();
    }

    public Map<String, List<SuperQueryConditionDto>> getSuperQueryConditionDtoMap(GenerateReportParam generateReportParam, String dataSet) {
        HashMap<String, List<SuperQueryConditionDto>> superQueryConditionDtoMap = new HashMap<String, List<SuperQueryConditionDto>>();
        if (generateReportParam == null) {
            return superQueryConditionDtoMap;
        }
        List excelDataSetVos = (List)JsonUtil.convertValue((Object)dataSet, (TypeReference)new TypeReference<List<ExcelDataSetVo>>(){});
        Map customParams = generateReportParam.getCustomParams();
        if (HussarUtils.isEmpty((Object)customParams)) {
            return superQueryConditionDtoMap;
        }
        if (!customParams.containsKey("dataSetParam") || CollectionUtils.isEmpty((Collection)excelDataSetVos)) {
            return superQueryConditionDtoMap;
        }
        List dataSetParamList = (List)JsonUtil.convertValue(customParams.get("dataSetParam"), (TypeReference)new TypeReference<List<ExcelSuperQueryConditionVo>>(){});
        if (CollectionUtils.isEmpty((Collection)dataSetParamList)) {
            return superQueryConditionDtoMap;
        }
        Map<String, List<ExcelSuperQueryConditionVo>> dataSetParamMap = dataSetParamList.stream().collect(Collectors.groupingBy(ExcelSuperQueryConditionVo::getDataSetId));
        for (Map.Entry<String, List<ExcelSuperQueryConditionVo>> entry : dataSetParamMap.entrySet()) {
            List<ExcelSuperQueryConditionVo> excelSuperQueryConditionVos = entry.getValue();
            if (HussarUtils.isEmpty(excelSuperQueryConditionVos)) continue;
            List superQueryConditions = (List)JsonUtil.convertValue(excelSuperQueryConditionVos, (TypeReference)new TypeReference<List<SuperQueryConditionDto>>(){});
            superQueryConditionDtoMap.put(entry.getKey(), superQueryConditions);
        }
        return superQueryConditionDtoMap;
    }

    public List<DataSetExecuteVO> formatResult(List<DataSetCommonParam> dataSetCommonParams) {
        if (CollectionUtils.isEmpty(dataSetCommonParams)) {
            return new ArrayList<DataSetExecuteVO>();
        }
        return (List)this.dataSetEngineService.executeDataSetParam(dataSetCommonParams).getData();
    }

    public Map<String, String> getDataSetMap(List<DataSetExecuteVO> dataSetExecuteVOList) {
        if (CollectionUtils.isEmpty(dataSetExecuteVOList)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> dataSetMap = new HashMap<String, String>();
        for (DataSetExecuteVO dataSetExecuteVO : dataSetExecuteVOList) {
            try {
                JSONObject elnDataMap = JSONObject.parseObject((String)dataSetExecuteVO.getReturnValue());
                if (elnDataMap.containsKey("data") && HussarUtils.isNotEmpty(elnDataMap.get("data"))) {
                    dataSetExecuteVO.setReturnValue(JsonUtil.asJSONString(elnDataMap.get("data")));
                } else {
                    dataSetExecuteVO.setReturnValue(JsonUtil.asJSONString((Object)elnDataMap));
                }
            }
            catch (Exception e) {
                dataSetMap.put(dataSetExecuteVO.getDataSetId(), dataSetExecuteVO.getReturnValue());
                continue;
            }
            dataSetMap.put(dataSetExecuteVO.getDataSetId(), dataSetExecuteVO.getReturnValue());
        }
        return dataSetMap;
    }

    public boolean checkExParam(String exParam) {
        if (StringUtils.isBlank((CharSequence)exParam)) {
            return false;
        }
        try {
            Map exParamMap = (Map)JsonUtil.convertValue((Object)exParam, (TypeReference)new TypeReference<Map<String, Object>>(){});
            if (exParamMap.containsKey("type") && exParamMap.get("type").equals("analyzeEln")) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

