/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.migration.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.document.excel.tools.core.common.utils.StringUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.ZipUtil;
import com.jxdinfo.document.excel.tools.file.service.IOssFileService;
import com.jxdinfo.document.excel.tools.migration.dao.ExcelInstanceMapper;
import com.jxdinfo.document.excel.tools.migration.model.ExcelInstance;
import com.jxdinfo.document.excel.tools.migration.service.ExcelInstanceService;
import com.jxdinfo.document.excel.tools.mongo.service.ExcelToolMongoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.document.excel.tools.migration.service.impl.ExcelInstanceServiceImpl")
public class ExcelInstanceServiceImpl
extends HussarServiceImpl<ExcelInstanceMapper, ExcelInstance>
implements ExcelInstanceService {
    @Autowired
    private IOssFileService IOssFileService;
    @Autowired
    private ExcelToolMongoService excelToolMongoService;

    public String getInstanceJson(ExcelInstance excelInstance) {
        if (excelInstance == null) {
            return "";
        }
        Long id = excelInstance.getId();
        String reportJson = excelInstance.getReportData();
        String reportPath = excelInstance.getReportPath();
        if (StringUtils.isNotEmpty((CharSequence)reportPath)) {
            String json = this.IOssFileService.getContent(reportPath);
            json = StringUtil.cleaningHtml((String)json);
            return ZipUtil.unZipReportToStr((String)json);
        }
        if (StringUtils.isNotEmpty((CharSequence)reportJson)) {
            return ZipUtil.unZipReportToStr((String)reportJson);
        }
        return this.excelToolMongoService.getAllData(String.valueOf(id));
    }

    public List<ExcelInstance> getExcelInstanceList(LocalDateTime createTimeStart, LocalDateTime createTimeEnd, List<String> ids) {
        QueryWrapper qw = new QueryWrapper();
        if (HussarUtils.isNotEmpty((Object)createTimeStart)) {
            qw.lambda().ge(ExcelInstance::getCreateTime, (Object)createTimeStart);
        }
        if (HussarUtils.isNotEmpty((Object)createTimeEnd)) {
            qw.lambda().le(ExcelInstance::getCreateTime, (Object)createTimeEnd);
        }
        if (HussarUtils.isNotEmpty(ids)) {
            qw.lambda().in(ExcelInstance::getId, ids);
        }
        return ((ExcelInstanceMapper)this.baseMapper).selectList((Wrapper)qw);
    }
}

