/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.migration.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.common.model.WordDocTypeInfo;
import com.jxdinfo.document.common.service.impl.WordTypeInfoServiceImpl;
import com.jxdinfo.document.excel.tools.core.common.utils.JsonUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.RandomStringUtil;
import com.jxdinfo.document.excel.tools.core.common.vo.IWorkbookDataVo;
import com.jxdinfo.document.excel.tools.core.migration.empty.LuckySheetConvertDataCtx;
import com.jxdinfo.document.excel.tools.core.migration.utils.LuckySheetConvertUniverUtil;
import com.jxdinfo.document.excel.tools.migration.model.ExcelInstance;
import com.jxdinfo.document.excel.tools.migration.service.ExcelDataMigrationService;
import com.jxdinfo.document.excel.tools.migration.service.ExcelInstanceService;
import com.jxdinfo.hussar.application.reportsnapshot.Vo.SnapShotVo;
import com.jxdinfo.hussar.application.reportsnapshot.service.ISysReportSnapShotService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.document.excel.tools.migration.service.impl.ExcelDataMigrationServiceImpl")
public class ExcelDataMigrationServiceImpl
implements ExcelDataMigrationService {
    private static final Logger logger = LoggerFactory.getLogger(ExcelDataMigrationServiceImpl.class);
    @Resource
    private WordTypeInfoServiceImpl wordTypeInfoService;
    @Autowired
    private ExcelInstanceService instanceService;
    @Autowired
    private ISysReportSnapShotService reportSnapShotService;

    public void excelHistoryDataMigration(String createTimeStart, String createTimeEnd, List<String> docIds) {
        String taskFlag = "migrate-" + System.currentTimeMillis();
        logger.info("[{}]excelHistoryDataMigration\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u5f00\u59cb", (Object)taskFlag);
        int batchSize = 500;
        LocalDateTime startTime = this.getLocalDateTime(createTimeStart);
        LocalDateTime endTime = this.getLocalDateTime(createTimeEnd);
        List toolFormInstances = this.instanceService.getExcelInstanceList(startTime, endTime, docIds);
        int total = CollectionUtils.isEmpty((Collection)toolFormInstances) ? 0 : toolFormInstances.size();
        int totalSuccess = 0;
        int totalFail = 0;
        StringBuilder failIds = new StringBuilder();
        try {
            if (total == 0) {
                logger.info("[{}]\u65e0\u8fc1\u79fb\u6570\u636e\uff0c\u4efb\u52a1\u7ed3\u675f", (Object)taskFlag);
                return;
            }
            logger.info("[{}]\u5f85\u8fc1\u79fb\u6570\u636e\u603b\u6570\uff1a{}\uff0c\u6279\u6b21\u5927\u5c0f\uff1a{}", new Object[]{taskFlag, total, batchSize});
            for (int i = 0; i < toolFormInstances.size(); i += batchSize) {
                int end = Math.min(i + batchSize, toolFormInstances.size());
                List batchList = toolFormInstances.subList(i, end);
                int batchSuccess = 0;
                int batchFail = 0;
                logger.info("[{}]\u5f00\u59cb\u5904\u7406\u7b2c{}\u6279\uff0c\u8303\u56f4\uff1a{}-{}\uff0c\u6279\u6b21\u6570\u91cf\uff1a{}", new Object[]{taskFlag, i / batchSize + 1, i, end - 1, batchList.size()});
                List reportIds = batchList.stream().map(ExcelInstance::getId).distinct().collect(Collectors.toList());
                List wordDocTypeInfos = this.wordTypeInfoService.getListByReportIds(reportIds);
                HashMap nameMap = HussarUtils.isEmpty((Object)wordDocTypeInfos) ? new HashMap() : wordDocTypeInfos.stream().collect(Collectors.toMap(WordDocTypeInfo::getReportId, WordDocTypeInfo::getReportName));
                for (ExcelInstance instance : batchList) {
                    try {
                        String documentName = (String)nameMap.get(instance.getId());
                        SnapShotVo snapshot = new SnapShotVo();
                        snapshot.setReportId(String.valueOf(instance.getTemplateId()));
                        snapshot.setSnapshotName(HussarUtils.isEmpty((Object)documentName) ? "\u65e0\u6807\u9898\u6587\u6863" : documentName);
                        snapshot.setDesignInformation(this.migrate(instance));
                        snapshot.setSnapshotId(instance.getId());
                        snapshot.setCreateTime(instance.getCreateTime());
                        snapshot.setCreator(instance.getCreateId());
                        this.reportSnapShotService.saveOrUpdate((Object)snapshot);
                        ++batchSuccess;
                    }
                    catch (Exception e) {
                        failIds.append(instance.getId()).append(",");
                        ++batchFail;
                        logger.error("[{}]\u7b2c{}\u6279 \u8fc1\u79fbID:{} \u5931\u8d25", new Object[]{taskFlag, i / batchSize + 1, instance.getId(), e});
                    }
                }
                double progress = (double)(i + batchSize) * 100.0 / (double)total;
                logger.info("[{}]\u7b2c{}\u6279\u5904\u7406\u5b8c\u6210 | \u6279\u6b21\u6210\u529f\uff1a{} | \u6279\u6b21\u5931\u8d25\uff1a{} | \u7d2f\u8ba1\u6210\u529f\uff1a{} | \u7d2f\u8ba1\u5931\u8d25\uff1a{} | \u8fdb\u5ea6\uff1a{}%", new Object[]{taskFlag, i / batchSize + 1, batchSuccess, batchFail, totalSuccess += batchSuccess, totalFail += batchFail, Math.min(progress, 100.0)});
                batchList.clear();
            }
            logger.info("[{}]excelHistoryDataMigration\u8fc1\u79fb\u4efb\u52a1\u5b8c\u6210\uff01\u603b\u6570\uff1a{} | \u6210\u529f\uff1a{} | \u5931\u8d25\uff1a{} | \u5931\u8d25ID\uff1a{}", new Object[]{taskFlag, total, totalSuccess, totalFail, failIds.length() > 0 ? failIds.substring(0, failIds.length() - 1) : "\u65e0"});
        }
        catch (Exception e) {
            logger.error("[{}]\u8fc1\u79fb\u4efb\u52a1\u5f02\u5e38\u7ec8\u6b62\uff01", (Object)taskFlag, (Object)e);
        }
    }

    public String migrate(ExcelInstance excelInstance) {
        String json = this.instanceService.getInstanceJson(excelInstance);
        LuckySheetConvertDataCtx ctx = new LuckySheetConvertDataCtx();
        IWorkbookDataVo workbookDataVo = new IWorkbookDataVo();
        workbookDataVo.setId(RandomStringUtil.generateAlphanumeric((int)21));
        workbookDataVo.setAppVersion("0.7.0");
        workbookDataVo.setLocale("zhCN");
        workbookDataVo.setSheetOrder(new LinkedList());
        workbookDataVo.setSheets(new LinkedHashMap());
        workbookDataVo.setStyles(new LinkedHashMap());
        ctx.setWorkbookDataVo(workbookDataVo);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            Object sheetObject = JSON.parse((String)json);
            if (sheetObject instanceof JSONObject) {
                JSONObject sheetJson = (JSONObject)sheetObject;
                LuckySheetConvertUniverUtil.convertLuckySheetDataToUniverData((LuckySheetConvertDataCtx)ctx, (JSONObject)sheetJson);
            } else if (sheetObject instanceof JSONArray) {
                JSONArray sheetJsons = (JSONArray)sheetObject;
                for (Object sheet : sheetJsons) {
                    JSONObject sheetJson = (JSONObject)sheet;
                    LuckySheetConvertUniverUtil.convertLuckySheetDataToUniverData((LuckySheetConvertDataCtx)ctx, (JSONObject)sheetJson);
                }
            }
        }
        return JsonUtil.asJSONString((Object)workbookDataVo);
    }

    public LocalDateTime getLocalDateTime(String createTime) {
        if (HussarUtils.isNotEmpty((Object)createTime)) {
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate startDate = LocalDate.parse(createTime, dateFormatter);
            return startDate.atStartOfDay();
        }
        return null;
    }
}

