/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.report.mongo.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.core.common.utils.reportToolThreadPool.ReportFormThreadPool;
import com.jxdinfo.document.excel.tools.report.mongo.model.ReportToolFormLsBorderInfo;
import com.jxdinfo.document.excel.tools.report.mongo.model.ReportToolFormLsCellData;
import com.jxdinfo.document.excel.tools.report.mongo.model.ReportToolFormLsOtherData;
import com.jxdinfo.document.excel.tools.report.mongo.service.ReportToolFormLsBorderInfoService;
import com.jxdinfo.document.excel.tools.report.mongo.service.ReportToolFormLsCellDataService;
import com.jxdinfo.document.excel.tools.report.mongo.service.ReportToolFormLsOtherDataService;
import com.jxdinfo.document.excel.tools.report.mongo.service.ReportToolFromMongoService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service(value="report.tools.form.mongo.service.impl.ReportToolFromMongoServiceImpl")
@HussarDs(value="master")
public class ReportToolFromMongoServiceImpl
implements ReportToolFromMongoService {
    @Value(value="${mongo-save-chunk-size:0}")
    private int mongoSaveChunkSize;
    @Value(value="${lsdata-save-chunk.enabled-chunk:false}")
    private boolean lsdataEnabledChunk;
    @Value(value="${lsdata-save-chunk.chunk-size:0}")
    private int lsdataChunkSize;
    @Autowired
    private ReportToolFormLsCellDataService lsCellDataService;
    @Autowired
    private ReportToolFormLsOtherDataService lsOtherDataService;
    @Autowired
    private ReportToolFormLsBorderInfoService lsBorderInfoService;
    private static final Logger logger = LoggerFactory.getLogger(ReportToolFromMongoServiceImpl.class);

    @Override
    public void saveCellData(String gridKey, JSONArray celldata, String sheetIndex) {
        try {
            int m = 0;
            for (int j = 0; j < celldata.size(); j += this.mongoSaveChunkSize) {
                int end = Math.min(j + this.mongoSaveChunkSize, celldata.size());
                List subList = celldata.subList(j, end);
                JSONArray subArray = new JSONArray(subList);
                ReportToolFormLsCellData lsCellData = new ReportToolFormLsCellData();
                lsCellData.setGridKey(gridKey);
                lsCellData.setSheetIndex(sheetIndex);
                lsCellData.setCelldata(subArray);
                lsCellData.setOrder(m);
                this.lsCellDataService.saveLsCellData(lsCellData);
                ++m;
            }
        }
        catch (Exception e) {
            logger.error("saveCellData \u4fdd\u5b58\u5931\u8d25: gridKey={}", (Object)gridKey, (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveBorderInfoData(String gridKey, JSONArray finalBorderInfo, String sheetIndex) {
        try {
            if (finalBorderInfo != null) {
                int m = 0;
                for (int j = 0; j < finalBorderInfo.size(); j += this.mongoSaveChunkSize) {
                    int end = Math.min(j + this.mongoSaveChunkSize, finalBorderInfo.size());
                    List subList = finalBorderInfo.subList(j, end);
                    JSONArray subArray = new JSONArray(subList);
                    ReportToolFormLsBorderInfo lsBorderInfo = new ReportToolFormLsBorderInfo();
                    lsBorderInfo.setGridKey(gridKey);
                    lsBorderInfo.setSheetIndex(sheetIndex);
                    lsBorderInfo.setBorderInfo(subArray);
                    lsBorderInfo.setOrder(m);
                    this.lsBorderInfoService.saveLsBorderInfo(lsBorderInfo);
                    ++m;
                }
            }
        }
        catch (Exception e) {
            logger.error("saveBorderInfoData \u4fdd\u5b58\u5931\u8d25: gridKey={}", (Object)gridKey, (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveLsOtherData(String gridKey, String sheetIndex, JSONObject sheet) {
        try {
            ReportToolFormLsOtherData lsOtherData = new ReportToolFormLsOtherData();
            lsOtherData.setGridKey(gridKey);
            lsOtherData.setSheetIndex(sheetIndex);
            lsOtherData.setOtherData(sheet);
            lsOtherData.setOrder(sheet.getIntValue("order"));
            this.lsOtherDataService.saveLsOtherData(lsOtherData);
        }
        catch (Exception e) {
            logger.error("saveLsOtherData \u4fdd\u5b58\u5931\u8d25: gridKey={}", (Object)gridKey, (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteLsOtherData(String gridKey, List<String> sheetIndexList) {
        List<ReportToolFormLsOtherData> lsOtherDataList = this.lsOtherDataService.getLsOtherDataListByGridKey(gridKey);
        for (int i = 0; i < lsOtherDataList.size(); ++i) {
            ReportToolFormLsOtherData lsOtherData = lsOtherDataList.get(i);
            String sheetIndex = lsOtherData.getSheetIndex();
            if (sheetIndexList.contains(sheetIndex)) continue;
            this.lsOtherDataService.deleteLsOtherDataByGridKeyAndSheetIndex(gridKey, sheetIndex);
            this.lsCellDataService.deleteLsCellDataByGridKeyAndSheetIndex(gridKey, sheetIndex);
            this.lsBorderInfoService.deleteLsBorderInfoByGridKeyAndSheetIndex(gridKey, sheetIndex);
        }
    }

    @Override
    public String getAllData(String gridKey) {
        JSONObject lsSheetsRes = this.lsOtherDataService.getLsOtherDataByGridKey(gridKey);
        JSONArray lsSheets = lsSheetsRes.getJSONArray("allSheets");
        ThreadPoolTaskExecutor taskExecutor = ReportFormThreadPool.reportToolTemplateSheetDataByQueryThreadPool();
        CompletableFuture<Map> celldataFuture = CompletableFuture.supplyAsync(() -> this.lsCellDataService.getLsCellDataByGridKey(gridKey), (Executor)taskExecutor);
        CompletableFuture<Map> borderInfoFuture = CompletableFuture.supplyAsync(() -> this.lsBorderInfoService.getLsBorderInfoByGridKey(gridKey), (Executor)taskExecutor);
        Map celldataRes = celldataFuture.join();
        Map borderInfoRes = borderInfoFuture.join();
        ArrayList<CompletableFuture<Void>> mergeTasks = new ArrayList<CompletableFuture<Void>>();
        for (Object sheet : lsSheets) {
            JSONObject sheetObj = (JSONObject)sheet;
            mergeTasks.add(CompletableFuture.runAsync(() -> {
                JSONArray borderInfo;
                JSONArray celldata = (JSONArray)celldataRes.get(sheetObj.getString("index"));
                if (celldata != null) {
                    sheetObj.put("celldata", (Object)celldata);
                }
                if ((borderInfo = (JSONArray)borderInfoRes.get(sheetObj.getString("index"))) != null && !borderInfo.isEmpty()) {
                    if (!sheetObj.containsKey((Object)"config")) {
                        sheetObj.put("config", (Object)new JSONObject());
                    }
                    sheetObj.getJSONObject("config").put("borderInfo", (Object)borderInfo);
                }
            }, (Executor)taskExecutor));
        }
        CompletableFuture.allOf(mergeTasks.toArray(new CompletableFuture[0])).join();
        return lsSheets.toJSONString();
    }
}

