/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.report.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.common.CommonDocumentInterface;
import com.jxdinfo.document.common.DocumentType;
import com.jxdinfo.document.common.factory.DocumentFactory;
import com.jxdinfo.document.common.model.DocDataBindInfo;
import com.jxdinfo.document.common.model.DocImportCtx;
import com.jxdinfo.document.common.model.GenerateReportParam;
import com.jxdinfo.document.common.service.impl.WordTypeInfoServiceImpl;
import com.jxdinfo.document.common.vo.DocumentDetailsVo;
import com.jxdinfo.document.common.vo.DocumentSplitVo;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.FrontendEnum;
import com.jxdinfo.document.excel.tools.report.export.service.ExportExcelService;
import com.jxdinfo.document.excel.tools.report.external.service.WordExcelCommonService;
import com.jxdinfo.document.excel.tools.report.importer.service.ImportExcelService;
import com.jxdinfo.document.excel.tools.report.template.template.model.ReportToolFormTemplate;
import com.jxdinfo.document.excel.tools.report.template.template.service.ReportToolFormTemplateCustomService;
import com.jxdinfo.document.excel.tools.report.template.template.service.ReportToolFormTemplateService;
import com.jxdinfo.document.excel.tools.report.template.template.vo.ReportToolFromTemplateBaseVo;
import com.jxdinfo.document.excel.tools.report.template.template.vo.ReportToolFromTemplateConfigVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="excel.tools.report.external.service.impl.FormTemplateExternalServiceImpl")
public class FormTemplateExternalServiceImpl
implements CommonDocumentInterface,
InitializingBean {
    @Resource
    private ReportToolFormTemplateCustomService toolFormTemplateCustomService;
    @Resource
    private ReportToolFormTemplateService reportToolFormTemplateService;
    @Resource
    private WordTypeInfoServiceImpl wordTypeInfoService;
    @Autowired
    private WordExcelCommonService wordExcelCommonService;
    @Resource
    private ExportExcelService exportExcelService;
    @Autowired
    private ImportExcelService importExcelService;
    private static final Logger logger = LoggerFactory.getLogger(FormTemplateExternalServiceImpl.class);

    public void checkDocId(Long docId) {
        if (docId == null) {
            throw new IllegalArgumentException(FrontendEnum.RETURN_ID_NULL.getDescription());
        }
    }

    public DocumentDetailsVo queryDocumentDetail(Long templateId) {
        return this.queryOffice(templateId);
    }

    public DocumentDetailsVo queryOffice(Long templateId) {
        this.checkDocId(templateId);
        ReportToolFormTemplate template = this.toolFormTemplateCustomService.getReportFormTemplateInfo(String.valueOf(templateId));
        ReportToolFromTemplateConfigVo configInfo = this.toolFormTemplateCustomService.getReportFormTemplateConfig(String.valueOf(templateId));
        DocumentDetailsVo detailsVo = new DocumentDetailsVo();
        detailsVo.setId(templateId);
        detailsVo.setType(DocumentType.EXCEL_REPORT_TOOL_FORM_COMPONENT_TEMPLATE.getTypeCode());
        detailsVo.setContent(template.getTemplateJson());
        detailsVo.setDocumentName(template.getName());
        HashMap<String, Object> extendResult = new HashMap<String, Object>(16);
        extendResult.put("baseInfo", template);
        extendResult.put("configInfo", configInfo);
        detailsVo.setExtendResult(extendResult);
        return detailsVo;
    }

    public Long addBlankDocument(String documentName, String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            logger.error("type \u53c2\u6570\u7a7a");
        }
        String reportName = StringUtils.isBlank((CharSequence)documentName) ? "\u65e0\u6807\u9898\u6587\u6863" : documentName;
        Long reportId = this.toolFormTemplateCustomService.addEmptyFormTemplate(reportName);
        this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(reportId, reportName, DocumentType.EXCEL_REPORT_TOOL_FORM_TEMPLATE.getTypeCode());
        return reportId;
    }

    public Long copyDocument(Long templateId) {
        this.checkDocId(templateId);
        ReportToolFromTemplateBaseVo vo = new ReportToolFromTemplateBaseVo();
        ReportToolFormTemplate reportToolFormTemplate = (ReportToolFormTemplate)this.reportToolFormTemplateService.getById(templateId);
        vo.setTemplateId(String.valueOf(templateId));
        ApiResponse<ReportToolFromTemplateBaseVo> copyReportInfoApi = this.toolFormTemplateCustomService.copyReportFromTemplate(vo);
        if (copyReportInfoApi.isSuccess()) {
            ReportToolFromTemplateBaseVo resultData = (ReportToolFromTemplateBaseVo)copyReportInfoApi.getData();
            String reportId = resultData.getTemplateId();
            this.wordExcelCommonService.copyDocumentByTemplate(reportId, reportToolFormTemplate.getName(), String.valueOf(templateId));
            return Long.valueOf(reportId);
        }
        return null;
    }

    public void downloadDocument(HttpServletResponse httpServletResponse, Long templateId) {
        logger.info("downloadDocument \u62a5\u544a\u6a21\u677f\u4e0d\u5b58\u5728\u6587\u4ef6\u4e0b\u8f7d");
    }

    public void previewPDF(HttpServletResponse httpServletResponse, Long aLong) {
        logger.info("previewPDF \u62a5\u544a\u6a21\u677f\u4e0d\u5b58\u5728\u6587\u4ef6\u9884\u89c8");
    }

    public ApiResponse<Long> importDocument(MultipartFile file, Long groupId, String docName) {
        logger.info("importDocument \u5bfc\u5165excel \u542f\u52a8");
        try {
            String groupIdString = groupId == null ? "1" : String.valueOf(groupId);
            int typeCode = DocumentType.EXCEL_REPORT_TOOL_FORM_TEMPLATE.getTypeCode();
            return this.importExcelService.importExcel(file, docName, groupIdString, String.valueOf(typeCode));
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            return ApiResponse.fail((String)"\u5bfc\u5165\u5931\u8d25");
        }
    }

    public void exportDocument(HttpServletResponse httpServletResponse, Long templateId) {
        logger.info("exportDocument \u62a5\u544a\u6a21\u677f\u4e0d\u5b58\u5728\u6587\u4ef6\u4e0b\u8f7d");
    }

    public DocDataBindInfo getBindConfig(GenerateReportParam generateReportParam) {
        return null;
    }

    public Long generateReport(Long aLong, JSONObject jsonObject) {
        return 0L;
    }

    public JSONObject executeJsGenerateReportJson(Long id, String data, boolean fullReplace) {
        return null;
    }

    public DocumentSplitVo getDocumentById(Long aLong) {
        return null;
    }

    public Long addBlankDocument(String documentName, String type, String groupId) {
        if (StringUtils.isBlank((CharSequence)type)) {
            logger.error("type \u53c2\u6570\u7a7a");
        }
        String reportName = StringUtils.isBlank((CharSequence)documentName) ? "\u65e0\u6807\u9898\u6587\u6863" : documentName;
        Long reportId = this.toolFormTemplateCustomService.addEmptyFormTemplate(reportName);
        this.wordExcelCommonService.updateDocumentByTemplate(String.valueOf(reportId), reportName, groupId);
        return reportId;
    }

    public boolean deleteDocument(Long templateId) {
        this.checkDocId(templateId);
        this.wordTypeInfoService.deleteByReportId(templateId);
        ApiResponse<Map<String, Object>> resultData = this.toolFormTemplateCustomService.batchDelReportFormTemplateById(Arrays.asList(templateId.toString()));
        return resultData.isSuccess();
    }

    public void downDocument(HttpServletResponse httpServletResponse, Long templateId) {
        this.checkDocId(templateId);
        this.exportExcelService.exportTemplateXlsx(httpServletResponse, templateId);
    }

    public void insertOrUpdateDocument(Map<String, JSONObject> sysDocumentMap, String docId) {
        logger.info("insertOrUpdateDocument \u8bf7\u671f\u5f85\u4e0b\u4e2a\u7248\u672c");
    }

    public void createDocumentRelationFile(String documentPath, Long docId) {
        logger.info("createDocumentRelationFile \u8bf7\u671f\u5f85\u4e0b\u4e2a\u7248\u672c");
    }

    public Long importDocumentData(String unZipPath, String cacheKey, DocImportCtx docImportCtx) {
        logger.info("importDocumentData \u8bf7\u671f\u5f85\u4e0b\u4e2a\u7248\u672c");
        return null;
    }

    public Long dealImageSize(Long docId) {
        return null;
    }

    public void afterPropertiesSet() {
        DocumentFactory.add((String)DocumentType.EXCEL_REPORT_TOOL_FORM_TEMPLATE.getTypeName(), (CommonDocumentInterface)this);
    }
}

