/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.report.template.attachmentfilelink.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.document.excel.tools.report.template.attachmentfilelink.dao.TemplateFileLinkMapper;
import com.jxdinfo.document.excel.tools.report.template.attachmentfilelink.model.ReportToolTemplateAttachmentFileLink;
import com.jxdinfo.document.excel.tools.report.template.attachmentfilelink.service.TemplateFileLinkCustomService;
import com.jxdinfo.document.excel.tools.report.template.attachmentfilelink.service.TemplateFileLinkService;
import com.jxdinfo.document.excel.tools.report.template.attachmentfilelink.vo.AddTempAttachmentFileParamVo;
import com.jxdinfo.document.excel.tools.report.template.component.attachmentfilelink.dao.ComponentFileLinkMapper;
import com.jxdinfo.document.excel.tools.report.template.component.attachmentfilelink.model.ComponentAttachmentFileLink;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="excel.tools.report.template.attachmentFileLink.TemplateFileLinkCustomServiceImpl")
public class TemplateFileLinkCustomServiceImpl
implements TemplateFileLinkCustomService {
    @Autowired
    private TemplateFileLinkMapper templateFileLinkMapper;
    @Autowired
    private ComponentFileLinkMapper componentFileLinkMapper;
    @Autowired
    private TemplateFileLinkService templateFileLinkService;

    @Override
    public ApiResponse<Map<String, Object>> addTempAttachmentFile(AddTempAttachmentFileParamVo param) {
        try {
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user == null) {
                return ApiResponse.fail((String)"\u5f53\u524d\u767b\u5f55\u5931\u6548");
            }
            ReportToolTemplateAttachmentFileLink reportTempAttachmentFileLink = new ReportToolTemplateAttachmentFileLink();
            Long templateId = Long.valueOf(param.getTemplateId());
            String fileId = param.getFileId();
            String fileName = param.getFileName();
            String filePath = param.getFilePath();
            String fileType = param.getFileType();
            if (param.getType() != null) {
                reportTempAttachmentFileLink.setType(param.getType());
            }
            String userName = user.getUserName();
            Long userId = user.getId();
            LocalDateTime now = LocalDateTime.now();
            Long id = IdWorker.getId((Object)new Date());
            reportTempAttachmentFileLink.setId(id);
            reportTempAttachmentFileLink.setTemplateId(templateId);
            reportTempAttachmentFileLink.setFileId(fileId);
            reportTempAttachmentFileLink.setFileName(fileName);
            reportTempAttachmentFileLink.setFilePath(filePath);
            reportTempAttachmentFileLink.setFileType(fileType);
            reportTempAttachmentFileLink.setCreateId(userId);
            reportTempAttachmentFileLink.setCreateName(userName);
            reportTempAttachmentFileLink.setCreateTime(now);
            int i = this.templateFileLinkMapper.insert(reportTempAttachmentFileLink);
            if (i > 0) {
                return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f");
            }
            return ApiResponse.fail((String)"\u65b0\u589e\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @Override
    public ApiResponse<Map<String, Object>> delTempAttachmentFile(Map<String, Object> param) {
        try {
            String idsStr = param.get("ids").toString();
            String[] ids = idsStr.split(",");
            int count = 0;
            int n = 0;
            for (int i = 0; i < ids.length; ++i) {
                if (ids[i] == null || ids[i].equals("")) continue;
                ++count;
                int m = this.templateFileLinkMapper.deleteById((Serializable)((Object)ids[i]));
                if (m <= 0) continue;
                ++n;
            }
            if (n == count) {
                return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
            }
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @Override
    public ApiResponse<List<ReportToolTemplateAttachmentFileLink>> getTempAttachmentFileList(Map<String, Object> param) {
        try {
            String templateId = param.get("templateId").toString();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(ReportToolTemplateAttachmentFileLink::getTemplateId, (Object)templateId);
            List reportTempAttachmentFileLinkList = this.templateFileLinkMapper.selectList((Wrapper)queryWrapper);
            return ApiResponse.success((Object)reportTempAttachmentFileLinkList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @Override
    public ApiResponse<Map<String, Object>> templateComponentDrag(Map<String, Object> param) {
        try {
            Long componentId = Long.valueOf(param.get("componentId").toString());
            Long templateId = Long.valueOf(param.get("templateId").toString());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(ComponentAttachmentFileLink::getComponentId, (Object)componentId);
            List reportCompAttachmentFileLinkList = this.componentFileLinkMapper.selectList((Wrapper)queryWrapper);
            if (reportCompAttachmentFileLinkList == null || reportCompAttachmentFileLinkList.size() == 0) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("code", -1);
                return ApiResponse.success(map, (String)"\u7ec4\u4ef6\u9644\u4ef6\u94fe\u63a5\u4e3a\u7a7a");
            }
            int count = 0;
            for (ComponentAttachmentFileLink fileLink : reportCompAttachmentFileLinkList) {
                ReportToolTemplateAttachmentFileLink reportTempAttachmentFileLink = new ReportToolTemplateAttachmentFileLink();
                reportTempAttachmentFileLink.setId(IdWorker.getId((Object)new Date()));
                reportTempAttachmentFileLink.setTemplateId(templateId);
                reportTempAttachmentFileLink.setFileId(fileLink.getFileId());
                reportTempAttachmentFileLink.setFileName(fileLink.getFileName());
                reportTempAttachmentFileLink.setFilePath(fileLink.getFilePath());
                reportTempAttachmentFileLink.setFileType(fileLink.getFileType());
                reportTempAttachmentFileLink.setCreateId(fileLink.getCreateId());
                reportTempAttachmentFileLink.setCreateName(fileLink.getCreateName());
                reportTempAttachmentFileLink.setCreateTime(fileLink.getCreateTime());
                reportTempAttachmentFileLink.setType(fileLink.getType());
                int n = this.templateFileLinkMapper.insert(reportTempAttachmentFileLink);
                if (n <= 0) continue;
                ++count;
            }
            if (count == reportCompAttachmentFileLinkList.size()) {
                return ApiResponse.success((String)"\u62d6\u62fd\u7ec4\u4ef6\u65b0\u589e\u9644\u4ef6\u6210\u529f");
            }
            return ApiResponse.fail((String)"\u62d6\u62fd\u7ec4\u4ef6\u65b0\u589e\u9644\u4ef6\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @Override
    public List<ReportToolTemplateAttachmentFileLink> getListByBusinessId(Long businessId) {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(ReportToolTemplateAttachmentFileLink::getTemplateId, (Object)businessId);
        return this.templateFileLinkMapper.selectList((Wrapper)qw);
    }

    @Override
    public void saveOrUpdateByBusinessId(Long businessId, List<ReportToolTemplateAttachmentFileLink> attachmentFileLinkList) {
        if (businessId == null) {
            return;
        }
        this.deleteByBusinessId(businessId);
        if (CollectionUtils.isEmpty(attachmentFileLinkList)) {
            return;
        }
        for (ReportToolTemplateAttachmentFileLink attachmentFileLink : attachmentFileLinkList) {
            attachmentFileLink.setId(IdWorker.getId((Object)new Date()));
            attachmentFileLink.setTemplateId(businessId);
        }
        this.templateFileLinkService.saveOrUpdateBatch(attachmentFileLinkList);
    }

    @Override
    public void deleteByBusinessId(Long businessId) {
        List<ReportToolTemplateAttachmentFileLink> attachmentFileLinkList = this.getListByBusinessId(businessId);
        if (CollectionUtils.isEmpty(attachmentFileLinkList)) {
            return;
        }
        this.templateFileLinkService.removeByIds(attachmentFileLinkList.stream().map(ReportToolTemplateAttachmentFileLink::getId).filter(Objects::nonNull).collect(Collectors.toList()));
    }
}

