/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.report.instance.attachmentfilelink.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.document.excel.tools.report.instance.attachmentfilelink.dao.InstanceFileLinkMapper;
import com.jxdinfo.document.excel.tools.report.instance.attachmentfilelink.model.ReportToolInstanceAttachmentFileLink;
import com.jxdinfo.document.excel.tools.report.instance.attachmentfilelink.service.InstanceFileLinkCustomService;
import com.jxdinfo.document.excel.tools.report.instance.attachmentfilelink.vo.AddAttachmentFileParamVo;
import com.jxdinfo.document.excel.tools.report.template.attachmentfilelink.model.ReportToolTemplateAttachmentFileLink;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="excel.tools.report.instance.attachmentFileLink.service.impl.instanceFileLinkCustomService")
public class InstanceFileLinkCustomServiceImpl
extends HussarServiceImpl<InstanceFileLinkMapper, ReportToolInstanceAttachmentFileLink>
implements InstanceFileLinkCustomService {
    @Autowired
    private InstanceFileLinkMapper instanceFileLinkMapper;

    @Override
    public ApiResponse<Map<String, Object>> addAttachmentFile(AddAttachmentFileParamVo param) {
        try {
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user == null) {
                return ApiResponse.fail((String)"\u5f53\u524d\u767b\u5f55\u5931\u6548");
            }
            ReportToolInstanceAttachmentFileLink reportToolInstanceAttachmentFileLink = new ReportToolInstanceAttachmentFileLink();
            Long reportId = Long.valueOf(param.getReportId());
            String fileId = param.getFileId();
            String fileName = param.getFileName();
            String filePath = param.getFilePath();
            String fileType = param.getFileType();
            if (param.getType() != null) {
                reportToolInstanceAttachmentFileLink.setType(param.getType());
            }
            String userName = user.getUserName();
            Long userId = user.getId();
            LocalDateTime now = LocalDateTime.now();
            Long id = IdWorker.getId((Object)new Date());
            reportToolInstanceAttachmentFileLink.setId(id);
            reportToolInstanceAttachmentFileLink.setReportId(reportId);
            reportToolInstanceAttachmentFileLink.setFileId(fileId);
            reportToolInstanceAttachmentFileLink.setFileName(fileName);
            reportToolInstanceAttachmentFileLink.setFilePath(filePath);
            reportToolInstanceAttachmentFileLink.setFileType(fileType);
            reportToolInstanceAttachmentFileLink.setCreateId(userId);
            reportToolInstanceAttachmentFileLink.setCreateName(userName);
            reportToolInstanceAttachmentFileLink.setCreateTime(now);
            int i = this.instanceFileLinkMapper.insert(reportToolInstanceAttachmentFileLink);
            if (i > 0) {
                return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f");
            }
            return ApiResponse.fail((String)"\u65b0\u589e\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @Override
    public ApiResponse<Map<String, Object>> delAttachmentFile(Map<String, Object> param) {
        try {
            String idsStr = param.get("ids").toString();
            String[] ids = idsStr.split(",");
            int count = 0;
            int n = 0;
            for (int i = 0; i < ids.length; ++i) {
                if (ids[i] == null || ids[i].equals("")) continue;
                ++count;
                int m = this.instanceFileLinkMapper.deleteById((Serializable)((Object)ids[i]));
                if (m <= 0) continue;
                ++n;
            }
            if (n == count) {
                return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
            }
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @Override
    public ApiResponse<List<ReportToolInstanceAttachmentFileLink>> getAttachmentFileList(Map<String, Object> param) {
        try {
            String reportId = param.get("reportId").toString();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(ReportToolInstanceAttachmentFileLink::getReportId, (Object)reportId);
            List reportToolInstanceAttachmentFileLinkList = this.instanceFileLinkMapper.selectList((Wrapper)queryWrapper);
            return ApiResponse.success((Object)reportToolInstanceAttachmentFileLinkList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @Override
    public List<ReportToolInstanceAttachmentFileLink> getListByReportId(String reportId) {
        QueryWrapper ew = new QueryWrapper();
        ew.lambda().eq(ReportToolInstanceAttachmentFileLink::getReportId, (Object)reportId);
        return this.instanceFileLinkMapper.selectList((Wrapper)ew);
    }

    @Override
    public void deleteByReportId(String reportId) {
        List<ReportToolInstanceAttachmentFileLink> reportAttachmentFileLinkList = this.getListByReportId(reportId);
        if (CollectionUtils.isEmpty(reportAttachmentFileLinkList)) {
            return;
        }
        List ids = reportAttachmentFileLinkList.stream().map(ReportToolInstanceAttachmentFileLink::getId).collect(Collectors.toList());
        this.instanceFileLinkMapper.deleteBatchIds(ids);
    }

    @Override
    public void saveByReportIdAndTemplateFiles(String reportId, List<ReportToolTemplateAttachmentFileLink> attachmentFileLinkList) {
        if (reportId == null || attachmentFileLinkList == null) {
            return;
        }
        ArrayList<ReportToolInstanceAttachmentFileLink> reportAttachmentFileLinkList = new ArrayList<ReportToolInstanceAttachmentFileLink>();
        for (ReportToolTemplateAttachmentFileLink reportTempAttachmentFileLink : attachmentFileLinkList) {
            ReportToolInstanceAttachmentFileLink reportAttachmentFileLink = new ReportToolInstanceAttachmentFileLink();
            reportAttachmentFileLink.setId(IdWorker.getId((Object)new Date()));
            reportAttachmentFileLink.setReportId(Long.valueOf(reportId));
            reportAttachmentFileLink.setFileId(reportTempAttachmentFileLink.getFileId());
            reportAttachmentFileLink.setFileName(reportTempAttachmentFileLink.getFileName());
            reportAttachmentFileLink.setFilePath(reportTempAttachmentFileLink.getFilePath());
            reportAttachmentFileLink.setCreateId(reportTempAttachmentFileLink.getCreateId());
            reportAttachmentFileLink.setCreateName(reportTempAttachmentFileLink.getCreateName());
            reportAttachmentFileLink.setCreateTime(reportTempAttachmentFileLink.getCreateTime());
            reportAttachmentFileLinkList.add(reportAttachmentFileLink);
        }
        this.saveOrUpdateBatch(reportAttachmentFileLinkList);
    }

    @Override
    public void saveOrUpdateByBusinessIdCopy(String reportId, List<ReportToolInstanceAttachmentFileLink> attachmentFileLinkList) {
        if (CollectionUtils.isNotEmpty(attachmentFileLinkList)) {
            attachmentFileLinkList.forEach(file -> {
                file.setReportId(Long.valueOf(reportId));
                file.setId(IdWorker.getId((Object)new Date()));
            });
            this.saveOrUpdateBatch(attachmentFileLinkList);
        }
    }
}

