/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.report.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.common.CommonDocumentInterface;
import com.jxdinfo.document.common.DocumentType;
import com.jxdinfo.document.common.factory.DocumentFactory;
import com.jxdinfo.document.common.model.DocDataBindInfo;
import com.jxdinfo.document.common.model.GenerateReportParam;
import com.jxdinfo.document.common.service.impl.WordTypeInfoServiceImpl;
import com.jxdinfo.document.common.vo.DocumentDetailsVo;
import com.jxdinfo.document.common.vo.DocumentSplitVo;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.FrontendEnum;
import com.jxdinfo.document.excel.tools.report.export.service.ExportExcelService;
import com.jxdinfo.document.excel.tools.report.external.service.WordExcelCommonService;
import com.jxdinfo.document.excel.tools.report.instance.instance.model.ReportToolFormInstance;
import com.jxdinfo.document.excel.tools.report.instance.instance.service.ReportToolFormInstanceCustomService;
import com.jxdinfo.document.excel.tools.report.instance.instance.vo.CopyReportInfoParamVo;
import com.jxdinfo.document.excel.tools.report.instance.instance.vo.ReportToolFormInstanceBaseVo;
import com.jxdinfo.document.excel.tools.report.instance.instance.vo.ReportToolFormInstanceConfigVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="excel.tools.report.external.service.impl.FormInstanceExternalServiceImpl")
public class FormInstanceExternalServiceImpl
implements CommonDocumentInterface,
InitializingBean {
    @Resource
    private ReportToolFormInstanceCustomService toolFromInstanceCustomService;
    @Resource
    private WordTypeInfoServiceImpl wordTypeInfoService;
    @Resource
    private ExportExcelService exportExcelService;
    @Autowired
    private WordExcelCommonService wordExcelCommonService;
    private static final Logger logger = LoggerFactory.getLogger(FormInstanceExternalServiceImpl.class);

    public void checkDocId(Long docId) {
        if (docId == null) {
            throw new IllegalArgumentException(FrontendEnum.RETURN_ID_NULL.getDescription());
        }
    }

    public DocumentDetailsVo queryDocumentDetail(Long reportId) {
        return this.queryOffice(reportId);
    }

    public DocumentDetailsVo queryOffice(Long reportId) {
        this.checkDocId(reportId);
        DocumentDetailsVo documentDetailsVo = new DocumentDetailsVo();
        ReportToolFormInstance reportInfo = this.toolFromInstanceCustomService.getReportInfo(String.valueOf(reportId));
        ReportToolFormInstanceConfigVo configInfo = this.toolFromInstanceCustomService.getReportConfig(String.valueOf(reportId));
        documentDetailsVo.setId(reportId);
        documentDetailsVo.setType(DocumentType.EXCEL_REPORT_TOOL_FORM_INSTANCE.getTypeCode());
        documentDetailsVo.setContent(reportInfo.getReportData());
        HashMap<String, Object> extendResult = new HashMap<String, Object>(16);
        extendResult.put("baseInfo", reportInfo);
        extendResult.put("configInfo", configInfo);
        documentDetailsVo.setExtendResult(extendResult);
        return documentDetailsVo;
    }

    public Long addBlankDocument(String documentName, String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            logger.error("type \u53c2\u6570\u7a7a");
        }
        String reportName = StringUtils.isBlank((CharSequence)documentName) ? "\u65e0\u6807\u9898\u6587\u6863" : documentName;
        Long reportId = this.toolFromInstanceCustomService.addEmptyFormReport();
        this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(reportId, reportName, DocumentType.EXCEL_REPORT_TOOL_FORM_INSTANCE.getTypeCode());
        return reportId;
    }

    public Long copyDocument(Long reportId) {
        this.checkDocId(reportId);
        CopyReportInfoParamVo vo = new CopyReportInfoParamVo();
        vo.setOldReportId(String.valueOf(reportId));
        ApiResponse<ReportToolFormInstanceBaseVo> copyReportInfoApi = this.toolFromInstanceCustomService.copyReportInfo(vo);
        if (copyReportInfoApi.isSuccess()) {
            ReportToolFormInstanceBaseVo resultData = (ReportToolFormInstanceBaseVo)copyReportInfoApi.getData();
            String newReportId = resultData.getReportId();
            this.wordExcelCommonService.copyDocumentByReport(newReportId, null, String.valueOf(reportId));
            return Long.valueOf(newReportId);
        }
        return null;
    }

    public void downloadDocument(HttpServletResponse httpServletResponse, Long reportId) {
        this.exportExcelService.exportReportXlsx(httpServletResponse, reportId);
    }

    public void previewPDF(HttpServletResponse httpServletResponse, Long aLong) {
    }

    public ApiResponse<Long> importDocument(MultipartFile multipartFile, Long reportId, String s) {
        return null;
    }

    public void exportDocument(HttpServletResponse httpServletResponse, Long reportId) {
        this.exportExcelService.exportReportXlsx(httpServletResponse, reportId);
    }

    public DocDataBindInfo getBindConfig(GenerateReportParam generateReportParam) {
        return null;
    }

    public Long generateReport(Long aLong, JSONObject jsonObject) {
        return 0L;
    }

    public JSONObject executeJsGenerateReportJson(Long aLong, String s) {
        return null;
    }

    public DocumentSplitVo getDocumentById(Long aLong) {
        return null;
    }

    public Long addBlankDocument(String documentName, String type, String groupId) {
        if (StringUtils.isBlank((CharSequence)type)) {
            logger.error("type \u53c2\u6570\u7a7a");
        }
        String reportName = StringUtils.isBlank((CharSequence)documentName) ? "\u65e0\u6807\u9898\u6587\u6863" : documentName;
        Long reportId = this.toolFromInstanceCustomService.addEmptyFormReport();
        this.wordExcelCommonService.updateDocumentByReport(String.valueOf(reportId), reportName, groupId);
        return reportId;
    }

    public boolean deleteDocument(Long reportId) {
        this.checkDocId(reportId);
        this.wordTypeInfoService.deleteByReportId(reportId);
        ApiResponse<Boolean> result = this.toolFromInstanceCustomService.deleteReportByIds(Collections.singletonList(String.valueOf(reportId)));
        return result.isSuccess();
    }

    public void downDocument(HttpServletResponse httpServletResponse, Long reportId) {
        this.checkDocId(reportId);
        this.exportExcelService.exportReportXlsx(httpServletResponse, reportId);
    }

    public void afterPropertiesSet() {
        DocumentFactory.add((String)DocumentType.EXCEL_REPORT_TOOL_FORM_INSTANCE.getTypeName(), (CommonDocumentInterface)this);
    }
}

