/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.common.file.controller;

import com.jxdinfo.document.excel.tools.common.file.service.ImgUploadService;
import com.jxdinfo.document.excel.tools.common.file.service.OssFileService;
import com.jxdinfo.document.excel.tools.common.vo.FileLinkParamVo;
import com.jxdinfo.document.excel.tools.core.common.utils.fileUpload.ReportToolImageCompressConfig;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController(value="excel.tools.common.file.controller.ReportFileController")
@AuditLog(moduleName="\u6587\u4ef6\u64cd\u4f5c")
@RequestMapping(value={"/excel/report/file"})
public class ReportFileController {
    @Autowired
    private ImgUploadService imgUploadService;
    @Autowired
    private OssFileService ossFileService;

    @RequestMapping(value={"/uploadImg"})
    public ResponseEntity<Object> uploadImg(@RequestParam(value="file") MultipartFile file, @RequestParam(value="compressFlag") Boolean compressFlag) throws IOException {
        ReportToolImageCompressConfig compressConfig = new ReportToolImageCompressConfig();
        String originalFilename = file.getOriginalFilename();
        if (originalFilename == null) {
            throw new IllegalArgumentException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            InputStream inputStream = file.getInputStream();
            String contentType = file.getContentType();
            Long fileId = this.imgUploadService.compressAndSaveImage(inputStream, originalFilename, contentType, compressConfig, compressFlag);
            HashMap<String, Long> responseMap = new HashMap<String, Long>();
            responseMap.put("fileId", fileId);
            return ResponseEntity.ok().body(responseMap);
        }
        catch (IOException e) {
            return ResponseEntity.status((int)500).body((Object)"File upload failed");
        }
        catch (TranscoderException e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/fileDownload"})
    public void uploadImg(HttpServletResponse response, @RequestBody FileLinkParamVo param) {
        Long fileId = StringUtils.isEmpty((CharSequence)param.getFileId()) ? -1L : Long.parseLong(param.getFileId());
        this.ossFileService.fileDownload(response, fileId);
    }
}

