/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.common.service.impl;

import com.jxdinfo.document.common.dto.DocumentErrorDto;
import com.jxdinfo.document.common.enums.DocumentErrorCodeEnum;
import com.jxdinfo.document.common.model.DocImportCtx;
import com.jxdinfo.document.common.model.WordDocTypeInfo;
import com.jxdinfo.document.common.service.IDocumentInfoService;
import com.jxdinfo.document.common.service.ISysDocumentImpExpService;
import com.jxdinfo.document.common.tool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.document.common.util.FileUtil;
import com.jxdinfo.document.common.util.HussarDocumentThreadUtil;
import com.jxdinfo.document.common.vo.ExportStatusVo;
import com.jxdinfo.document.common.vo.ImportStatusVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.file.ZipUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.document.common.service.impl.SysDocumentImpExpServiceImpl")
public class SysDocumentImpExpServiceImpl
implements ISysDocumentImpExpService {
    private static Logger logger = LoggerFactory.getLogger(SysDocumentImpExpServiceImpl.class);
    @Resource
    private IDocumentInfoService documentInfoService;
    @Autowired
    private ISysDocumentImpExpService iSysDocumentImpExpService;

    @Override
    public void exportDocument(String docIds, HttpServletResponse response) {
        try {
            String downLoadFileName = "document_" + System.currentTimeMillis() + ".document";
            response.setContentType("application/zip");
            response.setHeader("Content-Disposition", "attachment;filename=" + downLoadFileName);
            ServletOutputStream out = response.getOutputStream();
            ArrayList<String> docIdList = new ArrayList<String>();
            if (HussarUtils.isNotEmpty((Object)docIds) && docIds.contains(",")) {
                String[] split = docIds.split(",");
                for (int i = 0; i < split.length; ++i) {
                    docIdList.add(split[i]);
                }
            } else {
                docIdList.add(docIds);
            }
            this.iSysDocumentImpExpService.exportDocuments(docIdList, (OutputStream)out);
            out.flush();
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
    }

    @Override
    public void exportDocuments(List<String> docIds, OutputStream out) {
        String tempFilePath = FileUtils.getTempDirectory() + File.separator + "document";
        ZipOutputStream zos = new ZipOutputStream(out);
        for (String docId : docIds) {
            String documentPath = FileUtil.posixPath(tempFilePath, docId);
            File documentFileDir = new File(documentPath);
            if (!documentFileDir.exists()) {
                documentFileDir.mkdir();
            }
            try {
                this.documentInfoService.createDocumentRelationFile(documentPath, Long.parseLong(docId));
            }
            catch (HussarException e) {
                logger.error("\u6682\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u6587\u4ef6\u5bfc\u51fa:" + (Object)((Object)e));
            }
            catch (NumberFormatException e) {
                logger.error("\u9519\u8bef\u7684\u6587\u6863id:" + e);
            }
            this.addFolderToZip(documentPath, docId, zos);
            this.deleteTempDirectory(documentPath);
        }
        try {
            zos.finish();
        }
        catch (IOException e) {
            throw new HussarException((Throwable)e);
        }
    }

    private void deleteTempDirectory(String documentPath) {
        File directory = new File(documentPath);
        if (directory.exists()) {
            try {
                FileUtils.deleteDirectory((File)directory);
            }
            catch (IOException e) {
                throw new HussarException((Throwable)e);
            }
        }
    }

    private void addFolderToZip(String documentPath, String folderName, ZipOutputStream zos) {
        Path folder = Paths.get(documentPath, new String[0]);
        try {
            String folderEntryName = folderName + "/";
            ZipEntry folderEntry = new ZipEntry(folderEntryName);
            folderEntry.setTime(System.currentTimeMillis());
            zos.putNextEntry(folderEntry);
            zos.closeEntry();
        }
        catch (IOException e) {
            throw new RuntimeException("\u521b\u5efa\u6587\u4ef6\u5939\u6761\u76ee\u5931\u8d25: " + folderName, e);
        }
        try (Stream<Path> paths = Files.walk(folder, new FileVisitOption[0]);){
            paths.forEach(path -> {
                try {
                    if (!Files.isDirectory(path, new LinkOption[0])) {
                        String relativePath = folder.relativize((Path)path).toString();
                        String zipEntryPath = folderName + "/" + relativePath;
                        zipEntryPath = zipEntryPath.replace(File.separatorChar, '/');
                        ZipEntry zipEntry = new ZipEntry(zipEntryPath);
                        zipEntry.setTime(System.currentTimeMillis());
                        zos.putNextEntry(zipEntry);
                        Files.copy(path, zos);
                        zos.closeEntry();
                    } else if (!path.equals(folder)) {
                        String relativeDirPath = folder.relativize((Path)path).toString();
                        String dirEntryPath = folderName + "/" + relativeDirPath + "/";
                        dirEntryPath = dirEntryPath.replace(File.separatorChar, '/');
                        ZipEntry dirEntry = new ZipEntry(dirEntryPath);
                        dirEntry.setTime(System.currentTimeMillis());
                        zos.putNextEntry(dirEntry);
                        zos.closeEntry();
                    }
                }
                catch (IOException e) {
                    throw new HussarException("\u5904\u7406\u6587\u4ef6\u5931\u8d25: " + path, (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            throw new HussarException("\u904d\u5386\u6587\u4ef6\u5939\u5931\u8d25: " + folder, (Throwable)e);
        }
    }

    @Override
    public ApiResponse<ExportStatusVo> getExportProgress(String exportCacheKey) {
        return ApiResponse.success((Object)HussarCacheUtil.get((String)"export_progress", (Object)exportCacheKey, ExportStatusVo.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> importDocuments(File tempRootDir, DocImportCtx docImportCtx) {
        ArrayList<Long> docIdList = new ArrayList<Long>();
        int index = 1;
        String importCacheKey = (String)TransmittableThreadLocalHolder.get("importCacheKey");
        String originalFilename = null;
        HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)ImportStatusVo.put(index, null, false, false));
        ImportStatusVo importStatusVo = (ImportStatusVo)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey);
        File[] tempFiles = tempRootDir.listFiles();
        if (tempFiles != null) {
            try {
                for (File tempFile : tempFiles) {
                    originalFilename = tempFile.getName();
                    String unZipPath = tempRootDir.getAbsolutePath() + File.separator + "unzip_" + System.currentTimeMillis();
                    ZipUtil.unzip((String)tempFile.getAbsolutePath(), (String)unZipPath);
                    File unZipDirectory = new File(unZipPath);
                    if (!unZipDirectory.isDirectory()) {
                        List<Long> list = null;
                        return list;
                    }
                    Object[] fileDirectoryArray = unZipDirectory.listFiles();
                    if (HussarUtils.isEmpty((Object[])fileDirectoryArray)) {
                        importStatusVo.setTotal(0);
                        Object[] objectArray = null;
                        return objectArray;
                    }
                    for (Object file : fileDirectoryArray) {
                        importStatusVo.setTotal(fileDirectoryArray.length);
                        Long docID = this.importSingleReportFile((File)file, importCacheKey, index, docImportCtx);
                        if (!HussarUtils.isNotEmpty((Object)docID)) continue;
                        docIdList.add(docID);
                    }
                    index += 2;
                }
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u5bfc\u5165\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                Map<String, DocumentErrorDto> errors = HussarUtils.isNotEmpty(importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
                DocumentErrorDto error = new DocumentErrorDto();
                error.setName(originalFilename);
                HashMap<String, Object> documentError = new HashMap<String, Object>();
                documentError.put("documentError", DocumentErrorCodeEnum.FILE_NOT_IMPORT.getCode());
                error.setError(documentError);
                errors.put(UUID.randomUUID().toString(), error);
                HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
            }
            finally {
                if (tempRootDir.exists()) {
                    FileUtils.deleteQuietly((File)tempRootDir);
                }
            }
        }
        importStatusVo.setMsg("\u5bfc\u5165\u5b8c\u6210");
        importStatusVo.setFinishFlag(true);
        importStatusVo.setStatus(index);
        HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
        return docIdList;
    }

    private Long importSingleReportFile(File unZipFile, String importCacheKey, int index, DocImportCtx docImportCtx) {
        String unZipPath = unZipFile.getAbsolutePath();
        String fileName = unZipFile.getName();
        ImportStatusVo importStatusVo = (ImportStatusVo)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey);
        int reportTypeCode = -1;
        Long docId = null;
        try {
            String typeInfoPath = FileUtil.posixPath(unZipPath, "wordTypeInfo.json");
            List<WordDocTypeInfo> wordDocTypeInfoList = FileUtil.readFileToArray(typeInfoPath, WordDocTypeInfo.class);
            if (HussarUtils.isNotEmpty(wordDocTypeInfoList)) {
                reportTypeCode = wordDocTypeInfoList.get(0).getReportType();
            }
            if (reportTypeCode < 0) {
                return null;
            }
            docId = this.documentInfoService.importDocumentData(unZipPath, importCacheKey, reportTypeCode, docImportCtx);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6IO\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            Map<String, DocumentErrorDto> errors = HussarUtils.isNotEmpty(importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
            DocumentErrorDto error = new DocumentErrorDto();
            error.setName(fileName);
            if (HussarUtils.isNotEmpty((Object)fileName)) {
                error.setId(Long.parseLong(fileName));
            }
            HashMap<String, Object> reportError = new HashMap<String, Object>();
            reportError.put("reportError", DocumentErrorCodeEnum.FILE_IO.getCode());
            error.setError(reportError);
            errors.put(UUID.randomUUID().toString(), error);
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
        }
        return docId;
    }

    @Override
    public void batchImportDocument(List<MultipartFile> files) {
        this.importDocument(files, "");
    }

    @Override
    public List<Long> singleImportDocument(MultipartFile file) {
        String importCacheKey = (String)TransmittableThreadLocalHolder.get("importCacheKey");
        String tempFileName = FileUtils.getTempDirectory() + File.separator + "report_import";
        String basePath = FileUtil.posixPath(tempFileName, UUID.randomUUID().toString());
        File tempRootDir = null;
        try {
            tempRootDir = Files.createDirectories(Paths.get(basePath, new String[0]), new FileAttribute[0]).toFile();
            String originalFilename = file.getOriginalFilename();
            if (originalFilename == null || !originalFilename.endsWith(".document")) {
                ImportStatusVo importStatusVo = ImportStatusVo.put(0, "\u5bfc\u5165\u5931\u8d25", false, true);
                Map<String, DocumentErrorDto> errors = HussarUtils.isNotEmpty(importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
                DocumentErrorDto error = new DocumentErrorDto();
                error.setName(originalFilename);
                HashMap<String, Object> documentError = new HashMap<String, Object>();
                documentError.put("documentError", DocumentErrorCodeEnum.FILE_NOT_HUSSAR.getCode());
                error.setError(documentError);
                errors.put(UUID.randomUUID().toString(), error);
                HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
                throw new BaseException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u4e3a .document \u6587\u4ef6");
            }
            File tempFile = new File(tempRootDir, originalFilename);
            file.transferTo(tempFile);
        }
        catch (IOException e) {
            logger.error("\u5b58\u50a8\u5bfc\u5165\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            ImportStatusVo importStatusVo = ImportStatusVo.put(0, "\u5bfc\u5165\u5931\u8d25", false, true);
            Map<String, DocumentErrorDto> errors = HussarUtils.isNotEmpty(importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
            DocumentErrorDto error = new DocumentErrorDto();
            error.setName("file");
            HashMap<String, Object> documentError = new HashMap<String, Object>();
            documentError.put("documentError", DocumentErrorCodeEnum.FILE_NOT_CREATE.getCode());
            error.setError(documentError);
            errors.put(UUID.randomUUID().toString(), error);
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
            throw new BaseException("\u5b58\u50a8\u5bfc\u5165\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        DocImportCtx docImportCtx = new DocImportCtx();
        File finalTempRootDir = tempRootDir;
        return this.importDocuments(finalTempRootDir, docImportCtx);
    }

    @Override
    public void batchImportDocument(List<MultipartFile> files, String groupId) {
        this.importDocument(files, groupId);
    }

    @Override
    public ApiResponse<ImportStatusVo> getImportProgress(String importCacheKey) {
        return ApiResponse.success((Object)(HussarUtils.isNotEmpty((Object)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey, ImportStatusVo.class)) ? (ImportStatusVo)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey, ImportStatusVo.class) : ImportStatusVo.put(1, "\u6b63\u5728\u5bfc\u5165", false, false)));
    }

    private void importDocument(List<MultipartFile> files, String groupId) {
        String importCacheKey = (String)TransmittableThreadLocalHolder.get("importCacheKey");
        String tempFileName = FileUtils.getTempDirectory() + File.separator + "report_import";
        String basePath = FileUtil.posixPath(tempFileName, UUID.randomUUID().toString());
        File tempRootDir = null;
        try {
            tempRootDir = Files.createDirectories(Paths.get(basePath, new String[0]), new FileAttribute[0]).toFile();
            for (MultipartFile file : files) {
                String originalFilename = file.getOriginalFilename();
                if (originalFilename == null || !originalFilename.endsWith(".document")) {
                    ImportStatusVo importStatusVo = ImportStatusVo.put(0, "\u5bfc\u5165\u5931\u8d25", false, true);
                    Map<String, DocumentErrorDto> errors = HussarUtils.isNotEmpty(importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
                    DocumentErrorDto error = new DocumentErrorDto();
                    error.setName(originalFilename);
                    HashMap<String, Object> documentError = new HashMap<String, Object>();
                    documentError.put("documentError", DocumentErrorCodeEnum.FILE_NOT_HUSSAR.getCode());
                    error.setError(documentError);
                    errors.put(UUID.randomUUID().toString(), error);
                    HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
                    throw new BaseException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u4e3a .document \u6587\u4ef6");
                }
                File tempFile = new File(tempRootDir, originalFilename);
                file.transferTo(tempFile);
            }
        }
        catch (IOException e) {
            logger.error("\u5b58\u50a8\u5bfc\u5165\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            ImportStatusVo importStatusVo = ImportStatusVo.put(0, "\u5bfc\u5165\u5931\u8d25", false, true);
            Map<String, DocumentErrorDto> errors = HussarUtils.isNotEmpty(importStatusVo.getData()) ? (Map)importStatusVo.getData() : new HashMap();
            DocumentErrorDto error = new DocumentErrorDto();
            error.setName("file");
            HashMap<String, Object> documentError = new HashMap<String, Object>();
            documentError.put("documentError", DocumentErrorCodeEnum.FILE_NOT_CREATE.getCode());
            error.setError(documentError);
            errors.put(UUID.randomUUID().toString(), error);
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)importStatusVo);
            throw new BaseException("\u5b58\u50a8\u5bfc\u5165\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        DocImportCtx docImportCtx = new DocImportCtx();
        docImportCtx.setGroupId(groupId);
        File finalTempRootDir = tempRootDir;
        HussarDocumentThreadUtil.executeDesignTask(() -> {
            try {
                this.importDocuments(finalTempRootDir, docImportCtx);
            }
            catch (Exception e) {
                logger.error("\u5bfc\u5165\u62a5\u544a\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                if (HussarUtils.isNotEmpty((Object)importCacheKey)) {
                    HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)ImportStatusVo.put(0, "\u5bfc\u5165\u62a5\u544a\u65f6\u53d1\u751f\u5f02\u5e38", false, true));
                }
                e.printStackTrace();
                throw new HussarException((Throwable)e);
            }
        });
    }
}

