/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.common.util;

import com.jxdinfo.document.common.dto.AttachmentInfoDto;
import com.jxdinfo.document.common.model.DocImageSize;
import com.jxdinfo.document.common.service.IFileService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DocumentToolUtils {
    private static Logger logger = LoggerFactory.getLogger(DocumentToolUtils.class);
    private static final double INCH_TO_CM = 2.54;
    public static final int DPI_96 = 96;
    private static IFileService staticFileService;
    @Autowired(required=false)
    private IFileService fileService;
    private static final Set<String> SUPPORTED_IMAGE_TYPES;

    @PostConstruct
    public void init() {
        staticFileService = this.fileService;
    }

    public static boolean isNullOrEmptyString(Object obj) {
        if (HussarUtils.isEmpty((Object)obj)) {
            return true;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return str.trim().isEmpty();
        }
        return false;
    }

    public static DocImageSize getImageDimensionBySrc(String src) {
        if (HussarUtils.isEmpty((Object)src)) {
            return null;
        }
        InputStream imageStream = DocumentToolUtils.getImageStream(src);
        try {
            return DocumentToolUtils.getImageDimension(imageStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream getImageStream(String src) {
        InputStream inputStream = null;
        if (src.contains("showPicture?id=")) {
            Long imageId = Long.parseLong(src.substring(src.indexOf("showPicture?id=") + 15));
            AttachmentInfoDto image = staticFileService.getModelById(imageId);
            if (image != null) {
                ApiResponse<byte[]> apiResponse = staticFileService.backgroundDownload(imageId);
                inputStream = new ByteArrayInputStream((byte[])apiResponse.getData());
            }
        } else if (src.contains("fileDownload?fileId=")) {
            Long imageId = Long.parseLong(src.substring(src.indexOf("fileDownload?fileId=") + 20));
            AttachmentInfoDto image = staticFileService.getModelById(imageId);
            if (image != null) {
                ApiResponse<byte[]> apiResponse = staticFileService.backgroundDownload(imageId);
                inputStream = new ByteArrayInputStream((byte[])apiResponse.getData());
            }
        } else if (StringUtils.isNotBlank((CharSequence)src) && DocumentToolUtils.isSupportBase64(src)) {
            Base64.Decoder decoder = Base64.getDecoder();
            inputStream = new ByteArrayInputStream(decoder.decode(src.split(",")[1]));
        } else if (StringUtils.isNotBlank((CharSequence)src) && src.startsWith("http://")) {
            try {
                URL url = new URL(src);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                connection.setInstanceFollowRedirects(true);
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    throw new IOException("HTTP\u8bf7\u6c42\u5931\u8d25\uff0c\u72b6\u6001\u7801: " + responseCode);
                }
                inputStream = connection.getInputStream();
            }
            catch (SocketTimeoutException e) {
                logger.warn("\u8df3\u8fc7\u56fe\u7247\u52a0\u8f7d\uff0c\u8fde\u63a5\u8d85\u65f6: " + src);
            }
            catch (Exception e) {
                logger.warn("\u8df3\u8fc7\u56fe\u7247\u52a0\u8f7d\uff0c\u53d1\u751f\u9519\u8bef: " + src, (Throwable)e);
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocImageSize getImageDimension(InputStream inputStream) throws IOException {
        Throwable throwable = null;
        try (ImageInputStream iis = ImageIO.createImageInputStream(inputStream);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (!readers.hasNext()) {
                throw new IOException("\u4e0d\u652f\u6301\u7684\u56fe\u7247\u683c\u5f0f");
            }
            ImageReader reader = readers.next();
            try {
                reader.setInput(iis);
                DocImageSize docImageSize = new DocImageSize(reader.getWidth(0), reader.getHeight(0));
                reader.dispose();
                return docImageSize;
            }
            catch (Throwable throwable2) {
                try {
                    reader.dispose();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
    }

    public static double pxToCm(int pixels) {
        return DocumentToolUtils.pxToCm(pixels, 96);
    }

    public static double pxToCm(int pixels, int dpi) {
        if (dpi <= 0) {
            throw new IllegalArgumentException("DPI\u5fc5\u987b\u5927\u4e8e0");
        }
        if (pixels < 0) {
            throw new IllegalArgumentException("\u50cf\u7d20\u503c\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        return (double)pixels / (double)dpi * 2.54;
    }

    public static boolean isSupportBase64(String src) {
        return DocumentToolUtils.isBase64(src) && DocumentToolUtils.isSupportedImageBase64(src);
    }

    private static boolean isBase64(String str) {
        if (str == null || str.trim().isEmpty()) {
            return false;
        }
        String pureBase64 = DocumentToolUtils.extractPureBase64(str);
        if (pureBase64.length() % 4 != 0) {
            return false;
        }
        if (!Pattern.matches("^[A-Za-z0-9+/]*={0,2}$", pureBase64)) {
            return false;
        }
        try {
            Base64.getDecoder().decode(pureBase64);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static boolean isSupportedImageBase64(String base64Str) {
        String imageType = DocumentToolUtils.getBase64ImageType(base64Str);
        return !"unknown".equals(imageType) && DocumentToolUtils.isImageTypeSupported(imageType);
    }

    private static String getBase64ImageType(String base64Str) {
        if (base64Str == null || base64Str.trim().isEmpty()) {
            return "unknown";
        }
        String typeFromPrefix = DocumentToolUtils.getImageTypeFromPrefix(base64Str);
        if (!"unknown".equals(typeFromPrefix)) {
            return typeFromPrefix;
        }
        return DocumentToolUtils.getImageTypeFromMagicNumber(base64Str);
    }

    private static String extractPureBase64(String base64Str) {
        int base64Index;
        if (base64Str.startsWith("data:image/") && base64Str.contains(";base64,") && (base64Index = base64Str.indexOf(";base64,") + 8) < base64Str.length()) {
            return base64Str.substring(base64Index);
        }
        return base64Str;
    }

    public static boolean isImageTypeSupported(String imageType) {
        if (imageType == null || imageType.trim().isEmpty()) {
            return false;
        }
        return SUPPORTED_IMAGE_TYPES.contains(imageType.toLowerCase());
    }

    private static String getImageTypeFromPrefix(String base64Str) {
        try {
            Pattern pattern = Pattern.compile("data:image/([a-zA-Z]+);base64,");
            Matcher matcher = pattern.matcher(base64Str);
            if (matcher.find()) {
                return matcher.group(1).toLowerCase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown";
    }

    private static String getImageTypeFromMagicNumber(String base64Str) {
        try {
            String pureBase64 = DocumentToolUtils.extractPureBase64(base64Str);
            byte[] imageBytes = Base64.getDecoder().decode(pureBase64);
            if (imageBytes.length < 8) {
                return "unknown";
            }
            if (imageBytes.length >= 2 && (imageBytes[0] & 0xFF) == 255 && (imageBytes[1] & 0xFF) == 216) {
                return "jpg";
            }
            if (imageBytes.length >= 8 && (imageBytes[0] & 0xFF) == 137 && (imageBytes[1] & 0xFF) == 80 && (imageBytes[2] & 0xFF) == 78 && (imageBytes[3] & 0xFF) == 71 && (imageBytes[4] & 0xFF) == 13 && (imageBytes[5] & 0xFF) == 10 && (imageBytes[6] & 0xFF) == 26 && (imageBytes[7] & 0xFF) == 10) {
                return "png";
            }
            if (imageBytes.length >= 2 && (imageBytes[0] & 0xFF) == 66 && (imageBytes[1] & 0xFF) == 77) {
                return "bmp";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown";
    }

    static {
        SUPPORTED_IMAGE_TYPES = new HashSet<String>(Arrays.asList("png", "jpg", "jpeg", "bmp", "jpeg"));
    }
}

