/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.document.common.DocumentType;
import com.jxdinfo.document.common.dao.WordDocTypeInfoMapper;
import com.jxdinfo.document.common.model.WordDocTypeInfo;
import com.jxdinfo.document.common.service.IWordTypeInfoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.document.common.service.impl.WordTypeInfoServiceImpl")
public class WordTypeInfoServiceImpl
extends HussarServiceImpl<WordDocTypeInfoMapper, WordDocTypeInfo>
implements IWordTypeInfoService {
    @Resource
    private WordDocTypeInfoMapper wordDocTypeInfoMapper;
    public static final String WORD_EMPTY_MODEL_NAME_DEFAULT = "\u65e0\u6807\u9898\u6587\u6863";

    @Override
    public List<WordDocTypeInfo> queryList(Long docId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(WordDocTypeInfo::getReportId, (Object)docId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        List infoList = ((WordDocTypeInfoMapper)this.baseMapper).selectList((Wrapper)lambdaQueryWrapper);
        return infoList;
    }

    @Override
    public int insert(WordDocTypeInfo wordDocTypeInfo) {
        return ((WordDocTypeInfoMapper)this.baseMapper).insert((Object)wordDocTypeInfo);
    }

    @Override
    public ApiResponse<Long> addWordTypeInfo(Long reportId, String reportName, int reportType) {
        WordDocTypeInfo wordDocTypeInfo = new WordDocTypeInfo();
        Long wordDocTypeInfoId = IdUtil.getSnowflakeNextId();
        wordDocTypeInfo.setId(wordDocTypeInfoId);
        wordDocTypeInfo.setReportId(reportId);
        wordDocTypeInfo.setReportName(reportName);
        wordDocTypeInfo.setReportType(reportType);
        ((WordDocTypeInfoMapper)this.baseMapper).insert((Object)wordDocTypeInfo);
        return ApiResponse.success((Object)wordDocTypeInfoId);
    }

    @Override
    public ApiResponse<Long> addOrUpdateWordDocTypeInfo(Long reportId, String reportName, int typeCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        WordDocTypeInfo wordDocTypeInfo = new WordDocTypeInfo();
        ((LambdaQueryWrapper)queryWrapper.eq(WordDocTypeInfo::getReportId, (Object)reportId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        List typeInfoList = ((WordDocTypeInfoMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)typeInfoList)) {
            wordDocTypeInfo.setId(((WordDocTypeInfo)((Object)typeInfoList.get(0))).getId());
            if (typeCode < 0) {
                typeCode = ((WordDocTypeInfo)((Object)typeInfoList.get(0))).getReportType();
            }
        } else {
            long nextId = IdUtil.getSnowflakeNextId();
            wordDocTypeInfo.setId(nextId);
            if (typeCode < 0) {
                typeCode = DocumentType.WORD_MODEL.getTypeCode();
            }
        }
        wordDocTypeInfo.setReportId(reportId);
        wordDocTypeInfo.setReportName(reportName);
        wordDocTypeInfo.setReportType(typeCode);
        this.saveOrUpdate((BaseEntity)wordDocTypeInfo);
        return ApiResponse.success((Object)wordDocTypeInfo.getId());
    }

    @Override
    public ApiResponse<Long> addOrUpdateWordDocTypeInfo(Long reportId, String reportName, int typeCode, Long groupId) {
        WordDocTypeInfo wordDocTypeInfo = new WordDocTypeInfo();
        List<WordDocTypeInfo> typeInfoList = this.queryList(reportId);
        if (HussarUtils.isNotEmpty(typeInfoList)) {
            wordDocTypeInfo.setId(typeInfoList.get(0).getId());
            if (typeCode < 0) {
                typeCode = typeInfoList.get(0).getReportType();
            }
        } else {
            long nextId = IdUtil.getSnowflakeNextId();
            wordDocTypeInfo.setId(nextId);
            if (typeCode < 0) {
                typeCode = DocumentType.WORD_MODEL.getTypeCode();
            }
        }
        wordDocTypeInfo.setReportId(reportId);
        wordDocTypeInfo.setReportName(reportName);
        wordDocTypeInfo.setReportType(typeCode);
        wordDocTypeInfo.setGroupId(groupId);
        this.saveOrUpdate((BaseEntity)wordDocTypeInfo);
        return ApiResponse.success((Object)wordDocTypeInfo.getId());
    }

    @Override
    public ApiResponse<Long> addOrUpdateWordDocTypeInfo(WordDocTypeInfo originalWordDocTypeInfo) {
        WordDocTypeInfo wordDocTypeInfo = new WordDocTypeInfo();
        if (HussarUtils.isNotEmpty((Object)originalWordDocTypeInfo.getId())) {
            wordDocTypeInfo.setId(originalWordDocTypeInfo.getId());
        } else {
            wordDocTypeInfo.setId(IdUtil.getSnowflakeNextId());
        }
        wordDocTypeInfo.setReportId(originalWordDocTypeInfo.getReportId());
        wordDocTypeInfo.setReportName(originalWordDocTypeInfo.getReportName());
        wordDocTypeInfo.setReportType(originalWordDocTypeInfo.getReportType());
        wordDocTypeInfo.setGroupId(originalWordDocTypeInfo.getGroupId());
        if (HussarUtils.isNotEmpty((Object)originalWordDocTypeInfo.getParentReportId())) {
            wordDocTypeInfo.setParentReportId(originalWordDocTypeInfo.getParentReportId());
        }
        this.saveOrUpdate((BaseEntity)wordDocTypeInfo);
        return ApiResponse.success((Object)wordDocTypeInfo.getId());
    }

    @Override
    public boolean deleteByReportId(Long reportId) {
        List<WordDocTypeInfo> docTypeInfoList = this.queryList(reportId);
        if (HussarUtils.isNotEmpty(docTypeInfoList)) {
            docTypeInfoList.get(0).setDelFlag("1");
            Long id = docTypeInfoList.get(0).getId();
            int deletedRows = this.wordDocTypeInfoMapper.deleteById(id);
            return deletedRows > 0;
        }
        return false;
    }

    public Long copyWordTypeInfo(Long oldDocId, Long newDocId, int defaultTypeCode, Long groupId, Long parentModelId) {
        List<WordDocTypeInfo> docTypeInfoList = this.queryList(oldDocId);
        String modelName = WORD_EMPTY_MODEL_NAME_DEFAULT;
        int typeCode = defaultTypeCode;
        if (HussarUtils.isNotEmpty(docTypeInfoList)) {
            modelName = docTypeInfoList.get(0).getReportName();
            typeCode = docTypeInfoList.get(0).getReportType();
        }
        WordDocTypeInfo wordDocTypeInfo = new WordDocTypeInfo();
        wordDocTypeInfo.setReportId(newDocId);
        wordDocTypeInfo.setReportName(modelName);
        wordDocTypeInfo.setReportType(typeCode);
        wordDocTypeInfo.setGroupId(groupId);
        wordDocTypeInfo.setParentReportId(parentModelId);
        return (Long)this.addOrUpdateWordDocTypeInfo(wordDocTypeInfo).getData();
    }
}

