/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.data.invocation.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.jxdinfo.document.data.invocation.model.DataSetConfig;
import com.jxdinfo.document.data.invocation.model.DatasetUsageDetails;
import com.jxdinfo.document.data.invocation.model.DocumentParamModel;
import com.jxdinfo.document.data.invocation.model.GroupByCondition;
import com.jxdinfo.document.data.invocation.model.InputParamModel;
import com.jxdinfo.document.data.invocation.model.QueryConditionsDetail;
import com.jxdinfo.document.data.invocation.model.SortConditionModel;
import com.jxdinfo.document.data.invocation.model.SymbolEnum;
import com.jxdinfo.document.data.invocation.service.DataInvocationService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.dataset.model.DataSetCommonParam;
import com.jxdinfo.hussar.dataset.model.DataSetCondition;
import com.jxdinfo.hussar.dataset.service.IDataSetEngineService;
import com.jxdinfo.hussar.dataset.vo.DataSetExecuteVO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.document.data.invocation.service.impl.DataInvocationServiceImpl")
public class DataInvocationServiceImpl
implements DataInvocationService {
    @Resource
    @Lazy
    private IDataSetEngineService dataSetEngineService;
    Map<String, DatasetUsageDetails> datasetMap = new HashMap<String, DatasetUsageDetails>();
    private Map<String, Object> resultCache = new ConcurrentHashMap<String, Object>();

    @Override
    public Map<String, Object> getUsageData(JSONArray dataSetDetails, JSONArray documentParam, Map<String, Object> inputValue) {
        this.datasetMap.clear();
        this.resultCache.clear();
        if (HussarUtils.isEmpty((Object)dataSetDetails)) {
            return null;
        }
        HashMap<String, Object> dataSetData = new HashMap<String, Object>();
        for (Object dataSetDetail : dataSetDetails) {
            DatasetUsageDetails datasetUsageDetails = (DatasetUsageDetails)JSON.parseObject((String)dataSetDetail.toString(), DatasetUsageDetails.class);
            this.datasetMap.put(datasetUsageDetails.getWordDataSetId(), datasetUsageDetails);
        }
        Map<Integer, List<String>> executionLevels = this.getExecutionLevels(this.datasetMap);
        for (Integer level : executionLevels.keySet()) {
            List<String> datasetIds = executionLevels.get(level);
            dataSetData.putAll(this.dealNoDependencyDataset(datasetIds, documentParam, inputValue));
        }
        return dataSetData;
    }

    private Map<String, Object> dealNoDependencyDataset(List<String> datasetIds, JSONArray documentParam, Map<String, Object> inputValue) {
        ArrayList<DataSetCommonParam> dataSetCommonParamList = new ArrayList<DataSetCommonParam>();
        HashMap<String, Object> dataSetData = new HashMap<String, Object>();
        for (String datasetId : datasetIds) {
            DatasetUsageDetails datasetUsageDetails = this.getDataset(datasetId);
            String wordDataSetId = datasetUsageDetails.getWordDataSetId();
            DataSetCondition dataSetCondition = this.buildNoDependencyDataset(datasetUsageDetails, documentParam, inputValue);
            if (!HussarUtils.isNotEmpty((Object)dataSetCondition)) continue;
            DataSetCommonParam dataSetCommonParam = new DataSetCommonParam();
            dataSetCommonParam.setUnifiedId(wordDataSetId);
            dataSetCommonParam.setDataSetCondition(dataSetCondition);
            dataSetCommonParamList.add(dataSetCommonParam);
        }
        ApiResponse listApiResponse = this.dataSetEngineService.executeDataSetParam(dataSetCommonParamList);
        if (listApiResponse.isSuccess() && HussarUtils.isNotEmpty((Object)listApiResponse.getData())) {
            List data = (List)listApiResponse.getData();
            for (DataSetExecuteVO datum : data) {
                if (HussarUtils.isNotEmpty((Object)datum) && HussarUtils.isNotEmpty((Object)datum.getUnifiedId())) {
                    this.resultCache.put(datum.getUnifiedId(), datum.getReturnValue() == null ? "" : datum.getReturnValue());
                }
                dataSetData.put(datum.getUnifiedId(), this.buildReturnValue(datum));
            }
        }
        return dataSetData;
    }

    private DataSetCondition buildNoDependencyDataset(DatasetUsageDetails dataSetDetail, JSONArray documentParam, Map<String, Object> inputValue) {
        if (HussarUtils.isEmpty((Object)dataSetDetail)) {
            return null;
        }
        String bindDataSetId = dataSetDetail.getBindDataSetId();
        DataSetCondition dataSetCondition = new DataSetCondition();
        dataSetCondition.setDataSetId(bindDataSetId);
        ArrayList<OrderItem> orderItemList = new ArrayList<OrderItem>();
        ArrayList<SuperQueryConditionDto> queryList = new ArrayList<SuperQueryConditionDto>();
        List<Object> groupRuleList = new ArrayList();
        DataSetConfig dataSetConfig = dataSetDetail.getDataSetConfigs();
        if (HussarUtils.isNotEmpty((Object)dataSetConfig)) {
            this.buildOrder(orderItemList, dataSetConfig.getSortCondition());
            List<QueryConditionsDetail> detailList = dataSetConfig.getQueryConditionsDetail();
            for (QueryConditionsDetail conditionsDetail : detailList) {
                Object value = this.getQueryParamsValue(documentParam, inputValue, conditionsDetail);
                if (HussarUtils.isEmpty((Object)value) && (!SymbolEnum.IS_NOT_NULL.getValue().equals(conditionsDetail.getSymbol()) && !SymbolEnum.IS_NULL.getValue().equals(conditionsDetail.getSymbol()) || "sourceDataSet".equals(conditionsDetail.getType()))) continue;
                SuperQueryConditionDto superQueryConditionDto = new SuperQueryConditionDto();
                superQueryConditionDto.setMatch(conditionsDetail.getConnect());
                superQueryConditionDto.setField(conditionsDetail.getField());
                superQueryConditionDto.setVal(value);
                String rule = SymbolEnum.getByField(SymbolEnum::getValue, conditionsDetail.getSymbol()).getRelation();
                superQueryConditionDto.setRule(rule);
                queryList.add(superQueryConditionDto);
            }
            groupRuleList = this.buildGroupRule(dataSetConfig.getGroupByCondition());
        }
        dataSetCondition.setDataSetFunctionType(dataSetDetail.getWordDataSetType());
        dataSetCondition.setOrders(orderItemList);
        dataSetCondition.setSuperQueryConditionDto(queryList);
        dataSetCondition.setGroupRule(groupRuleList);
        dataSetCondition.setPagination(false);
        return dataSetCondition;
    }

    private Object getQueryParamsValue(JSONArray documentParam, Map<String, Object> inputValue, QueryConditionsDetail conditionsDetail) {
        Object obj = null;
        switch (conditionsDetail.getType()) {
            case "modelParam": {
                obj = this.getModelParamValue(conditionsDetail.getConfigData(), documentParam, inputValue, conditionsDetail.getSymbol());
                break;
            }
            case "input": {
                String configData = conditionsDetail.getConfigData();
                if (HussarUtils.isNotEmpty((Object)configData) && (configData.contains(",") || configData.contains("\uff0c"))) {
                    if (this.isSymbolList(conditionsDetail.getSymbol())) {
                        if (configData.contains(",")) {
                            obj = configData.split(",");
                            break;
                        }
                        if (!configData.contains("\uff0c")) break;
                        obj = configData.split("\uff0c");
                        break;
                    }
                    if (configData.contains(",")) {
                        obj = configData.split(",")[0];
                        break;
                    }
                    if (!configData.contains("\uff0c")) break;
                    obj = configData.split("\uff0c")[0];
                    break;
                }
                obj = configData;
                break;
            }
            case "session": {
                obj = this.getSessionValue(conditionsDetail);
                break;
            }
            case "sourceDataSet": {
                Object value = this.getDatasetValue(conditionsDetail.getSourceWordDataSetId(), conditionsDetail.getSourceWordDataSetFieldId());
                if (value instanceof ArrayList && !this.isSymbolList(conditionsDetail.getSymbol())) {
                    ArrayList list = (ArrayList)value;
                    if (!HussarUtils.isNotEmpty((Object)list)) break;
                    obj = list.get(0);
                    break;
                }
                obj = value;
            }
        }
        return obj;
    }

    private boolean isSymbolList(String symbol) {
        return SymbolEnum.IN.getValue().equals(symbol) || SymbolEnum.NOT_IN.getValue().equals(symbol);
    }

    private Object getDatasetValue(String dataSetId, List<String> fromFields) {
        Object result = this.resultCache.get(dataSetId);
        int index = 0;
        if (HussarUtils.isNotEmpty((Object)result)) {
            return this.extractValue(result, index, fromFields);
        }
        return null;
    }

    private Object extractValue(Object object, int currentIndex, List<String> fromFields) {
        if (HussarUtils.isEmpty((Object)object) || HussarUtils.isEmpty(fromFields) || currentIndex >= fromFields.size()) {
            return null;
        }
        String fieldName = fromFields.get(currentIndex);
        Object parseObj = JSON.parse((String)object.toString());
        if (parseObj instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)parseObj;
            Object childObj = jsonObject.get((Object)fieldName);
            if (currentIndex == fromFields.size() - 1) {
                return childObj;
            }
            return this.extractValue(childObj, ++currentIndex, fromFields);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        JSONArray jsonArray = (JSONArray)parseObj;
        if (currentIndex == fromFields.size() - 1) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                Object childObj = jsonObject.get((Object)fieldName);
                list.add(childObj);
            }
        } else {
            ++currentIndex;
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                Object childObj = jsonObject.get((Object)fieldName);
                this.extractValueFromArray(childObj, currentIndex, fromFields, list);
            }
        }
        return list;
    }

    private void extractValueFromArray(Object object, int currentIndex, List<String> fromFields, List<Object> list) {
        if (HussarUtils.isEmpty((Object)object) || HussarUtils.isEmpty(fromFields)) {
            return;
        }
        String fieldName = fromFields.get(currentIndex);
        if (object instanceof JSONObject) {
            JSONObject jsonObject = JSON.parseObject((String)object.toString());
            Object childObj = jsonObject.get((Object)fieldName);
            if (currentIndex == fromFields.size() - 1) {
                list.add(childObj);
            } else {
                this.extractValueFromArray(childObj, ++currentIndex, fromFields, list);
            }
        } else {
            Object childObj;
            JSONObject jsonObject;
            int i;
            JSONArray jsonArray = JSON.parseArray((String)object.toString());
            if (currentIndex == fromFields.size() - 1) {
                for (i = 0; i < jsonArray.size(); ++i) {
                    jsonObject = jsonArray.getJSONObject(i);
                    childObj = jsonObject.get((Object)fieldName);
                    list.add(childObj);
                }
            }
            ++currentIndex;
            for (i = 0; i < jsonArray.size(); ++i) {
                jsonObject = jsonArray.getJSONObject(i);
                childObj = jsonObject.get((Object)fieldName);
                this.extractValueFromArray(childObj, currentIndex, fromFields, list);
            }
        }
    }

    private DatasetUsageDetails getDataset(String datasetId) {
        DatasetUsageDetails datasetUsageDetails = this.datasetMap.get(datasetId);
        if (HussarUtils.isEmpty((Object)datasetUsageDetails)) {
            throw new HussarException("\u672a\u67e5\u8be2\u5230id\u4e3a" + datasetId + "\u7684\u6570\u636e\u96c6");
        }
        return datasetUsageDetails;
    }

    private Map<Integer, List<String>> getExecutionLevels(Map<String, DatasetUsageDetails> datasets) {
        List<String> sortedIds = this.sortDatasets(datasets);
        TreeMap<Integer, List<String>> levels = new TreeMap<Integer, List<String>>();
        HashMap reverseGraph = new HashMap();
        for (String string : datasets.keySet()) {
            reverseGraph.put(string, new HashSet());
        }
        for (Map.Entry entry : datasets.entrySet()) {
            DatasetUsageDetails currentDataset = (DatasetUsageDetails)entry.getValue();
            String currentDatasetId = (String)entry.getKey();
            DataSetConfig dataSetConfigs = currentDataset.getDataSetConfigs();
            if (!HussarUtils.isNotEmpty((Object)dataSetConfigs)) continue;
            List<QueryConditionsDetail> queryConditionsDetailList = dataSetConfigs.getQueryConditionsDetail();
            for (QueryConditionsDetail queryConditionsDetail : queryConditionsDetailList) {
                if (!"sourceDataSet".equals(queryConditionsDetail.getType())) continue;
                ((Set)reverseGraph.get(entry.getKey())).add(queryConditionsDetail.getSourceWordDataSetId());
            }
        }
        HashMap<String, Integer> depthMap = new HashMap<String, Integer>();
        for (String id : sortedIds) {
            int maxDepth = 0;
            for (String depId : (Set)reverseGraph.get(id)) {
                maxDepth = Math.max(maxDepth, depthMap.getOrDefault(depId, 0) + 1);
            }
            depthMap.put(id, maxDepth);
            levels.computeIfAbsent(maxDepth, k -> new ArrayList()).add(id);
        }
        return levels;
    }

    private List<String> sortDatasets(Map<String, DatasetUsageDetails> datasets) {
        HashMap<String, Set<String>> dependencyGraph = new HashMap<String, Set<String>>();
        HashMap<String, Integer> inDegreeMap = new HashMap<String, Integer>();
        for (String string : datasets.keySet()) {
            dependencyGraph.put(string, new HashSet());
            inDegreeMap.put(string, 0);
        }
        for (Map.Entry entry : datasets.entrySet()) {
            String currentId = (String)entry.getKey();
            DatasetUsageDetails currentDataset = (DatasetUsageDetails)entry.getValue();
            this.statisticsDegreeCount(datasets, currentDataset, dependencyGraph, currentId, inDegreeMap);
        }
        return this.topologicalSort(dependencyGraph, inDegreeMap);
    }

    private void statisticsDegreeCount(Map<String, DatasetUsageDetails> datasets, DatasetUsageDetails currentDataset, Map<String, Set<String>> dependencyGraph, String currentId, Map<String, Integer> inDegreeMap) {
        DataSetConfig dataSetConfig = currentDataset.getDataSetConfigs();
        if (HussarUtils.isNotEmpty((Object)dataSetConfig)) {
            List<QueryConditionsDetail> queryConditionsDetailList = dataSetConfig.getQueryConditionsDetail();
            for (QueryConditionsDetail queryConditionsDetail : queryConditionsDetailList) {
                if (!"sourceDataSet".equals(queryConditionsDetail.getType())) continue;
                String refDatasetId = queryConditionsDetail.getSourceWordDataSetId();
                if (!datasets.containsKey(refDatasetId)) {
                    throw new HussarException("\u5e94\u7528\u7684\u6570\u636e\u96c6\u4e0d\u5b58\u5728:" + refDatasetId);
                }
                dependencyGraph.computeIfAbsent(refDatasetId, k -> new HashSet()).add(currentId);
                inDegreeMap.put(currentId, inDegreeMap.get(currentId) + 1);
            }
        }
    }

    private List<String> topologicalSort(Map<String, Set<String>> graph, Map<String, Integer> inDegree) {
        ArrayList<String> sortedList = new ArrayList<String>();
        LinkedList<String> queue = new LinkedList<String>();
        for (Map.Entry<String, Integer> entry : inDegree.entrySet()) {
            if (entry.getValue() != 0) continue;
            queue.offer(entry.getKey());
        }
        while (!queue.isEmpty()) {
            String current = (String)queue.poll();
            sortedList.add(current);
            if (!graph.containsKey(current)) continue;
            for (String dependent : graph.get(current)) {
                int newDegree = inDegree.get(dependent) - 1;
                inDegree.put(dependent, newDegree);
                if (newDegree != 0) continue;
                queue.offer(dependent);
            }
        }
        if (sortedList.size() != graph.size()) {
            ArrayList<String> cycleNodes = new ArrayList<String>();
            for (String node : graph.keySet()) {
                if (sortedList.contains(node)) continue;
                cycleNodes.add(node);
            }
            throw new HussarException("\u68c0\u6d4b\u5230\u5faa\u73af\u4f9d\u8d56: " + cycleNodes);
        }
        return sortedList;
    }

    @NotNull
    private List<InputParamModel> getInputParamModelList(JSONArray documentParam, Map<String, Object> inputValue) {
        List documentParamModels;
        ArrayList<InputParamModel> inputParamModelList = new ArrayList<InputParamModel>();
        if (HussarUtils.isNotEmpty((Object)documentParam) && HussarUtils.isNotEmpty((Object)(documentParamModels = JSON.parseArray((String)documentParam.toJSONString(), DocumentParamModel.class)))) {
            for (DocumentParamModel documentParamModel : documentParamModels) {
                Object value = inputValue.get(documentParamModel.getParamName());
                InputParamModel model = new InputParamModel();
                model.setParamId(documentParamModel.getParamId());
                model.setParamDataType(documentParamModel.getParamDataType());
                model.setParamName(documentParamModel.getParamName());
                model.setParamValue(String.valueOf(value));
                inputParamModelList.add(model);
            }
        }
        return inputParamModelList;
    }

    private Object getSessionValue(QueryConditionsDetail queryConditionsDetail) {
        Object paramValue = null;
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        switch (queryConditionsDetail.getConfigData()) {
            case "default_user_id": {
                paramValue = securityUser.getUserId();
                break;
            }
            case "default_user_name": {
                paramValue = securityUser.getUserName();
                break;
            }
            case "default_organ_id": {
                paramValue = securityUser.getDeptId();
                break;
            }
            case "default_organ_name": {
                paramValue = securityUser.getDeptName();
                break;
            }
            case "default_organ_code": {
                paramValue = securityUser.getDeptCode();
                break;
            }
            case "default_user_role": {
                List rolesList = securityUser.getRolesList();
                if (!this.isSymbolList(queryConditionsDetail.getSymbol())) {
                    paramValue = HussarUtils.isNotEmpty((Object)rolesList) ? rolesList.get(0) : null;
                    break;
                }
                paramValue = rolesList;
                break;
            }
        }
        return paramValue;
    }

    private Object getModelParamValue(String paramId, JSONArray documentParam, Map<String, Object> inputValue, String symbol) {
        Object obj = null;
        String[] paramValue = "";
        List<InputParamModel> inputParamModelList = this.getInputParamModelList(documentParam, inputValue);
        for (InputParamModel inputParamModel : inputParamModelList) {
            if (!paramId.equals(inputParamModel.getParamId())) continue;
            paramValue = inputParamModel.getParamValue();
            break;
        }
        if (HussarUtils.isNotEmpty((Object)paramValue) && (paramValue.contains(",") || paramValue.contains("\uff0c"))) {
            if (this.isSymbolList(symbol)) {
                if (paramValue.contains(",")) {
                    obj = paramValue.split(",");
                } else if (paramValue.contains("\uff0c")) {
                    obj = paramValue.split("\uff0c");
                }
            } else if (paramValue.contains(",")) {
                obj = paramValue.split(",")[0];
            } else if (paramValue.contains("\uff0c")) {
                obj = paramValue.split("\uff0c")[0];
            }
        } else {
            obj = paramValue;
        }
        return obj;
    }

    private List<String> buildGroupRule(List<GroupByCondition> groupByCondition) {
        ArrayList<String> groupRuleList = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(groupByCondition)) {
            for (GroupByCondition group : groupByCondition) {
                groupRuleList.add(group.getGroupByData());
            }
        }
        return groupRuleList;
    }

    private void buildOrder(List<OrderItem> itemList, List<SortConditionModel> sortConditions) {
        if (HussarUtils.isEmpty(sortConditions)) {
            return;
        }
        for (SortConditionModel sortCondition : sortConditions) {
            OrderItem orderItem = new OrderItem();
            orderItem.setAsc("asc".equalsIgnoreCase(sortCondition.getSortWay()));
            orderItem.setColumn(sortCondition.getField());
            itemList.add(orderItem);
        }
    }

    private Object buildReturnValue(DataSetExecuteVO dataSetExecuteVO) {
        return dataSetExecuteVO.getReturnValue();
    }
}

