/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.data.build.binddata.provide.data;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.common.model.DocImageSize;
import com.jxdinfo.document.common.util.DocumentToolUtils;
import com.jxdinfo.document.data.build.binddata.empty.BindDataCtx;
import com.jxdinfo.document.data.build.binddata.empty.BindDataSource;
import com.jxdinfo.document.data.build.binddata.factory.BindNodeProvideFactory;
import com.jxdinfo.document.data.build.binddata.model.ImageDataStructure;
import com.jxdinfo.document.data.build.binddata.node.ImageBindNode;
import com.jxdinfo.document.data.build.binddata.provide.BindDataVisitor;
import com.jxdinfo.document.data.build.binddata.util.BindDataSourceUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.data.build.binddata.provide.data.image")
public class ImageNodeDataProvide
implements BindDataVisitor {
    public static final String provideName = "com.jxdinfo.data.build.binddata.provide.data.image";

    @PostConstruct
    public void register() {
        BindNodeProvideFactory.register(provideName, this);
    }

    @Override
    public JSONObject getNodeDataSet(JSONObject nodeJsonObj, BindDataCtx bindDataCtx) {
        if (HussarUtils.isEmpty((Object)nodeJsonObj.get((Object)"bindKey"))) {
            return null;
        }
        ImageBindNode imageBindNode = (ImageBindNode)JsonUtil.convertValue((Object)nodeJsonObj, ImageBindNode.class);
        BindDataSource bindDataSource = imageBindNode.getBindDataSource();
        JSONObject result = new JSONObject();
        if (HussarUtils.isEmpty((Object)bindDataSource) || HussarUtils.isEmpty((Object)bindDataSource.getBindSourceType())) {
            result.put(imageBindNode.getBindKey(), (Object)"");
            return result;
        }
        Object nodeData = BindDataSourceUtil.analysisBindDataSourceConfig(bindDataSource, bindDataCtx);
        if (bindDataCtx.isIncrement() && DocumentToolUtils.isNullOrEmptyString((Object)nodeData)) {
            return null;
        }
        result.put(imageBindNode.getBindKey(), this.dealImageSize(nodeData));
        return result;
    }

    private Object dealImageSize(Object nodeData) {
        if (HussarUtils.isEmpty((Object)nodeData)) {
            return nodeData;
        }
        if (nodeData instanceof String) {
            String src = (String)nodeData;
            return this.processSingleSrc(src);
        }
        if (nodeData instanceof List) {
            List srcList = (List)nodeData;
            return this.processSrcList(srcList);
        }
        return nodeData;
    }

    private Object processSingleSrc(String src) {
        DocImageSize imageDimension;
        if (HussarUtils.isNotEmpty((Object)src) && HussarUtils.isNotEmpty((Object)(imageDimension = DocumentToolUtils.getImageDimensionBySrc((String)src)))) {
            return new ImageDataStructure(src, imageDimension.getWidth(), imageDimension.getHeight());
        }
        return src;
    }

    private Object processSrcList(List<String> srcList) {
        if (HussarUtils.isNotEmpty(srcList)) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (String src : srcList) {
                list.add(this.processSingleSrc(src));
            }
            return list;
        }
        return srcList;
    }
}

