/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.data.build.binddata.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.data.build.binddata.content.BindConstant;
import com.jxdinfo.document.data.build.binddata.empty.BindDataCtx;
import com.jxdinfo.document.data.build.binddata.factory.BindNodeClassFactory;
import com.jxdinfo.document.data.build.binddata.factory.BindNodeProvideFactory;
import com.jxdinfo.document.data.build.binddata.node.BindNode;
import com.jxdinfo.document.data.build.binddata.provide.BindDataVisitor;
import com.jxdinfo.document.data.build.binddata.service.DocumentDataSetBuildService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.document.data.build.binddata.service.impl.DocumentDataSetBuildServiceImpl")
public class DocumentDataSetBuildServiceImpl
implements DocumentDataSetBuildService {
    @Override
    public JSONObject buildDataSet(JSONObject dataBindDetails, JSONArray dataSetDetails, Map<String, Map<String, Object>> inputParam) {
        BindDataCtx bindDataCtx = new BindDataCtx();
        bindDataCtx.setInputValue(inputParam.get("inputParam"));
        bindDataCtx.setCustomParams(inputParam.get("customParams"));
        bindDataCtx.setDataSetDetails(dataSetDetails);
        return this.buildNodeDetails(dataBindDetails, bindDataCtx);
    }

    @Override
    public JSONObject buildNodeDetails(JSONObject nodeJsonObj, BindDataCtx bindDataCtx) {
        String nodeType = String.valueOf(nodeJsonObj.get((Object)BindConstant.JSON_TYPE));
        BindDataVisitor bindDataVisitor = BindNodeProvideFactory.get("com.jxdinfo.data.build.binddata.provide.data." + nodeType);
        BindNode bindNode = (BindNode)JSON.parseObject((String)nodeJsonObj.toString(), BindNode.class);
        return bindDataVisitor.getNodeDataSet(nodeJsonObj, bindDataCtx);
    }

    private static BindNode serializeNode(JSONObject documentDataSet, JSONObject nodeJsonObj, BindDataCtx bindDataCtx) {
        String nodeType = String.valueOf(nodeJsonObj.get((Object)BindConstant.JSON_TYPE));
        String clazz = BindNodeClassFactory.get("root" + nodeType);
        if (HussarUtils.isEmpty((Object)clazz)) {
            return null;
        }
        BindNode bindNode = null;
        Method[] methods = null;
        try {
            Class.forName(clazz);
            methods = Class.forName(clazz).getDeclaredMethods();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (HussarUtils.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!"serializationNode".equals(method.getName())) continue;
                try {
                    bindNode = (BindNode)method.invoke(null, documentDataSet, nodeJsonObj, bindDataCtx);
                    break;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (HussarUtils.isNotEmpty(bindNode) && HussarUtils.isNotEmpty((Object)nodeJsonObj.get((Object)"bindContent"))) {
                JSONArray childContent = nodeJsonObj.getJSONArray("bindContent");
                for (Object o : childContent) {
                    BindNode childNode = DocumentDataSetBuildServiceImpl.serializeNode(documentDataSet, JSON.parseObject((String)o.toString()), bindDataCtx);
                    if (!HussarUtils.isNotEmpty((Object)childNode)) continue;
                    bindNode.getBindContent().add(childNode);
                }
            }
            return bindNode;
        }
        return null;
    }
}

