/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.utils;

import com.jxdinfo.crm.transaction.operationsmanage.contract.crmagreementproduct.model.CrmAgreementProduct;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class ReadCrmAgreementExcelUtil {
    private static int totalRows = 0;
    private static int totalCells = 0;
    private static String errorMsg;

    public static List<CrmAgreementProduct> getExcelInfo(MultipartFile mFile) {
        String fileName = mFile.getOriginalFilename();
        try {
            if (!ReadCrmAgreementExcelUtil.validateExcel(fileName)) {
                return null;
            }
            boolean isExcel2003 = true;
            if (ReadCrmAgreementExcelUtil.isExcel2007(fileName)) {
                isExcel2003 = false;
            }
            List<CrmAgreementProduct> userList = ReadCrmAgreementExcelUtil.createExcel(mFile.getInputStream(), isExcel2003);
            return userList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<CrmAgreementProduct> createExcel(InputStream is, boolean isExcel2003) {
        try {
            Object wb = isExcel2003 ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            List<CrmAgreementProduct> opportunityEntityList = ReadCrmAgreementExcelUtil.readExcelValue((Workbook)wb);
            return opportunityEntityList;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List<CrmAgreementProduct> readExcelValue(Workbook wb) {
        Sheet sheet = wb.getSheetAt(0);
        totalRows = sheet.getPhysicalNumberOfRows();
        if (totalRows > 1 && sheet.getRow(0) != null) {
            totalCells = sheet.getRow(0).getPhysicalNumberOfCells();
        }
        ArrayList<CrmAgreementProduct> crmAgreementProductList = new ArrayList<CrmAgreementProduct>();
        for (int r = 1; r < totalRows; ++r) {
            Row row = sheet.getRow(r);
            if (row == null) continue;
            Cell cell0 = row.getCell(0);
            if (row == null || cell0 == null || CellType.STRING.equals((Object)cell0.getCellType()) && "".equals(cell0.getStringCellValue())) continue;
            CrmAgreementProduct crmAgreementProduct = new CrmAgreementProduct();
            block12: for (int c = 0; c < totalCells; ++c) {
                Cell cell = row.getCell(c);
                if (!ToolUtil.isNotEmpty((Object)cell)) continue;
                switch (c) {
                    case 0: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        crmAgreementProduct.setProductName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block12;
                    }
                    case 2: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        crmAgreementProduct.setSpecificationModel(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block12;
                    }
                    case 3: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        crmAgreementProduct.setProductUnit(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block12;
                    }
                    case 4: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        String productAmount = cell.getStringCellValue().replaceAll("\\s*|\r|\n", "");
                        Integer amount = 0;
                        if (StringUtil.isNotBlank((CharSequence)productAmount)) {
                            amount = Integer.valueOf(productAmount);
                        }
                        crmAgreementProduct.setProductAmount(amount);
                    }
                    case 5: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        String includeTaxUnitPrice = cell.getStringCellValue().replaceAll("\\s*|\r|\n", "");
                        Double includeUnitPrice = 0.0;
                        if (StringUtil.isNotBlank((CharSequence)includeTaxUnitPrice)) {
                            includeUnitPrice = Double.valueOf(includeTaxUnitPrice);
                        }
                        crmAgreementProduct.setIncludeTaxUnitPrice(includeUnitPrice);
                        continue block12;
                    }
                    case 6: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        String taxRate = cell.getStringCellValue().replaceAll("\\s*|\r|\n", "");
                        Double rate = 0.0;
                        if (StringUtil.isNotBlank((CharSequence)taxRate)) {
                            rate = Double.valueOf(taxRate);
                        }
                        crmAgreementProduct.setTaxRate(rate);
                        continue block12;
                    }
                    case 7: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        String unincludeTaxUnitPrice = cell.getStringCellValue().replaceAll("\\s*|\r|\n", "");
                        Double unincludeUnitPrice = 0.0;
                        if (StringUtil.isNotBlank((CharSequence)unincludeTaxUnitPrice)) {
                            unincludeUnitPrice = Double.valueOf(unincludeTaxUnitPrice);
                        }
                        crmAgreementProduct.setUnincludeTaxUnitPrice(unincludeUnitPrice);
                        continue block12;
                    }
                    case 8: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        String includeTaxTotalPrice = cell.getStringCellValue().replaceAll("\\s*|\r|\n", "");
                        Double includeTotalPrice = 0.0;
                        if (StringUtil.isNotBlank((CharSequence)includeTaxTotalPrice)) {
                            includeTotalPrice = Double.valueOf(includeTaxTotalPrice);
                        }
                        crmAgreementProduct.setIncludeTaxTotalPrice(includeTotalPrice);
                        continue block12;
                    }
                    case 9: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        String unincludeTaxTotalPrice = cell.getStringCellValue().replaceAll("\\s*|\r|\n", "");
                        Double unincludeTotalPrice = 0.0;
                        if (StringUtil.isNotBlank((CharSequence)unincludeTaxTotalPrice)) {
                            unincludeTotalPrice = Double.valueOf(unincludeTaxTotalPrice);
                        }
                        crmAgreementProduct.setUnincludeTaxTotalPrice(unincludeTotalPrice);
                        continue block12;
                    }
                }
            }
            crmAgreementProductList.add(crmAgreementProduct);
        }
        return crmAgreementProductList;
    }

    public static boolean validateExcel(String filePath) {
        if (filePath == null || !ReadCrmAgreementExcelUtil.isExcel2003(filePath) && !ReadCrmAgreementExcelUtil.isExcel2007(filePath)) {
            errorMsg = "\u6587\u4ef6\u540d\u4e0d\u662fexcel\u683c\u5f0f";
            return false;
        }
        return true;
    }

    public static boolean isExcel2003(String filePath) {
        return filePath.matches("^.+\\.(?i)(xls)$");
    }

    public static boolean isExcel2007(String filePath) {
        return filePath.matches("^.+\\.(?i)(xlsx)$");
    }
}

