/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.operationsmanage.ledger.job.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.constant.BillPeriodLedgerConstant;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.dao.BillPeriodLedgerMapper;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.dto.BillPeriodLedgerDto;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.job.service.ConfirmReceivableService;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.model.BillPeriodLedger;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ConfirmReceivableServiceImpl
implements ConfirmReceivableService {
    @Resource
    private BillPeriodLedgerMapper billPeriodLedgerMapper;
    @Resource
    private UnifyProperties unifyProperties;

    @Override
    public ProcessResult confirmReceivableProcess() {
        List<String> pushDateList = this.getPushDateList();
        BillPeriodLedgerDto dto = new BillPeriodLedgerDto();
        dto.setPushDateList(pushDateList);
        List<BillPeriodLedger> list = this.billPeriodLedgerMapper.receiveLedgerList(Collections.singletonList(dto), null, null);
        if (CollectionUtils.isNotEmpty(list)) {
            HashMap<Long, String> notificationMessages = new HashMap<Long, String>();
            notificationMessages.put(83L, "3\u6708");
            notificationMessages.put(87L, "3\u6708");
            notificationMessages.put(143L, "5\u6708");
            notificationMessages.put(147L, "5\u6708");
            notificationMessages.put(203L, "7\u6708");
            notificationMessages.put(207L, "7\u6708");
            notificationMessages.put(263L, "9\u6708");
            notificationMessages.put(267L, "9\u6708");
            notificationMessages.put(323L, "11\u6708");
            notificationMessages.put(327L, "11\u6708");
            notificationMessages.put(358L, "\u4e00\u5e74\u671f\u4ee5\u4e0a");
            notificationMessages.put(362L, "\u4e00\u5e74\u671f\u4ee5\u4e0a");
            for (BillPeriodLedger ledger : list) {
                if (!ToolUtil.isNotEmpty((Object)ledger.getConfirmReceivableDate()) || !ToolUtil.isNotEmpty((Object)ledger.getDaysDifference())) continue;
                LocalDate dueDate = ledger.getConfirmReceivableDate().plusDays(ledger.getDaysDifference());
                String contentUnify = "\u60a8\u7684\u5ba2\u6237\u3010" + ledger.getCustomerName() + "\u3011\u7684\u5408\u540c\u3010" + ledger.getAgreementNumber() + ledger.getAgreementName() + "\u3011\u4e0b\u7684\u8d26\u671f\u5c06\u4e8e\u3010" + dueDate + "\u3011\u5373\u5c06\u8d85\u8fc7\u3010" + (String)notificationMessages.get(ledger.getDaysDifference()) + "\u3011\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8";
                AddSysMessageType addSysMessageType = new AddSysMessageType();
                String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/contractDetails?row=" + "\"" + ledger.getAgreementId() + "\"";
                addSysMessageType.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
                addSysMessageType.setMessageContent(contentUnify);
                addSysMessageType.setReleaseDate(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                addSysMessageType.setUserId(String.valueOf(ledger.getAgreementChargePerson()));
                addSysMessageType.setCreator(ledger.getCreator());
                addSysMessageType.setCreatoeDepartmentId(String.valueOf(ledger.getCreateDepartment()));
                addSysMessageType.setLastEditor(ledger.getCreator());
                addSysMessageType.setMessageIssue("\u8d85\u7ea7\u7ba1\u7406\u5458");
                addSysMessageType.setBusinessAddress(unifyWebUrl);
                addSysMessageType.setMobileBusinessAddress("");
                addSysMessageType.setOpenWay("1");
                UnifyUtil.sendMessage((AddSysMessageType)addSysMessageType);
            }
        }
        return new ProcessResult(true);
    }

    List<String> getPushDateList() {
        ArrayList<String> pushDateList = new ArrayList<String>();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        for (Long days : BillPeriodLedgerConstant.addDateList) {
            LocalDate pushDate = LocalDate.now().minusDays(days);
            pushDateList.add(dtf.format(pushDate));
        }
        return pushDateList;
    }
}

