/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.operationsmanage.ledger.service.impl;

import com.jxdinfo.crm.transaction.operationsmanage.ledger.model.WarrantyLedger;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.service.IWarrantyLedgerBillPeriodService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Component(value="WarrantyLedgerBillPeriodServiceImpl")
public class WarrantyLedgerBillPeriodServiceImpl
implements IWarrantyLedgerBillPeriodService {
    private static final Logger log = LoggerFactory.getLogger(WarrantyLedgerBillPeriodServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WarrantyLedger> billPeriod(List<WarrantyLedger> warrantyLedger) {
        if (warrantyLedger == null || warrantyLedger.isEmpty()) {
            return warrantyLedger;
        }
        KieServices kieServices = KieServices.Factory.get();
        KieContainer kieContainer = kieServices.getKieClasspathContainer("myKbase1");
        LocalDateTime now = LocalDateTime.now();
        for (WarrantyLedger item : warrantyLedger) {
            KieSession kieSession = null;
            try {
                kieSession = kieContainer.newKieSession("ksession-rule");
                if (item.getReceivableDate() != null && item.getQualityRefundDate() == null) {
                    if (item.getQualityReduceAmount() == null) {
                        item.setQualityReduceAmount(BigDecimal.ZERO);
                    }
                    if (item.getRefundAmount() == null) {
                        item.setRefundAmount(BigDecimal.ZERO);
                    }
                    if (item.getRefundAmount().add(item.getQualityReduceAmount()).compareTo(item.getQualityAmount()) != 0) {
                        Long days = this.calculateDaysBetween(item.getReceivableDate(), now);
                        kieSession.insert((Object)days);
                        kieSession.insert((Object)item);
                        kieSession.fireAllRules();
                    }
                } else {
                    item.setTermOfPayment(null);
                }
                this.setExpireStatus(item, now);
            }
            catch (Exception e) {
                log.error("Error processing WarrantyLedger: {}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                if (kieSession == null) continue;
                kieSession.dispose();
            }
        }
        return warrantyLedger;
    }

    private Long calculateDaysBetween(LocalDateTime receivableDate, LocalDateTime now) {
        if (receivableDate == null) {
            return null;
        }
        return ChronoUnit.DAYS.between(receivableDate, now);
    }

    private void setExpireStatus(WarrantyLedger item, LocalDateTime now) {
        if (item.getQualityExpireDate() != null) {
            LocalDate nowDate = now.toLocalDate();
            LocalDate expireDate = item.getQualityExpireDate().toLocalDate();
            if (expireDate.isAfter(nowDate)) {
                item.setExpireStatus("\u672a\u5230\u671f");
            } else {
                item.setExpireStatus("\u5df2\u5230\u671f");
            }
        }
    }
}

