/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.utils;

import com.jxdinfo.crm.core.utills.ExcelHeader;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class ExcelExportHelper {
    public static void writeCellValue(Cell cell, Object value, List<DicSingle> dictList, Workbook workbook) {
        if (value instanceof String && dictList != null) {
            String stringValue = (String)value;
            if (!stringValue.isEmpty()) {
                for (DicSingle dicSingle : dictList) {
                    if (!stringValue.equals(dicSingle.getValue())) continue;
                    cell.setCellValue(dicSingle.getLabel());
                    return;
                }
            }
        } else {
            ExcelExportHelper.setCellValueByType(cell, value, workbook);
        }
    }

    private static void setCellValueByType(Cell cell, Object value, Workbook workbook) {
        if (value instanceof String) {
            cell.setCellValue((String)value);
        } else if (value instanceof Long) {
            cell.setCellValue(((Long)value).doubleValue());
        } else if (value instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)value).doubleValue());
        } else if (value instanceof Timestamp) {
            LocalDateTime ldt = ((Timestamp)value).toLocalDateTime();
            Date excelDate = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
            cell.setCellValue(excelDate);
            CreationHelper createHelper = workbook.getCreationHelper();
            DataFormat dataFormat = createHelper.createDataFormat();
            short dateFormat = dataFormat.getFormat("yyyy-MM-dd");
            cell.setCellStyle(ExcelExportHelper.createDateFormatCellStyle(workbook, dateFormat));
        } else if (value instanceof Integer || value instanceof Float) {
            cell.setCellValue(((Number)value).doubleValue());
        } else {
            cell.setCellValue(value != null ? value.toString() : "");
        }
    }

    private static CellStyle createDateFormatCellStyle(Workbook workbook, short dateFormat) {
        CellStyle style = workbook.createCellStyle();
        style.setDataFormat(dateFormat);
        return style;
    }

    public static CellStyle createHeaderCellStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setBold(true);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFont(font);
        return style;
    }

    public static <T> List<String> getHeadersForEntity(Class<T> entityClass) {
        Field[] fields;
        ArrayList<String> headers = new ArrayList<String>();
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ExcelHeader.class)) continue;
            try {
                field.setAccessible(true);
                ExcelHeader header = field.getAnnotation(ExcelHeader.class);
                String headerValue = header.value()[0];
                headers.add(headerValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return headers;
    }

    public static void setColumnWidth(XSSFSheet sheet, int colNum) {
        for (int i = 0; i < colNum; ++i) {
            int v = 0;
            v = Math.round(Float.parseFloat("15.0") * 37.0f);
            v = Math.round(Float.parseFloat("20.0") * 267.5f);
            sheet.setColumnWidth(i, v);
        }
    }
}

