/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.teammember.crmteammember.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.crm.common.api.organUser.IStruUserAPIService;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.transaction.constants.TeamMemberStateEnum;
import com.jxdinfo.crm.transaction.teammember.crmteammember.dao.CrmTeamMemberMapper;
import com.jxdinfo.crm.transaction.teammember.crmteammember.dto.CrmTeamMemberDto;
import com.jxdinfo.crm.transaction.teammember.crmteammember.model.CrmTeamMember;
import com.jxdinfo.crm.transaction.teammember.crmteammember.service.CrmTeamMemberService;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="teammember.crmteammember.CrmTeamMemberServiceImpl")
@HussarTokenDs
public class CrmTeamMemberServiceImpl
extends HussarServiceImpl<CrmTeamMemberMapper, CrmTeamMember>
implements CrmTeamMemberService {
    private static final Logger logger = LoggerFactory.getLogger(CrmTeamMemberServiceImpl.class);
    private static final String RETURN_CODE = "0";
    private static final String ORDER_RULE = "orderRule";
    private static final String DEFAULT_ORDER_RULE = "defaultOrderRule";
    private static final String ASC = ",asc;";
    private static final String DESC = ",desc;";
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private IStruUserAPIService struUserAPIService;

    public List<CrmTeamMember> getByMap(Map<String, Object> map) {
        return this.list((Wrapper)new LambdaQueryWrapper(BeanUtil.copy(map, CrmTeamMember.class)));
    }

    @Override
    public ApiResponse<CrmTeamMember> formQuery(String id) {
        try {
            return ApiResponse.success((Object)this.getById((Serializable)((Object)id)));
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u5355\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> flowFormSubmit(CrmTeamMemberDto crmTeamMemberDto) {
        CrmTeamMember crmTeamMember = crmTeamMemberDto.getFormdata();
        try {
            CrmTeamMember oldTeamMember = (CrmTeamMember)this.getById(crmTeamMember.getTeamMemberId());
            if (TeamMemberStateEnum.CHECK_REJECT.getMemberState().equals(oldTeamMember.getState())) {
                TeamMeberEntity targetEntity = new TeamMeberEntity();
                this.copyBeanData(targetEntity, crmTeamMember);
                this.teamMeberService.updateModifyPowerById(targetEntity);
                this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CrmTeamMember::getTeamMemberId, (Object)crmTeamMember.getTeamMemberId())).set(CrmTeamMember::getState, (Object)TeamMemberStateEnum.CHECK_ING.getMemberState())).set(CrmTeamMember::getProcessKey, (Object)"bpm_tdfxsh")).set(CrmTeamMember::getFlowStatus, (Object)"2")).set(CrmTeamMember::getProcessState, (Object)RETURN_CODE));
            } else {
                this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CrmTeamMember::getTeamMemberId, (Object)crmTeamMember.getTeamMemberId())).set(CrmTeamMember::getState, (Object)TeamMemberStateEnum.CHECK_FINISH.getMemberState())).set(CrmTeamMember::getProcessKey, (Object)"bpm_tdfxsh")).set(CrmTeamMember::getFlowStatus, (Object)"4")).set(CrmTeamMember::getProcessState, (Object)"1"));
            }
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
        this.formsubmit(crmTeamMemberDto, String.valueOf(crmTeamMember.getTeamMemberId()));
        return ApiResponse.success((Object)String.valueOf(crmTeamMember.getTeamMemberId()), (String)"\u63d0\u4ea4\u6d41\u7a0b\u8868\u5355\u6210\u529f");
    }

    @Override
    @HussarTransactional
    @HussarTokenDs
    public void formsubmit(CrmTeamMemberDto crmTeamMemberDto, String businessKey) {
        BpmResponseResult bpmResponseResult;
        if (HussarUtils.isEmpty((Object)BaseSecurityUtil.getUser())) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        HashMap<String, String> appointMap = new HashMap<String, String>();
        HashMap<String, Object> variable = new HashMap<String, Object>();
        String taskId = crmTeamMemberDto.getTaskId();
        String comment = crmTeamMemberDto.getComment();
        if (crmTeamMemberDto.getFlowSelect() == null) {
            appointMap.put("static_appoint_assignee", crmTeamMemberDto.getParticipantSelect());
        } else {
            appointMap.put(crmTeamMemberDto.getFlowSelect(), crmTeamMemberDto.getParticipantSelect());
            variable.put("bpm_next_node", crmTeamMemberDto.getFlowSelect());
        }
        if (crmTeamMemberDto.getFormdata() != null && HussarUtils.isNotEmpty((Object)crmTeamMemberDto.getFormdata().getSecurityLevel())) {
            variable.put("security_level", crmTeamMemberDto.getFormdata().getSecurityLevel());
        }
        if (crmTeamMemberDto.getSelectBranches() != null) {
            ArrayList<String> nextNodeIds = new ArrayList<String>();
            HashMap<String, String> multiTypeMap = new HashMap<String, String>();
            for (Map<String, String> map : crmTeamMemberDto.getSelectBranches()) {
                appointMap.put(map.get("flowSelect"), map.get("participants"));
                if (HussarUtils.isNotEmpty((Object)map.get("multiNodeType"))) {
                    multiTypeMap.put(map.get("flowSelect"), map.get("multiNodeType"));
                }
                nextNodeIds.add(map.get("flowSelect"));
            }
            if (HussarUtils.isNotEmpty(multiTypeMap)) {
                variable.put("multi_node_type", multiTypeMap);
            }
            variable.put("bpm_next_node", String.join((CharSequence)",", nextNodeIds));
        }
        String processDefinitionKey = crmTeamMemberDto.getProcessDefinitionKey();
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        if (HussarUtils.isEmpty((Object)taskId)) {
            String deptId = BaseSecurityUtil.getUser().getDeptId() == null ? "" : String.valueOf(BaseSecurityUtil.getUser().getDeptId());
            BpmResponseResult startResult = InstanceEngineService.startProcessInstanceByKey((String)processDefinitionKey, (String)userId, (String)deptId, (String)businessKey, variable);
            if ("1".equals(startResult.getCode())) {
                taskId = (String)startResult.getResult().getJSONObject(0).get((Object)"taskId");
                CrmTeamMember entity = (CrmTeamMember)this.getById((Serializable)((Object)businessKey));
                entity.setProcessInstId(Long.valueOf(taskId));
                this.updateById(entity);
            } else {
                throw new HussarException(startResult.getMsg());
            }
        }
        if (!"1".equals((bpmResponseResult = TaskEngineService.completeTask((String)taskId, (String)userId, appointMap, null, (String)comment, variable)).getCode())) {
            throw new HussarException(bpmResponseResult.getMsg());
        }
        CrmTeamMember entity = (CrmTeamMember)this.getById((Serializable)((Object)businessKey));
        if ("\u7ed3\u675f".equals(bpmResponseResult.getResult().getJSONObject(0).getString("taskDefinitionName"))) {
            entity.setState(TeamMemberStateEnum.CHECK_FINISH.getMemberState());
        } else {
            taskId = (String)bpmResponseResult.getResult().getJSONObject(0).get((Object)"taskId");
            entity.setProcessInstId(Long.valueOf(taskId));
        }
        this.saveOrUpdate(entity);
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> prevNodeReject(CrmTeamMemberDto crmTeamMemberDto) {
        try {
            CrmTeamMember crmTeamMember = crmTeamMemberDto.getFormdata();
            String taskId = crmTeamMemberDto.getTaskId() == null ? "" : crmTeamMemberDto.getTaskId();
            String comment = crmTeamMemberDto.getComment() == null ? "" : crmTeamMemberDto.getComment();
            crmTeamMember.setState(TeamMemberStateEnum.CHECK_REJECT.getMemberState());
            crmTeamMember.setFlowStatus("3");
            boolean resultFlag = this.saveOrUpdate(crmTeamMember);
            if (!resultFlag) {
                return ApiResponse.fail((String)"NOPERMISSION");
            }
            ApiResponse<String> stringApiResponse = this.startAnyNodeRejectInstance(taskId, comment);
            taskId = stringApiResponse.getMsg();
            crmTeamMember.setProcessInstId(Long.valueOf(taskId));
            this.updateById(crmTeamMember);
            return ApiResponse.success((String)"");
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    @HussarTokenDs
    public ApiResponse<String> startAnyNodeRejectInstance(String taskId, String comment) {
        if (HussarUtils.isEmpty((Object)BaseSecurityUtil.getUser())) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        try {
            BpmResponseResult bpmResponseResult = TaskEngineService.rejectToLastTask((String)taskId, (String)userId, (String)comment, null, (boolean)true, null);
            if ("1".equals(bpmResponseResult.getCode())) {
                return ApiResponse.success((String)((String)bpmResponseResult.getResult().getJSONObject(0).get((Object)"taskId")));
            }
            throw new HussarException(bpmResponseResult.getMsg());
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public ApiResponse<String> submitForMember(Map<String, Object> map) {
        ArrayList addTeamMemberList = new ArrayList();
        Boolean resultFlag = this.teamMeberService.addCrmTeamMemberAndGroup(map, addTeamMemberList);
        if (!resultFlag.booleanValue()) {
            return ApiResponse.fail((String)"NOPERMISSION");
        }
        if (addTeamMemberList.size() > 0) {
            String chargeCompanyId;
            CrmTeamMember chargeInfo = null;
            List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmTeamMember::getBusinessId, (Object)((String)map.get("businessId")))).eq(CrmTeamMember::getIsCharge, (Object)"1")).eq(CrmTeamMember::getDelFlag, (Object)RETURN_CODE));
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                chargeInfo = (CrmTeamMember)list.get(0);
                chargeCompanyId = this.struUserAPIService.getCompanyInfoByUserId(chargeInfo.getPersonId() + "").getId() + "";
            } else {
                chargeCompanyId = "";
            }
            String securityLevel = map.get("securityLevel").toString();
            addTeamMemberList.stream().forEach(oneMember -> {
                SysStru companyInfo = this.struUserAPIService.getCompanyInfoByUserId(oneMember.getPersonId() + "");
                String memberCompanyId = companyInfo.getId() + "";
                Integer secretLevel = Integer.valueOf(companyInfo.getInforLevel());
                if (StringUtil.isNotEmpty((Object)securityLevel)) {
                    secretLevel = Integer.valueOf(securityLevel);
                }
                if (RETURN_CODE.equals(oneMember.getIsCharge()) && !memberCompanyId.equals(chargeCompanyId)) {
                    this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CrmTeamMember::getTeamMemberId, (Object)oneMember.getTeamMeberId())).set(CrmTeamMember::getSecurityLevel, (Object)secretLevel)).set(CrmTeamMember::getState, (Object)TeamMemberStateEnum.CHECK_ING.getMemberState())).set(CrmTeamMember::getProcessKey, (Object)"bpm_tdfxsh")).set(CrmTeamMember::getFlowStatus, (Object)"2")).set(CrmTeamMember::getProcessState, (Object)RETURN_CODE));
                    CrmTeamMemberDto crmTeamMemberDto = new CrmTeamMemberDto();
                    crmTeamMemberDto.setProcessDefinitionKey("bpm_tdfxsh");
                    CrmTeamMember crmTeamMember = new CrmTeamMember();
                    crmTeamMember.setSecurityLevel(secretLevel);
                    crmTeamMemberDto.setFormdata(crmTeamMember);
                    this.formsubmit(crmTeamMemberDto, String.valueOf(oneMember.getTeamMeberId()));
                } else {
                    this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CrmTeamMember::getTeamMemberId, (Object)oneMember.getTeamMeberId())).set(CrmTeamMember::getState, (Object)TeamMemberStateEnum.CHECK_FINISH.getMemberState())).set(CrmTeamMember::getSecurityLevel, (Object)secretLevel));
                }
            });
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<String> updateForMember(TeamMeberEntity teamMeberEntity) {
        this.teamMeberService.updateModifyPowerById(teamMeberEntity);
        CrmTeamMemberDto crmTeamMemberDto = new CrmTeamMemberDto();
        crmTeamMemberDto.setProcessDefinitionKey("bpm_tdfxsh");
        BpmResponseResult bpmResponseResult = InstanceEngineService.queryProcessInstance(null, (String)String.valueOf(teamMeberEntity.getTeamMeberId()));
        String taskId = bpmResponseResult.getResult().getJSONObject(0).getJSONArray("todo").getJSONObject(0).getString("taskId");
        crmTeamMemberDto.setTaskId(taskId);
        this.formsubmit(crmTeamMemberDto, String.valueOf(teamMeberEntity.getTeamMeberId()));
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<String> deleteTeamMember(TeamMeberDto dto) {
        List teamMeberIds = dto.getTeamMeberIds();
        List crmTeamMembers = this.listByIds(teamMeberIds);
        if (CollectionUtil.isNotEmpty((Collection)crmTeamMembers)) {
            crmTeamMembers.stream().forEach(entity -> {
                if (null != entity.getProcessInstId()) {
                    BpmResponseResult bpmResponseResult = InstanceEngineService.queryProcessInstance(null, (String)String.valueOf(entity.getTeamMemberId()));
                    String taskId = bpmResponseResult.getResult().getJSONObject(0).getJSONArray("todo").getJSONObject(0).getString("taskId");
                    InstanceEngineService.deleteProcessInstanceByBusinessKey((String)String.valueOf(entity.getTeamMemberId()));
                }
            });
        }
        this.teamMeberService.updateDelFlagByIds(dto.getTeamMeberIds());
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<TransferBatchResultVo> addOpportunityTeamMebers(Map<String, Object> map) {
        ArrayList addTeamMemberList = new ArrayList();
        ApiResponse vo = this.teamMeberService.addOpportunityTeamMebers(map, addTeamMemberList);
        if (addTeamMemberList.size() > 0) {
            addTeamMemberList.stream().forEach(oneTeamMember -> {
                String chargeCompanyId;
                CrmTeamMember chargeInfo = null;
                List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmTeamMember::getBusinessId, (Object)oneTeamMember.getBusinessId())).eq(CrmTeamMember::getIsCharge, (Object)"1")).eq(CrmTeamMember::getDelFlag, (Object)RETURN_CODE));
                if (CollectionUtil.isNotEmpty((Collection)list)) {
                    chargeInfo = (CrmTeamMember)list.get(0);
                    chargeCompanyId = this.struUserAPIService.getCompanyInfoByUserId(chargeInfo.getPersonId() + "").getId() + "";
                } else {
                    chargeCompanyId = "";
                }
                SysStru companyInfo = this.struUserAPIService.getCompanyInfoByUserId(oneTeamMember.getPersonId() + "");
                String memberCompanyId = companyInfo.getId() + "";
                if (RETURN_CODE.equals(oneTeamMember.getIsCharge()) && !memberCompanyId.equals(chargeCompanyId)) {
                    CrmTeamMemberDto crmTeamMemberDto = new CrmTeamMemberDto();
                    crmTeamMemberDto.setProcessDefinitionKey("bpm_tdfxsh");
                    CrmTeamMember crmTeamMember = new CrmTeamMember();
                    crmTeamMember.setSecurityLevel(Integer.valueOf(oneTeamMember.getSecurityLevel()));
                    crmTeamMemberDto.setFormdata(crmTeamMember);
                    this.formsubmit(crmTeamMemberDto, String.valueOf(oneTeamMember.getTeamMeberId()));
                } else {
                    this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CrmTeamMember::getTeamMemberId, (Object)oneTeamMember.getTeamMeberId())).set(CrmTeamMember::getState, (Object)TeamMemberStateEnum.CHECK_FINISH.getMemberState()));
                }
            });
        }
        return vo;
    }

    private void copyBeanData(TeamMeberEntity targetEntity, CrmTeamMember teamMember) {
        targetEntity.setTeamMeberId(teamMember.getTeamMemberId());
        targetEntity.setBusinessId(teamMember.getBusinessId());
        targetEntity.setBusinessType(teamMember.getBusinessType());
        targetEntity.setPersonId(teamMember.getPersonId());
        targetEntity.setState(teamMember.getState());
        targetEntity.setModifyPower(teamMember.getModifyPower());
        targetEntity.setMemberRole(teamMember.getMemberRole());
    }
}

