/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.contract.crmagreementchange.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.crm.common.api.organUser.IStruUserAPIService;
import com.jxdinfo.crm.transaction.constants.ContractChangeStatusEnum;
import com.jxdinfo.crm.transaction.constants.ContractChangeStepEnum;
import com.jxdinfo.crm.transaction.contract.crmagreement.model.CrmAgreement;
import com.jxdinfo.crm.transaction.contract.crmagreement.service.CrmAgreementService;
import com.jxdinfo.crm.transaction.contract.crmagreementchange.dao.CrmAgreementChangeMapper;
import com.jxdinfo.crm.transaction.contract.crmagreementchange.dao.CrmAgreementChangeTaskMapper;
import com.jxdinfo.crm.transaction.contract.crmagreementchange.dto.CrmAgreementChangeTaskDto;
import com.jxdinfo.crm.transaction.contract.crmagreementchange.model.CrmAgreementChangeTask;
import com.jxdinfo.crm.transaction.contract.crmagreementchange.service.CrmAgreementChangeService;
import com.jxdinfo.crm.transaction.contract.crmagreementchange.service.CrmAgreementChangeTaskService;
import com.jxdinfo.crm.transaction.utils.BeanFieldValueChangeUtil;
import com.jxdinfo.crm.transaction.utils.ChangeContentBean;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contract.crmagreementchange.CrmAgreementChangeTaskServiceImpl")
@HussarTokenDs
public class CrmAgreementChangeTaskServiceImpl
extends HussarServiceImpl<CrmAgreementChangeTaskMapper, CrmAgreementChangeTask>
implements CrmAgreementChangeTaskService {
    private static final Logger logger = LoggerFactory.getLogger(CrmAgreementChangeTaskServiceImpl.class);
    private static final String RETURN_CODE = "0";
    private static final String ORDER_RULE = "orderRule";
    private static final String DEFAULT_ORDER_RULE = "defaultOrderRule";
    private static final String ASC = ",asc;";
    private static final String DESC = ",desc;";
    @Autowired
    private CrmAgreementChangeMapper crmAgreementChangeMapper;
    @Resource
    private IStruUserAPIService struUserAPIService;
    @Autowired
    private CrmAgreementService crmAgreementService;
    @Autowired
    private CrmAgreementChangeService crmAgreementChangeService;

    public List<CrmAgreementChangeTask> getByMap(Map<String, Object> map) {
        return this.list((Wrapper)new LambdaQueryWrapper(BeanUtil.copy(map, CrmAgreementChangeTask.class)));
    }

    @Override
    public ApiResponse<CrmAgreementChangeTask> formQuery(String id) {
        try {
            return ApiResponse.success((Object)this.getById((Serializable)((Object)id)));
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u5355\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> flowFormSubmit(CrmAgreementChangeTaskDto crmAgreementChangeTaskDto) {
        CrmAgreementChangeTask crmAgreementChangeTask = crmAgreementChangeTaskDto.getFormdata();
        CrmAgreement crmAgreement = (CrmAgreement)this.crmAgreementService.getById(crmAgreementChangeTask.getAgreementId());
        Double totalAmountTax = crmAgreement.getTotalAmountTax();
        LocalDateTime endDatendDate = crmAgreement.getEndDate();
        try {
            if (totalAmountTax.equals(crmAgreementChangeTask.getTotalAmountTax()) && endDatendDate.equals(crmAgreementChangeTask.getEndDate())) {
                return ApiResponse.fail((String)"\u53d8\u66f4\u4fe1\u606f\u4e0e\u539f\u4fe1\u606f\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\uff01");
            }
            if (crmAgreementChangeTask.getAgreementChangeId() == null || this.getById(crmAgreementChangeTask.getAgreementChangeId()) == null) {
                crmAgreementChangeTask.setCreator(BaseSecurityUtil.getUser().getId());
                crmAgreementChangeTask.setCreateTime(LocalDateTime.now());
            }
            LocalDateTime now = LocalDateTime.now();
            SecurityUser user = BaseSecurityUtil.getUser();
            Long userId = user.getUserId();
            String userName = user.getUserName();
            Long deptId = user.getDeptId();
            String deptName = user.getDeptName();
            if (HussarUtils.isEmpty((Object)crmAgreementChangeTask.getAgreementChangeId())) {
                Integer changeVersion = this.crmAgreementChangeMapper.selectMaxVersionByAgreementId(crmAgreementChangeTask.getAgreementId());
                if (HussarUtils.isEmpty((Object)changeVersion)) {
                    changeVersion = 0;
                }
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("model", "HT");
                String agreementChangeCode = this.getSerialCode(map1);
                crmAgreementChangeTask.setCreator(userId);
                crmAgreementChangeTask.setCreatorName(userName);
                crmAgreementChangeTask.setCreateDepartment(deptId);
                crmAgreementChangeTask.setCreateDepartmentName(deptName);
                crmAgreementChangeTask.setLastEditor(userId);
                crmAgreementChangeTask.setLastEditorName(userName);
                crmAgreementChangeTask.setLastTime(now);
                crmAgreementChangeTask.setDelFlag(RETURN_CODE);
                crmAgreementChangeTask.setChangeVersion(changeVersion + 1);
                crmAgreementChangeTask.setAgreementChangeCode(agreementChangeCode);
                SysStru companyInfo = this.struUserAPIService.getCompanyInfoByCurrentDeptId(BaseSecurityUtil.getUser().getDeptId().toString());
                crmAgreementChangeTask.setCreateUnit(companyInfo.getId());
                crmAgreementChangeTask.setCreateUnitName(companyInfo.getOrganAlias());
                if (totalAmountTax.equals(crmAgreementChangeTask.getTotalAmountTax()) && endDatendDate.equals(crmAgreementChangeTask.getEndDate())) {
                    crmAgreementChangeTask.setChangeStatus("2");
                    crmAgreementChangeTask.setFlowStatus(ContractChangeStatusEnum.CONTRACTCHANGE_STATUS_CHECK_FINISHED.getContractStatus());
                } else {
                    crmAgreementChangeTask.setChangeStatus("1");
                    crmAgreementChangeTask.setFlowStatus(ContractChangeStatusEnum.CONTRACTCHANGE_STATUS_CHECK_ING.getContractStatus());
                    crmAgreementChangeTask.setProcessState("1");
                    crmAgreementChangeTask.setProcesskey("bpm_htbg_change");
                    crmAgreementChangeTask.setProcessNode(ContractChangeStepEnum.CONTRACT_STEP_DEPT_CHECK.getContractStep());
                    crmAgreementChangeTask.setProcessStartTime(LocalDateTime.now());
                    crmAgreementChangeTask.setInitiator(userId);
                    this.crmAgreementService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(CrmAgreement::getChangeStatus, (Object)"1")).eq(CrmAgreement::getAgreementId, (Object)crmAgreementChangeTask.getAgreementId()));
                }
            } else {
                crmAgreementChangeTask.setLastEditor(userId);
                crmAgreementChangeTask.setLastEditorName(userName);
                crmAgreementChangeTask.setLastTime(now);
                if (totalAmountTax.equals(crmAgreementChangeTask.getTotalAmountTax()) && endDatendDate.equals(crmAgreementChangeTask.getEndDate())) {
                    crmAgreementChangeTask.setFlowStatus(ContractChangeStatusEnum.CONTRACTCHANGE_STATUS_CHECK_FINISHED.getContractStatus());
                } else {
                    crmAgreementChangeTask.setFlowStatus(ContractChangeStatusEnum.CONTRACTCHANGE_STATUS_CHECK_ING.getContractStatus());
                    crmAgreementChangeTask.setProcessState("1");
                    crmAgreementChangeTask.setProcesskey("bpm_htbg_change");
                    crmAgreementChangeTask.setProcessStartTime(LocalDateTime.now());
                    if (ContractChangeStepEnum.CONTRACT_STEP_APPLY.getContractStep().equals(crmAgreementChangeTask.getProcessNode())) {
                        BpmResponseResult bpmResponseResult = InstanceEngineService.queryProcessInstance(null, (String)String.valueOf(crmAgreementChangeTask.getAgreementChangeId()));
                        String taskId = bpmResponseResult.getResult().getJSONObject(0).getJSONArray("todo").getJSONObject(0).getString("taskId");
                        crmAgreementChangeTaskDto.setTaskId(taskId);
                        crmAgreementChangeTaskDto.setProcessDefinitionKey("bpm_htbg_change");
                        crmAgreementChangeTask.setProcessNode(ContractChangeStepEnum.CONTRACT_STEP_DEPT_CHECK.getContractStep());
                        crmAgreementChangeTask.setFlowStatus(ContractChangeStatusEnum.CONTRACTCHANGE_STATUS_CHECK_ING.getContractStatus());
                    } else if (ContractChangeStepEnum.CONTRACT_STEP_DEPT_CHECK.getContractStep().equals(crmAgreementChangeTask.getProcessNode())) {
                        crmAgreementChangeTask.setProcessNode(ContractChangeStepEnum.CONTRACT_STEP_SLD_CHECK.getContractStep());
                    } else if (ContractChangeStepEnum.CONTRACT_STEP_SLD_CHECK.getContractStep().equals(crmAgreementChangeTask.getProcessNode())) {
                        crmAgreementChangeTask.setProcessNode(ContractChangeStepEnum.CONTRACT_STEP_JGC_CHECK.getContractStep());
                    } else if (ContractChangeStepEnum.CONTRACT_STEP_JGC_CHECK.getContractStep().equals(crmAgreementChangeTask.getProcessNode())) {
                        crmAgreementChangeTask.setProcessNode(ContractChangeStepEnum.CONTRACT_STEP_JGCLD_CHECK.getContractStep());
                    } else if (ContractChangeStepEnum.CONTRACT_STEP_JGCLD_CHECK.getContractStep().equals(crmAgreementChangeTask.getProcessNode())) {
                        crmAgreementChangeTask.setProcessNode(ContractChangeStepEnum.CONTRACT_STEP_DEPT_CHECK.getContractStep());
                        crmAgreementChangeTask.setFlowStatus(ContractChangeStatusEnum.CONTRACTCHANGE_STATUS_CHECK_FINISHED.getContractStatus());
                        crmAgreementChangeTask.setChangeStatus("2");
                        CrmAgreement crmAgreementCopy = this.copyBean(crmAgreementChangeTask, crmAgreement);
                        this.crmAgreementService.updateById(crmAgreementCopy);
                    }
                }
            }
            boolean resultFlag = this.saveOrUpdate(crmAgreementChangeTask);
            if (!resultFlag) {
                return ApiResponse.fail((String)"NOPERMISSION");
            }
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
        String msg = "\u53d8\u66f4\u4fe1\u606f\u63d0\u4ea4\u6d41\u7a0b\u6210\u529f";
        if (totalAmountTax.equals(crmAgreementChangeTask.getTotalAmountTax()) && endDatendDate.equals(crmAgreementChangeTask.getEndDate())) {
            msg = "\u53d8\u66f4\u4fe1\u606f\u63d0\u4ea4\u6210\u529f";
            CrmAgreement crmAgreementCopy = this.copyBean(crmAgreementChangeTask, crmAgreement);
            this.crmAgreementService.updateById(crmAgreementCopy);
        } else {
            this.formsubmit(crmAgreementChangeTaskDto, String.valueOf(crmAgreementChangeTask.getAgreementChangeId()));
        }
        return ApiResponse.success((Object)String.valueOf(crmAgreementChangeTask.getAgreementChangeId()), (String)msg);
    }

    @Override
    @HussarTransactional
    @HussarTokenDs
    public void formsubmit(CrmAgreementChangeTaskDto crmAgreementChangeTaskDto, String businessKey) {
        BpmResponseResult bpmResponseResult;
        if (HussarUtils.isEmpty((Object)BaseSecurityUtil.getUser())) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        HashMap<String, String> appointMap = new HashMap<String, String>();
        HashMap<String, Object> variable = new HashMap<String, Object>();
        String taskId = crmAgreementChangeTaskDto.getTaskId();
        String comment = crmAgreementChangeTaskDto.getComment();
        if (crmAgreementChangeTaskDto.getFlowSelect() == null) {
            appointMap.put("static_appoint_assignee", crmAgreementChangeTaskDto.getParticipantSelect());
        } else {
            appointMap.put(crmAgreementChangeTaskDto.getFlowSelect(), crmAgreementChangeTaskDto.getParticipantSelect());
            variable.put("bpm_next_node", crmAgreementChangeTaskDto.getFlowSelect());
        }
        if (crmAgreementChangeTaskDto.getFormdata() != null && HussarUtils.isNotEmpty((Object)crmAgreementChangeTaskDto.getFormdata().getSecurityLevel())) {
            variable.put("security_level", crmAgreementChangeTaskDto.getFormdata().getSecurityLevel());
        }
        if (crmAgreementChangeTaskDto.getSelectBranches() != null) {
            ArrayList<String> nextNodeIds = new ArrayList<String>();
            HashMap<String, String> multiTypeMap = new HashMap<String, String>();
            for (Map<String, String> map : crmAgreementChangeTaskDto.getSelectBranches()) {
                appointMap.put(map.get("flowSelect"), map.get("participants"));
                if (HussarUtils.isNotEmpty((Object)map.get("multiNodeType"))) {
                    multiTypeMap.put(map.get("flowSelect"), map.get("multiNodeType"));
                }
                nextNodeIds.add(map.get("flowSelect"));
            }
            if (HussarUtils.isNotEmpty(multiTypeMap)) {
                variable.put("multi_node_type", multiTypeMap);
            }
            variable.put("bpm_next_node", String.join((CharSequence)",", nextNodeIds));
        }
        String processDefinitionKey = crmAgreementChangeTaskDto.getProcessDefinitionKey();
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        if (HussarUtils.isEmpty((Object)taskId)) {
            String deptId = BaseSecurityUtil.getUser().getDeptId() == null ? "" : String.valueOf(BaseSecurityUtil.getUser().getDeptId());
            BpmResponseResult startResult = InstanceEngineService.startProcessInstanceByKey((String)processDefinitionKey, (String)userId, (String)deptId, (String)businessKey, variable);
            if ("1".equals(startResult.getCode())) {
                taskId = (String)startResult.getResult().getJSONObject(0).get((Object)"taskId");
            } else {
                throw new HussarException(startResult.getMsg());
            }
        }
        if (!"1".equals((bpmResponseResult = TaskEngineService.completeTask((String)taskId, (String)userId, appointMap, null, (String)comment, variable)).getCode())) {
            throw new HussarException(bpmResponseResult.getMsg());
        }
        CrmAgreementChangeTask byId = (CrmAgreementChangeTask)this.getById((Serializable)((Object)businessKey));
        if (!"\u7ed3\u675f".equals(bpmResponseResult.getResult().getJSONObject(0).get((Object)"taskDefinitionName"))) {
            taskId = (String)bpmResponseResult.getResult().getJSONObject(0).get((Object)"taskId");
            byId.setProcessInstId(Long.valueOf(taskId));
        } else {
            byId.setProcessNode(ContractChangeStepEnum.CONTRACT_STEP_FINISH.getContractStep());
            byId.setFlowStatus(ContractChangeStatusEnum.CONTRACTCHANGE_STATUS_CHECK_FINISHED.getContractStatus());
        }
        this.saveOrUpdate(byId);
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> prevNodeReject(CrmAgreementChangeTaskDto crmAgreementChangeTaskDto) {
        try {
            boolean resultFlag;
            String comment;
            CrmAgreementChangeTask crmAgreementChangeTask = crmAgreementChangeTaskDto.getFormdata();
            String taskId = crmAgreementChangeTaskDto.getTaskId() == null ? "" : crmAgreementChangeTaskDto.getTaskId();
            String string = comment = crmAgreementChangeTaskDto.getComment() == null ? "" : crmAgreementChangeTaskDto.getComment();
            if (crmAgreementChangeTask.getAgreementChangeId() == null || this.getById(crmAgreementChangeTask.getAgreementChangeId()) == null) {
                crmAgreementChangeTask.setCreator(BaseSecurityUtil.getUser().getId());
                crmAgreementChangeTask.setCreateTime(LocalDateTime.now());
            }
            if (ContractChangeStepEnum.CONTRACT_STEP_JGCLD_CHECK.getContractStep().equals(crmAgreementChangeTask.getProcessNode())) {
                crmAgreementChangeTask.setProcessNode(ContractChangeStepEnum.CONTRACT_STEP_APPLY.getContractStep());
                crmAgreementChangeTask.setFlowStatus(ContractChangeStatusEnum.CONTRACTCHANGE_STATUS_REJECT_SUBMIT.getContractStatus());
            }
            if (!(resultFlag = this.saveOrUpdate(crmAgreementChangeTask))) {
                return ApiResponse.fail((String)"NOPERMISSION");
            }
            ApiResponse<String> stringApiResponse = this.startAnyNodeRejectInstance(taskId, comment);
            taskId = stringApiResponse.getMsg();
            crmAgreementChangeTask.setProcessInstId(Long.valueOf(taskId));
            this.updateById(crmAgreementChangeTask);
            return ApiResponse.success((String)"");
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    @HussarTokenDs
    public ApiResponse<String> startAnyNodeRejectInstance(String taskId, String comment) {
        if (HussarUtils.isEmpty((Object)BaseSecurityUtil.getUser())) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        try {
            BpmResponseResult bpmResponseResult = TaskEngineService.rejectToLastTask((String)taskId, (String)userId, (String)comment, null, (boolean)true, null);
            if ("1".equals(bpmResponseResult.getCode())) {
                return ApiResponse.success((String)((String)bpmResponseResult.getResult().getJSONObject(0).get((Object)"taskId")));
            }
            throw new HussarException(bpmResponseResult.getMsg());
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSerialCode(Map<String, String> map) {
        String serialCode = "";
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        try {
            Date dt = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(map.get("model"));
            stringBuffer.append("-");
            stringBuffer.append(simpleDateFormat.format(dt));
            serialCode = String.valueOf(stringBuffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            lock.unlock();
        }
        return serialCode;
    }

    @Override
    public CrmAgreement copyBean(CrmAgreementChangeTask crmAgreementChange, CrmAgreement crmAgreement) {
        crmAgreement.setEndDate(crmAgreementChange.getEndDate());
        crmAgreement.setTotalAmountTax(crmAgreementChange.getTotalAmountTax());
        crmAgreement.setChangeStatus("2");
        return crmAgreement;
    }

    @Override
    @HussarTransactional
    public Boolean deleteData(String id) {
        if (CollectionUtil.isEmpty((Object)id)) {
            throw new HussarException("\u53c2\u6570\u7f3a\u5931");
        }
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CrmAgreementChangeTask::getAgreementChangeId, (Object)id)).set(CrmAgreementChangeTask::getDelFlag, (Object)"1"));
        return true;
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> insertOrUpdate(CrmAgreementChangeTask crmAgreementChangeTask) {
        try {
            LocalDateTime now = LocalDateTime.now();
            SecurityUser user = BaseSecurityUtil.getUser();
            Long userId = user.getUserId();
            String userName = user.getUserName();
            Long deptId = user.getDeptId();
            String deptName = user.getDeptName();
            if (HussarUtils.isEmpty((Object)crmAgreementChangeTask.getAgreementChangeId())) {
                CrmAgreement crmAgreement = (CrmAgreement)this.crmAgreementService.getById(crmAgreementChangeTask.getAgreementId());
                Double totalAmountTax = crmAgreement.getTotalAmountTax();
                LocalDateTime endDatendDate = crmAgreement.getEndDate();
                if (totalAmountTax.equals(crmAgreementChangeTask.getTotalAmountTax()) && endDatendDate.equals(crmAgreementChangeTask.getEndDate())) {
                    return ApiResponse.fail((String)"\u53d8\u66f4\u4fe1\u606f\u4e0e\u539f\u4fe1\u606f\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\uff01");
                }
                Integer changeVersion = this.crmAgreementChangeMapper.selectMaxVersionByAgreementId(crmAgreementChangeTask.getAgreementId());
                if (HussarUtils.isEmpty((Object)changeVersion)) {
                    changeVersion = 0;
                }
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("model", "HT");
                String agreementChangeCode = this.getSerialCode(map1);
                crmAgreementChangeTask.setCreator(userId);
                crmAgreementChangeTask.setCreatorName(userName);
                crmAgreementChangeTask.setCreateDepartment(deptId);
                crmAgreementChangeTask.setCreateDepartmentName(deptName);
                crmAgreementChangeTask.setLastEditor(userId);
                crmAgreementChangeTask.setLastEditorName(userName);
                crmAgreementChangeTask.setLastTime(now);
                crmAgreementChangeTask.setFlowStatus(ContractChangeStatusEnum.CONTRACTCHANGE_STATUS_DRAFT.getContractStatus());
                crmAgreementChangeTask.setDelFlag(RETURN_CODE);
                crmAgreementChangeTask.setChangeVersion(changeVersion + 1);
                crmAgreementChangeTask.setChangeStatus("1");
                crmAgreementChangeTask.setAgreementChangeCode(agreementChangeCode);
                SysStru companyInfo = this.struUserAPIService.getCompanyInfoByCurrentDeptId(BaseSecurityUtil.getUser().getDeptId().toString());
                crmAgreementChangeTask.setCreateUnit(companyInfo.getId());
                crmAgreementChangeTask.setCreateUnitName(companyInfo.getOrganAlias());
                this.crmAgreementService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(CrmAgreement::getChangeStatus, (Object)"1")).eq(CrmAgreement::getAgreementId, (Object)crmAgreementChangeTask.getAgreementId()));
            } else {
                crmAgreementChangeTask.setLastEditor(userId);
                crmAgreementChangeTask.setLastEditorName(userName);
                crmAgreementChangeTask.setLastTime(now);
            }
            this.saveOrUpdate(crmAgreementChangeTask);
            return ApiResponse.success((Object)String.valueOf(crmAgreementChangeTask.getAgreementChangeId()), (String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public ApiResponse<?> basicChangeContentList(Long agreementChangeId) {
        CrmAgreementChangeTask crmAgreementChangeNew = (CrmAgreementChangeTask)this.getById(agreementChangeId);
        if (HussarUtils.isNotEmpty((Object)crmAgreementChangeNew)) {
            Long agreementId = crmAgreementChangeNew.getAgreementId();
            int changeVersion = crmAgreementChangeNew.getChangeVersion() - 1;
            CrmAgreementChangeTask crmAgreementChangeOld = (CrmAgreementChangeTask)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmAgreementChangeTask::getAgreementId, (Object)agreementId)).eq(CrmAgreementChangeTask::getChangeVersion, (Object)changeVersion)).eq(CrmAgreementChangeTask::getDelFlag, (Object)RETURN_CODE));
            if (HussarUtils.isNotEmpty((Object)crmAgreementChangeOld)) {
                List<ChangeContentBean> changeContentBeanList = BeanFieldValueChangeUtil.getChangedFields("\u57fa\u672c\u4fe1\u606f", crmAgreementChangeOld, crmAgreementChangeNew);
                return ApiResponse.success(changeContentBeanList);
            }
        }
        return ApiResponse.success();
    }
}

