/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.salesKPI.message.service.impl;

import com.jxdinfo.crm.salesKPI.constants.MsgConstants;
import com.jxdinfo.crm.salesKPI.message.Dto.RuleCompletionMsgDto;
import com.jxdinfo.crm.salesKPI.message.service.BaseMsgService;
import com.jxdinfo.crm.salesKPI.message.service.IMsgService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ProgressAccomplish
extends BaseMsgService
implements IMsgService {
    @Override
    public void sendMsg(List<Map<String, Object>> list) {
        if (list.isEmpty()) {
            return;
        }
        List<RuleCompletionMsgDto> ruleCompletionMsgDtoList = list.stream().map(map -> (RuleCompletionMsgDto)BeanUtil.mapToBean((Map)map, RuleCompletionMsgDto.class, (boolean)true)).collect(Collectors.toList());
        ruleCompletionMsgDtoList.forEach(msgProgressDto -> {
            String checkObject = msgProgressDto.getCheckObject();
            if (MsgConstants.CheckObject.DEPT.getCode().toString().equals(checkObject)) {
                this.sendDeptGoalProgressMsg((RuleCompletionMsgDto)msgProgressDto);
            } else if (MsgConstants.CheckObject.PERSON.getCode().toString().equals(checkObject)) {
                this.sendPersonGoalProgressMsg((RuleCompletionMsgDto)msgProgressDto);
            }
        });
    }

    private void sendDeptGoalProgressMsg(RuleCompletionMsgDto ruleCompletionMsgDto) {
        String cycleName = ruleCompletionMsgDto.getCycleName();
        String total = ruleCompletionMsgDto.getTotal().toString();
        String finish = ruleCompletionMsgDto.getFinish().toString();
        String unFinish = ruleCompletionMsgDto.getUnFinish().toString();
        String deptName = ruleCompletionMsgDto.getObjectName();
        ArrayList<Long> deptIdList = new ArrayList<Long>();
        Long deptId = ruleCompletionMsgDto.getObjectId();
        deptIdList.add(deptId);
        Map chargePersonList = this.dataRightBoService.getChargePersonList(deptIdList);
        if (null == chargePersonList || chargePersonList.isEmpty()) {
            return;
        }
        List securityUsers = (List)chargePersonList.get(deptId);
        if (null == securityUsers || securityUsers.isEmpty()) {
            return;
        }
        List<String> sendMsgUserIds = securityUsers.stream().map(UserDetails::getUserId).map(String::valueOf).collect(Collectors.toList());
        if (sendMsgUserIds.isEmpty()) {
            return;
        }
        String title = "\u3010\u9500\u552e\u76ee\u6807\u63d0\u9192\u3011";
        String content = "\u60a8\u8d1f\u8d23\u7684\u3010" + deptName + "\u3011\u3010" + cycleName + "\u3011\u6709" + total + "\u4e2a\u9500\u552e\u76ee\u6807,\u5f53\u524d" + finish + "\u4e2a\u5df2\u5b8c\u6210," + unFinish + "\u4e2a\u672a\u5b8c\u6210,\u8bf7\u77e5\u6089\u3002";
        this.sendNoteMsg(title, content, "#/crm/salesTarget/index", sendMsgUserIds, LocalDateTime.now());
        String mobileTitle = "\u9500\u552e\u76ee\u6807\u8fdb\u5ea6\u63d0\u9192";
        String mobileContent = "\u60a8\u8d1f\u8d23\u7684\u3010" + deptName + "\u3011\u3010" + cycleName + "\u3011\u6709" + total + "\u4e2a\u9500\u552e\u76ee\u6807,\u5f53\u524d" + finish + "\u4e2a\u5df2\u5b8c\u6210," + unFinish + "\u4e2a\u672a\u5b8c\u6210,\u8bf7\u5728CRM\u95e8\u6237\u3010CRM\u7cfb\u7edf-\u9500\u552e\u76ee\u6807-\u76ee\u6807\u5b8c\u6210\u60c5\u51b5\u3011\u4e2d\u67e5\u770b\u8be6\u60c5\u3002";
        this.sendJqxNoteMsg(mobileTitle, mobileContent, "/crm/sy/yddsy", sendMsgUserIds);
    }

    private void sendPersonGoalProgressMsg(RuleCompletionMsgDto ruleCompletionMsgDto) {
        String cycleName = ruleCompletionMsgDto.getCycleName();
        String total = ruleCompletionMsgDto.getTotal().toString();
        String finish = ruleCompletionMsgDto.getFinish().toString();
        String unFinish = ruleCompletionMsgDto.getUnFinish().toString();
        ArrayList<String> sendMsgUserIds = new ArrayList<String>();
        Long userId = ruleCompletionMsgDto.getObjectId();
        sendMsgUserIds.add(userId.toString());
        String title = "\u3010\u9500\u552e\u76ee\u6807\u63d0\u9192\u3011";
        String content = "\u60a8\u3010" + cycleName + "\u3011\u6709" + total + "\u4e2a\u9500\u552e\u76ee\u6807,\u5f53\u524d" + finish + "\u4e2a\u5df2\u5b8c\u6210," + unFinish + "\u4e2a\u672a\u5b8c\u6210,\u8bf7\u77e5\u6089\u3002";
        this.sendNoteMsg(title, content, "#/crm/salesTarget/index", sendMsgUserIds, LocalDateTime.now());
        String mobileTitle = "\u9500\u552e\u76ee\u6807\u8fdb\u5ea6\u63d0\u9192";
        String mobileContent = "\u60a8\u3010" + cycleName + "\u3011\u6709" + total + "\u4e2a\u9500\u552e\u76ee\u6807,\u5f53\u524d" + finish + "\u4e2a\u5df2\u5b8c\u6210," + unFinish + "\u4e2a\u672a\u5b8c\u6210,\u8bf7\u5728CRM\u95e8\u6237\u3010CRM\u7cfb\u7edf-\u9500\u552e\u76ee\u6807-\u76ee\u6807\u5b8c\u6210\u60c5\u51b5\u3011\u4e2d\u67e5\u770b\u8be6\u60c5\u3002";
        this.sendJqxNoteMsg(mobileTitle, mobileContent, "/crm/sy/yddsy", sendMsgUserIds);
    }
}

