/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.salesKPI.message.service.impl;

import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.jxdinfo.crm.salesKPI.constants.CycleConstants;
import com.jxdinfo.crm.salesKPI.constants.MsgConstants;
import com.jxdinfo.crm.salesKPI.message.service.BaseMsgService;
import com.jxdinfo.crm.salesKPI.message.service.IMsgService;
import com.jxdinfo.crm.salesKPI.rule.model.Rule;
import com.jxdinfo.crm.salesKPI.scope.model.ScopeValue;
import com.jxdinfo.crm.salesKPI.scope.vo.ScopeFinishValueVo;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class CurrentAccomplish
extends BaseMsgService
implements IMsgService {
    @Override
    public void sendMsg(List<Map<String, Object>> lsit) {
        if (lsit.isEmpty()) {
            return;
        }
        List<ScopeFinishValueVo> finishValueVos = lsit.stream().map(map -> (ScopeFinishValueVo)BeanUtil.mapToBean((Map)map, ScopeFinishValueVo.class, (boolean)true)).collect(Collectors.toList());
        finishValueVos.forEach(finishValueVo -> {
            String cycle;
            Long ruleId = finishValueVo.getRuleId();
            Rule rule = (Rule)((Object)((Object)this.ruleService.getById(ruleId)));
            String checkObject = rule.getCheckObject();
            String ruleName = rule.getRuleName();
            String checkCycle = rule.getCheckCycle();
            int nowScopeSort = this.scopeService.getNowScopeSort(ruleId);
            int checkCycleCode = Integer.parseInt(checkCycle);
            switch (checkCycleCode) {
                case 1: {
                    cycle = rule.getAnalyseYear() + "\u5e74";
                    break;
                }
                case 2: {
                    cycle = CycleConstants.HalfYear.getNameByCode(nowScopeSort);
                    break;
                }
                case 3: {
                    cycle = CycleConstants.Quarter.getNameByCode(nowScopeSort);
                    break;
                }
                case 4: {
                    cycle = CycleConstants.MonthCycle.getNameByCode(nowScopeSort);
                    break;
                }
                default: {
                    cycle = "\u5f53\u524d\u5468\u671f";
                }
            }
            if (MsgConstants.CheckObject.DEPT.getCode().toString().equals(checkObject)) {
                this.sendDeptGoalAccomplishMsg(ruleName, (ScopeFinishValueVo)finishValueVo, cycle);
            } else if (MsgConstants.CheckObject.PERSON.getCode().toString().equals(checkObject)) {
                this.sendPersonGoalAccomplishMsg(ruleName, (ScopeFinishValueVo)finishValueVo, cycle);
            }
        });
        List scopeValueIds = finishValueVos.stream().map(vo -> (Long)vo.getValueIdAndMsgFlag().get(1).get("scopeValueId")).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.scopeValueService.lambdaUpdate().set(ScopeValue::getMsgFlag, (Object)MsgConstants.MsgFlag.PUSHED.getCode().toString())).set(ScopeValue::getMsgTime, (Object)LocalDateTime.now())).in(ScopeValue::getValueId, scopeValueIds)).update();
    }

    private void sendDeptGoalAccomplishMsg(String ruleName, ScopeFinishValueVo finishValueVo, String cycle) {
        ArrayList<Long> deptIdList = new ArrayList<Long>();
        Long deptId = finishValueVo.getObjectId();
        deptIdList.add(deptId);
        String deptName = finishValueVo.getObjectName();
        Map chargePersonList = this.dataRightBoService.getChargePersonList(deptIdList);
        if (null == chargePersonList || chargePersonList.isEmpty()) {
            return;
        }
        List securityUsers = (List)chargePersonList.get(deptId);
        if (null == securityUsers || securityUsers.isEmpty()) {
            return;
        }
        List<String> sendMsgUserIds = securityUsers.stream().map(UserDetails::getUserId).map(String::valueOf).collect(Collectors.toList());
        if (sendMsgUserIds.isEmpty()) {
            return;
        }
        String title = "\u3010\u9500\u552e\u76ee\u6807\u63d0\u9192\u3011";
        String content = "\u60a8\u8d1f\u8d23\u7684\u3010" + deptName + "\u3011\u9500\u552e\u76ee\u6807\u3010" + ruleName + "\u3011\u3010" + cycle + "\u3011\u5df2\u5b8c\u6210\uff0c\u8bf7\u77e5\u6089\u3002";
        this.sendNoteMsg(title, content, "#/crm/salesTarget/index", sendMsgUserIds, LocalDateTime.now());
        String mobileTitle = "\u9500\u552e\u76ee\u6807\u3010" + ruleName + "\u3011\u5df2\u5b8c\u6210";
        String mobileContent = "\u60a8\u8d1f\u8d23\u7684\u3010" + deptName + "\u3011\u9500\u552e\u76ee\u6807\u3010" + ruleName + "\u3011\u3010" + cycle + "\u3011\u5df2\u5b8c\u6210\uff0c\u8bf7\u77e5\u6089\u3002";
        this.sendJqxNoteMsg(mobileTitle, mobileContent, "/crm/sy/yddsy", sendMsgUserIds);
    }

    private void sendPersonGoalAccomplishMsg(String ruleName, ScopeFinishValueVo finishValueVo, String cycle) {
        ArrayList<String> sendMsgUserIds = new ArrayList<String>();
        Long userId = finishValueVo.getObjectId();
        sendMsgUserIds.add(userId.toString());
        String title = "\u3010\u9500\u552e\u76ee\u6807\u63d0\u9192\u3011";
        String content = "\u60a8\u7684\u9500\u552e\u76ee\u6807\u3010" + ruleName + "\u3011\u3010" + cycle + "\u3011\u5df2\u5b8c\u6210\uff0c\u8bf7\u77e5\u6089\u3002";
        this.sendNoteMsg(title, content, "#/crm/salesTarget/index", sendMsgUserIds, LocalDateTime.now());
        String mobileTitle = "\u9500\u552e\u76ee\u6807\u3010" + ruleName + "\u3011\u5df2\u5b8c\u6210";
        String mobileContent = "\u9500\u552e\u76ee\u6807\u540d\u79f0\u3010" + ruleName + "\u3011\u3010" + cycle + "\u3011\u5df2\u5b8c\u6210\uff0c\u8bf7\u77e5\u6089\u3002";
        this.sendJqxNoteMsg(mobileTitle, mobileContent, "/crm/sy/yddsy", sendMsgUserIds);
    }
}

