/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.salesKPI.job.processor;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.jxdinfo.crm.salesKPI.constants.MsgConstants;
import com.jxdinfo.crm.salesKPI.message.factory.MsgServiceFactory;
import com.jxdinfo.crm.salesKPI.message.service.IMsgService;
import com.jxdinfo.crm.salesKPI.rule.model.Rule;
import com.jxdinfo.crm.salesKPI.rule.service.IRuleService;
import com.jxdinfo.crm.salesKPI.rule.vo.RuleVo;
import com.jxdinfo.crm.salesKPI.scope.service.IScopeService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CurrentAccomplishMsgProcessor
implements BasicProcessor {
    private final Logger logger = LoggerFactory.getLogger(CurrentAccomplishMsgProcessor.class);
    @Resource
    protected IRuleService ruleService;
    @Resource
    private IScopeService scopeService;
    @Resource
    private MsgServiceFactory msgServiceFactory;

    public ProcessResult process(TaskContext taskContext) throws Exception {
        this.logger.info("==========\u9500\u552e\u76ee\u6807-\u76ee\u524d\u5b8c\u6210\u63d0\u9192\u6d88\u606f\u63a8\u9001===========");
        List<RuleVo> ruleVoList = ((LambdaQueryChainWrapper)this.ruleService.lambdaQuery().eq(Rule::getDisableFlag, (Object)"0")).list().stream().map(rule -> (RuleVo)BeanUtil.copyProperties((Object)rule, RuleVo.class)).collect(Collectors.toList());
        List<RuleVo> nowRuleList = this.ruleService.getNowAuthRuleList(ruleVoList);
        ArrayList salesKPIScopeValueList = new ArrayList();
        nowRuleList.forEach(nowRuleVo -> {
            List temp = this.scopeService.getSalesKPIScopeValueList(nowRuleVo.getRuleId(), String.valueOf(this.scopeService.getNowScopeSort(nowRuleVo.getRuleId())), true, null, null).stream().filter(vo -> nowRuleVo.getRuleId().equals(vo.getRuleId())).filter(vo -> BigDecimal.valueOf(100.0).compareTo(BigDecimal.valueOf(vo.getValueRate().get(0).floatValue())) <= 0).filter(vo -> null == vo.getValueIdAndMsgFlag().get(1).get("msgFlag") || !MsgConstants.MsgFlag.PUSHED.getCode().toString().equals(vo.getValueIdAndMsgFlag().get(1).get("msgFlag").toString())).collect(Collectors.toList());
            salesKPIScopeValueList.addAll(temp);
        });
        IMsgService msgService = this.msgServiceFactory.getMsgService(MsgConstants.OperationType.CURRENT.getCode());
        List<Map<String, Object>> param = salesKPIScopeValueList.stream().map(BeanUtil::beanToMap).collect(Collectors.toList());
        msgService.sendMsg(param);
        return new ProcessResult(true, "\u6d88\u606f\u63a8\u9001\u4efb\u52a1\u6267\u884c\u6210\u529f");
    }
}

