/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.salesKPI.scope.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.dataRightManage.IDataRightBoService;
import com.jxdinfo.crm.core.api.customer.dto.CustomerAPIDto;
import com.jxdinfo.crm.core.api.customer.service.ICustomerAPIService;
import com.jxdinfo.crm.core.api.customer.vo.CustomerAPIVo;
import com.jxdinfo.crm.core.api.opportunity.dto.SalesKPIRuleDto;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityAPIService;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityStageVo;
import com.jxdinfo.crm.core.api.opportunity.vo.SalesKPIScopeVo;
import com.jxdinfo.crm.core.api.product.dto.ProductAPIDto;
import com.jxdinfo.crm.core.api.product.service.IProductAPIService;
import com.jxdinfo.crm.core.api.product.vo.ProductAPIVo;
import com.jxdinfo.crm.salesKPI.constants.MsgConstants;
import com.jxdinfo.crm.salesKPI.rule.model.Rule;
import com.jxdinfo.crm.salesKPI.rule.model.RuleDimension;
import com.jxdinfo.crm.salesKPI.rule.model.RulePermission;
import com.jxdinfo.crm.salesKPI.rule.model.RuleSort;
import com.jxdinfo.crm.salesKPI.rule.service.IRuleDimensionService;
import com.jxdinfo.crm.salesKPI.rule.service.IRulePermissionService;
import com.jxdinfo.crm.salesKPI.rule.service.IRuleService;
import com.jxdinfo.crm.salesKPI.rule.service.IRuleSortService;
import com.jxdinfo.crm.salesKPI.rule.vo.RuleVo;
import com.jxdinfo.crm.salesKPI.scope.dao.ScopeMapper;
import com.jxdinfo.crm.salesKPI.scope.model.Scope;
import com.jxdinfo.crm.salesKPI.scope.model.ScopeValue;
import com.jxdinfo.crm.salesKPI.scope.service.IScopeService;
import com.jxdinfo.crm.salesKPI.scope.service.IScopeValueService;
import com.jxdinfo.crm.salesKPI.scope.vo.ScopeFinishValueVo;
import com.jxdinfo.crm.salesKPI.scope.vo.ScopeRateVo;
import com.jxdinfo.crm.salesKPI.scope.vo.ScopeValueVo;
import com.jxdinfo.crm.salesKPI.scope.vo.ScopeVo;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ScopeServiceImpl
extends HussarServiceImpl<ScopeMapper, Scope>
implements IScopeService {
    @Resource
    private IScopeValueService scopeValueService;
    @Resource
    private IRuleService ruleService;
    @Resource
    private IRuleDimensionService ruleDimensionService;
    @Resource
    private IRulePermissionService rulePermissionService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private IProductAPIService productAPIService;
    @Resource
    private ICustomerAPIService customerAPIService;
    @Resource
    private IOpportunityAPIService opportunityAPIService;
    @Resource
    private ISysDicRefService dicRefService;
    @Resource
    private IDataRightBoService dataRightBoService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private IRuleSortService ruleSortService;

    @Override
    public Page<ScopeVo> getSalesKPIScopeList(PageInfo pageInfo, Long ruleId) {
        Page page = (Page)BeanUtil.copy((Object)pageInfo, Page.class);
        List<ScopeVo> scopeList = ((ScopeMapper)this.baseMapper).getSalesKPIScopeList((Page<ScopeVo>)page, ruleId);
        scopeList.stream().peek(o -> {
            List<ScopeValueVo> valueList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.scopeValueService.lambdaQuery().eq(ScopeValue::getScopeId, (Object)o.getScopeId())).orderByAsc(ScopeValue::getSortOrder)).list().stream().map(scopeValue -> (ScopeValueVo)BeanUtil.copy((Object)scopeValue, ScopeValueVo.class)).collect(Collectors.toList());
            o.setScopeValueList(valueList);
        }).collect(Collectors.toList());
        page.setRecords(scopeList);
        return page;
    }

    @Override
    public List<ScopeRateVo> getSalesKPIRuleListWithRate(String ruleName, String ruleType, String checkObject, PageInfo pageInfo) {
        boolean nowCycle = false;
        List<RuleVo> ruleList = this.getRuleList(ruleName, ruleType, checkObject, nowCycle, null, null);
        if (ToolUtil.isNotEmpty((Object)pageInfo)) {
            ruleList = ruleList.stream().skip((pageInfo.getCurrent() - 1L) * pageInfo.getSize()).limit(pageInfo.getSize()).collect(Collectors.toList());
        }
        ArrayList<ScopeRateVo> res = new ArrayList<ScopeRateVo>();
        res.addAll(this.getKpiRateForRule(ruleList));
        return res;
    }

    @Override
    public List<ScopeRateVo> getSalesKPIRuleList(String ruleName, String ruleType, String checkObject, boolean nowCycle, String pageType, Long userId) {
        List<RuleVo> ruleList = this.getRuleList(ruleName, ruleType, checkObject, nowCycle, pageType, userId);
        List<ScopeRateVo> res = ruleList.stream().map(o -> {
            ScopeRateVo scopeRateVo = (ScopeRateVo)BeanUtil.copy((Object)o, ScopeRateVo.class);
            return scopeRateVo;
        }).collect(Collectors.toList());
        return res;
    }

    private List<RuleVo> getRuleList(String ruleName, String ruleType, String checkObject, boolean nowCycle, String pageType, Long userId) {
        Boolean auth;
        List<Object> ruleList = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)pageType) && pageType.equals("2")) {
            if (ToolUtil.isEmpty((Object)userId)) {
                return null;
            }
            auth = true;
            ruleType = "2";
            checkObject = null;
        } else {
            SecurityUser user = BaseSecurityUtil.getUser();
            userId = user.getId();
            List userRoles = user.getRolesList();
            String config = this.crmBaseConfigBoService.getCrmBaseConfigByKey("target_manager_role_id").getConfigValue();
            List targetManagerRoleIds = JSONObject.parseArray((String)config, Long.class);
            auth = Collections.disjoint(userRoles, targetManagerRoleIds);
            ruleList = this.ruleService.getAuthRuleList(ruleName, auth, userId, this.getOrgIdList(user.getDeptId()), ruleType, checkObject, nowCycle);
        }
        List<Object> checkRuleList = new ArrayList();
        if (auth.booleanValue()) {
            List deptList = this.dataRightBoService.getChargeDepartmentList(userId);
            List scopeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Scope::getObjectId, (Object)userId)).or(ToolUtil.isNotEmpty((Object)deptList))).in(ToolUtil.isNotEmpty((Object)deptList), Scope::getObjectId, (Collection)deptList)).list();
            if (ToolUtil.isNotEmpty((Object)scopeList)) {
                List<Long> ruleIdList = scopeList.stream().map(Scope::getRuleId).collect(Collectors.toList());
                if ("2".equals(ruleType)) {
                    ruleList = ruleList.stream().filter(o -> ruleIdList.contains(o.getRuleId())).collect(Collectors.toList());
                }
                List<Long> existRule = ruleList.stream().map(RuleVo::getRuleId).collect(Collectors.toList());
                checkRuleList = this.ruleService.getRuleListByCheckObject(ruleName, ruleIdList, existRule, ruleType, checkObject, nowCycle);
            }
        }
        Long finalUserId = userId;
        checkRuleList = checkRuleList.stream().map(ruleVo -> {
            ruleVo.setObjectId(finalUserId);
            return ruleVo;
        }).collect(Collectors.toList());
        ruleList.addAll(checkRuleList);
        return this.sortRuleList(ruleList, userId);
    }

    private List<RuleVo> sortRuleList(List<RuleVo> ruleList, Long userId) {
        ArrayList<RuleVo> result = new ArrayList<RuleVo>();
        List<Object> unSortRules = new ArrayList();
        ArrayList<RuleVo> sortRules = new ArrayList<RuleVo>();
        List ruleSorts = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.ruleSortService.lambdaQuery().eq(RuleSort::getUserId, (Object)userId)).orderByAsc(RuleSort::getSortValue)).list();
        unSortRules = ruleList.stream().filter(item -> ruleSorts.stream().allMatch(each -> !item.getRuleId().equals(each.getRuleId()))).collect(Collectors.toList());
        unSortRules.sort(Comparator.comparing(RuleVo::getCreateTime).reversed());
        block0: for (RuleSort ruleSort : ruleSorts) {
            for (RuleVo ruleVo : ruleList) {
                if (!ruleSort.getRuleId().equals(ruleVo.getRuleId())) continue;
                sortRules.add(ruleVo);
                continue block0;
            }
        }
        result.addAll(unSortRules);
        result.addAll(sortRules);
        return result;
    }

    private List<Long> getOrgIdList(Long deptId) {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        if (ToolUtil.isNotEmpty((Object)deptId)) {
            SysStru sysStru = (SysStru)this.sysStruService.getById((Serializable)deptId);
            orgIdList.addAll(Arrays.stream(sysStru.getStruFid().split("/")).filter(ToolUtil::isNotEmpty).map(Long::parseLong).collect(Collectors.toList()));
        }
        return orgIdList;
    }

    private List<ScopeRateVo> getKpiRateForRule(List<RuleVo> checkRuleList) {
        List<ScopeRateVo> scopeRateVoList = checkRuleList.stream().map(o -> {
            Long objectId = o.getObjectId();
            ScopeRateVo scopeRateVo = (ScopeRateVo)BeanUtil.copy((Object)o, ScopeRateVo.class);
            SecurityUser user = BaseSecurityUtil.getUser();
            Long userId = user.getId();
            if (userId.equals(o.getCreator())) {
                scopeRateVo.setRuleSetAuth(true);
                scopeRateVo.setKPIRate(this.getKpiRate((RuleVo)o, null));
            } else {
                scopeRateVo.setRuleSetAuth(false);
                scopeRateVo.setKPIRate(this.getKpiRate((RuleVo)o, objectId));
            }
            return scopeRateVo;
        }).collect(Collectors.toList());
        return scopeRateVoList;
    }

    @Override
    public int getNowScopeSort(Long ruleId) {
        Rule rule = (Rule)((Object)this.ruleService.getById(ruleId));
        Calendar cal = Calendar.getInstance();
        int month = cal.get(2);
        String checkCycle = rule.getCheckCycle();
        int nowScopeSort = 1;
        if (checkCycle.equals("2")) {
            return month / 6 + 1;
        }
        if (checkCycle.equals("3")) {
            return month / 3 + 1;
        }
        if (checkCycle.equals("4")) {
            return month + 1;
        }
        return nowScopeSort;
    }

    private List<Integer> getSortOrderList(String valueSorts, Rule rule) {
        String checkCycle = rule.getCheckCycle();
        String fiscalYearMonth = rule.getFiscalYearMonth();
        List<Integer> sortOrderList = new ArrayList<Integer>();
        if (ToolUtil.isNotEmpty((Object)valueSorts)) {
            if (MsgConstants.CheckCycle.MONTH.getCode().toString().equals(checkCycle)) {
                List sortValueList = Arrays.stream(valueSorts.split(",")).map(Integer::parseInt).collect(Collectors.toList());
                for (Integer valueSort : sortValueList) {
                    sortOrderList.add(valueSort - Integer.parseInt(fiscalYearMonth) < 0 ? valueSort - Integer.parseInt(fiscalYearMonth) + 13 : valueSort - Integer.parseInt(fiscalYearMonth) + 1);
                }
                sortOrderList.sort(Integer::compareTo);
            } else {
                sortOrderList = Arrays.stream(valueSorts.split(",")).map(Integer::parseInt).sorted().collect(Collectors.toList());
            }
        }
        return sortOrderList;
    }

    @Override
    public int getLastScopeSort(Long ruleId) {
        Rule rule = (Rule)((Object)this.ruleService.getById(ruleId));
        String checkCycle = rule.getCheckCycle();
        Calendar cal = Calendar.getInstance();
        int month = cal.get(2);
        int lastScopeSort = 1;
        if (MsgConstants.CheckCycle.HALF_YEAR.getCode().toString().equals(checkCycle)) {
            return month / 6 + 1 == 1 ? 2 : 1;
        }
        if (MsgConstants.CheckCycle.QUARTER.getCode().toString().equals(checkCycle)) {
            return month / 3 + 1 == 1 ? 4 : month / 3 + 1;
        }
        if (MsgConstants.CheckCycle.MONTH.getCode().toString().equals(checkCycle)) {
            return month == 0 ? 12 : month;
        }
        return lastScopeSort;
    }

    @Override
    public List<ScopeFinishValueVo> getSalesKPIScopeValueList(Long ruleId, String valueSorts, boolean admin, String pageType, Long userId) {
        List scopeList;
        Rule rule = (Rule)((Object)this.ruleService.getById(ruleId));
        ArrayList<ScopeFinishValueVo> res = new ArrayList<ScopeFinishValueVo>();
        Boolean checkObject = false;
        if (!admin) {
            if (ToolUtil.isNotEmpty((Object)pageType) && pageType.equals("2")) {
                if (ToolUtil.isEmpty((Object)userId)) {
                    return new ArrayList<ScopeFinishValueVo>();
                }
                checkObject = true;
            } else {
                SecurityUser user = BaseSecurityUtil.getUser();
                List roles = user.getRolesList();
                userId = user.getId();
                List<Long> orgIdList = this.getOrgIdList(user.getDeptId());
                Long finalUserId = userId;
                List rulePermissionList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.rulePermissionService.lambdaQuery().eq(RulePermission::getRuleId, (Object)ruleId)).and(o -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)o.in(RulePermission::getPermissionId, (Collection)orgIdList)).or()).eq(RulePermission::getPermissionId, (Object)finalUserId);
                })).list();
                String config = this.crmBaseConfigBoService.getCrmBaseConfigByKey("target_manager_role_id").getConfigValue();
                List targetManagerRoleIds = JSONObject.parseArray((String)config, Long.class);
                if (Collections.disjoint(roles, targetManagerRoleIds) && !userId.equals(rule.getCreator()) && rulePermissionList.size() == 0) {
                    checkObject = true;
                }
            }
            if (checkObject.booleanValue()) {
                List deptList = this.dataRightBoService.getChargeDepartmentList(userId);
                Long finalUserId = userId;
                scopeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Scope::getRuleId, (Object)ruleId)).and(p -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)p.eq(Scope::getObjectId, (Object)finalUserId)).or()).in(ToolUtil.isNotEmpty((Object)deptList), Scope::getObjectId, (Collection)deptList);
                })).list();
            } else {
                scopeList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(Scope::getRuleId, (Object)ruleId)).list();
            }
        } else {
            scopeList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(Scope::getRuleId, (Object)ruleId)).list();
        }
        if (ToolUtil.isEmpty((Object)scopeList)) {
            return new ArrayList<ScopeFinishValueVo>();
        }
        List scopeIdList = scopeList.stream().map(Scope::getScopeId).collect(Collectors.toList());
        List<Object> sortList = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)valueSorts)) {
            sortList = this.getSortOrderList(valueSorts, rule);
        }
        List scopeValueList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.scopeValueService.lambdaQuery().in(ScopeValue::getScopeId, scopeIdList)).in(ToolUtil.isNotEmpty(sortList), ScopeValue::getSortOrder, sortList)).list();
        SalesKPIRuleDto salesKPIRuleDto = this.getSalesKPIRuleDto(rule, scopeList);
        List<SalesKPIScopeVo> salesKPIScopeVoList = this.getKPI(salesKPIRuleDto);
        try {
            if (ToolUtil.isNotEmpty(sortList)) {
                for (SalesKPIScopeVo salesKPIScopeVo : salesKPIScopeVoList) {
                    ArrayList scoreList = new ArrayList();
                    List kpiScore = salesKPIScopeVo.getKPIScore();
                    for (Integer n : sortList) {
                        scoreList.add(kpiScore.get(n - 1));
                    }
                    salesKPIScopeVo.setKPIScore(scoreList);
                }
            }
        }
        catch (Exception e) {
            throw new BaseException("\u5b8c\u6210\u503c\u83b7\u53d6\u5f02\u5e38");
        }
        for (Scope scope : scopeList) {
            ScopeFinishValueVo scopeFinishValueVo = new ScopeFinishValueVo();
            scopeFinishValueVo.setRuleId(ruleId);
            scopeFinishValueVo.setCheckObject(rule.getCheckObject());
            scopeFinishValueVo.setScopeId(scope.getScopeId());
            scopeFinishValueVo.setObjectId(scope.getObjectId());
            scopeFinishValueVo.setObjectName(scope.getObjectName());
            ArrayList<Map<String, Object>> valueIdAndMsgFlag = new ArrayList<Map<String, Object>>();
            ArrayList<BigDecimal> kpiValue = new ArrayList<BigDecimal>();
            ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>();
            ArrayList<Float> valueRate = new ArrayList<Float>();
            valueIdAndMsgFlag.add(null);
            kpiValue.add(BigDecimal.ZERO);
            arrayList.add(BigDecimal.ZERO);
            valueRate.add(Float.valueOf(0.0f));
            List scopeValueIds = scopeValueList.stream().filter(o -> scope.getScopeId().equals(o.getScopeId())).sorted(Comparator.comparing(ScopeValue::getSortOrder)).map(ScopeValue2 -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("scopeValueId", ScopeValue2.getValueId());
                map.put("msgFlag", ScopeValue2.getMsgFlag());
                return map;
            }).collect(Collectors.toList());
            valueIdAndMsgFlag.addAll(scopeValueIds);
            List ScopeValueSorted = scopeValueList.stream().filter(o -> scope.getScopeId().equals(o.getScopeId())).sorted(Comparator.comparing(ScopeValue::getSortOrder)).collect(Collectors.toList());
            List kpiValues = ScopeValueSorted.stream().map(ScopeValue::getKpiValue).collect(Collectors.toCollection(LinkedList::new));
            kpiValue.addAll(kpiValues);
            List<BigDecimal> nowValues = null;
            for (SalesKPIScopeVo salesKPIScopeVo : salesKPIScopeVoList) {
                if (!salesKPIScopeVo.getObjectId().equals(scope.getObjectId())) continue;
                nowValues = salesKPIScopeVo.getKPIScore();
                break;
            }
            if (nowValues == null) {
                nowValues = new ArrayList();
                for (int i = 0; i < kpiValues.size(); ++i) {
                    nowValues.add(BigDecimal.ZERO);
                }
            }
            arrayList.addAll(nowValues);
            if (kpiValue.size() != arrayList.size()) {
                throw new BaseException("\u5b8c\u6210\u503c\u83b7\u53d6\u5f02\u5e38");
            }
            BigDecimal totalKpiValue = BigDecimal.ZERO;
            BigDecimal totalNowValue = BigDecimal.ZERO;
            for (int i = 0; i < kpiValues.size(); ++i) {
                Float rate;
                if (((BigDecimal)nowValues.get(i)).compareTo(BigDecimal.ZERO) == 0) {
                    rate = Float.valueOf(0.0f);
                } else if (((BigDecimal)kpiValues.get(i)).compareTo(BigDecimal.ZERO) == 0) {
                    rate = Float.valueOf(100.0f);
                } else {
                    BigDecimal bigDecimal = ((BigDecimal)nowValues.get(i)).multiply(BigDecimal.valueOf(100L)).divide((BigDecimal)kpiValues.get(i), 2, 4);
                    rate = Float.valueOf(bigDecimal.floatValue());
                }
                valueRate.add(rate);
                totalKpiValue = totalKpiValue.add((BigDecimal)kpiValues.get(i));
                totalNowValue = totalNowValue.add((BigDecimal)nowValues.get(i));
            }
            kpiValue.set(0, totalKpiValue);
            arrayList.set(0, totalNowValue);
            if (totalKpiValue.compareTo(BigDecimal.ZERO) != 0 && totalNowValue.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal bigDecimal = totalNowValue.multiply(BigDecimal.valueOf(100L)).divide(totalKpiValue, 2, 4);
                valueRate.set(0, Float.valueOf(bigDecimal.floatValue()));
            } else if (totalNowValue.compareTo(BigDecimal.ZERO) == 0) {
                valueRate.set(0, Float.valueOf(0.0f));
            } else if (totalKpiValue.compareTo(BigDecimal.ZERO) == 0) {
                valueRate.set(0, Float.valueOf(100.0f));
            }
            scopeFinishValueVo.setValueIdAndMsgFlag(valueIdAndMsgFlag);
            scopeFinishValueVo.setKPIValue(kpiValue);
            scopeFinishValueVo.setNowValue(arrayList);
            scopeFinishValueVo.setValueRate(valueRate);
            res.add(scopeFinishValueVo);
        }
        if (res.size() > 0) {
            ScopeFinishValueVo amount = new ScopeFinishValueVo();
            amount.setObjectName("\u603b\u8ba1");
            ArrayList<BigDecimal> amountKpiValue = new ArrayList<BigDecimal>();
            amountKpiValue.addAll(((ScopeFinishValueVo)res.get(0)).getKPIValue());
            ArrayList<BigDecimal> amountNowValue = new ArrayList<BigDecimal>();
            amountNowValue.addAll(((ScopeFinishValueVo)res.get(0)).getNowValue());
            for (int i = 1; i < res.size(); ++i) {
                List<BigDecimal> currentKpiValue = ((ScopeFinishValueVo)res.get(i)).getKPIValue();
                List<BigDecimal> list = ((ScopeFinishValueVo)res.get(i)).getNowValue();
                for (int j = 0; j < currentKpiValue.size(); ++j) {
                    amountKpiValue.set(j, ((BigDecimal)amountKpiValue.get(j)).add(currentKpiValue.get(j)));
                    amountNowValue.set(j, ((BigDecimal)amountNowValue.get(j)).add(list.get(j)));
                }
            }
            ArrayList<Float> amountRate = new ArrayList<Float>();
            for (int k = 0; k < amountKpiValue.size(); ++k) {
                if (((BigDecimal)amountNowValue.get(k)).compareTo(BigDecimal.ZERO) == 0) {
                    amountRate.add(Float.valueOf(0.0f));
                    continue;
                }
                if (((BigDecimal)amountKpiValue.get(k)).compareTo(BigDecimal.ZERO) == 0) {
                    amountRate.add(Float.valueOf(100.0f));
                    continue;
                }
                BigDecimal bigDecimal = ((BigDecimal)amountNowValue.get(k)).multiply(BigDecimal.valueOf(100L)).divide((BigDecimal)amountKpiValue.get(k), 2, 4);
                amountRate.add(Float.valueOf(bigDecimal.floatValue()));
            }
            amount.setKPIValue(amountKpiValue);
            amount.setNowValue(amountNowValue);
            amount.setValueRate(amountRate);
            res.add(amount);
        }
        return res;
    }

    private List<SalesKPIScopeVo> getKPI(SalesKPIRuleDto salesKPIRuleDto) {
        return (List)this.opportunityAPIService.getKPI(salesKPIRuleDto).getData();
    }

    private Float getKpiRate(RuleVo rule, Long objectId) {
        List deptList = this.dataRightBoService.getChargeDepartmentList(objectId);
        boolean getAllScop = ToolUtil.isNotEmpty((Object)deptList) && ToolUtil.isNotEmpty((Object)objectId);
        List scopeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Scope::getRuleId, (Object)rule.getRuleId())).and(ToolUtil.isNotEmpty((Object)objectId), f -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)f.eq(ToolUtil.isNotEmpty((Object)objectId), Scope::getObjectId, (Object)objectId)).or(getAllScop)).in(getAllScop, Scope::getObjectId, (Collection)deptList);
        })).list();
        SalesKPIRuleDto salesKPIRuleDto = this.getSalesKPIRuleDto((Rule)((Object)BeanUtil.copy((Object)rule, Rule.class)), scopeList);
        List<Object> salesKPIScopeVoList = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)salesKPIRuleDto.getCheckObjectList())) {
            salesKPIScopeVoList = this.getKPI(salesKPIRuleDto);
        }
        BigDecimal kpiValue = BigDecimal.ZERO;
        for (Object scope : scopeList) {
            kpiValue = kpiValue.add(((Scope)((Object)scope)).getValueYear());
        }
        BigDecimal nowValue = BigDecimal.ZERO;
        for (SalesKPIScopeVo salesKPIScopeVo : salesKPIScopeVoList) {
            List kpiScore = salesKPIScopeVo.getKPIScore();
            for (BigDecimal bigDecimal : kpiScore) {
                nowValue = nowValue.add(bigDecimal);
            }
        }
        if (nowValue.compareTo(BigDecimal.ZERO) == 0) {
            return Float.valueOf(0.0f);
        }
        if (kpiValue.compareTo(BigDecimal.ZERO) == 0) {
            return Float.valueOf(100.0f);
        }
        BigDecimal bigDecimal = nowValue.multiply(BigDecimal.valueOf(100L)).divide(kpiValue, 2, 4);
        return Float.valueOf(bigDecimal.floatValue());
    }

    private SalesKPIRuleDto getSalesKPIRuleDto(Rule rule, List<Scope> scopeList) {
        List ruleDimensionList;
        SalesKPIRuleDto salesKPIRuleDto = new SalesKPIRuleDto();
        salesKPIRuleDto.setCheckObjectType(rule.getCheckObject());
        if (ToolUtil.isNotEmpty(scopeList)) {
            salesKPIRuleDto.setCheckObjectList(scopeList.stream().map(o -> String.valueOf(o.getObjectId())).collect(Collectors.toList()));
        }
        salesKPIRuleDto.setAnalyseDateType(rule.getAnalyseDateField());
        Integer analyseYear = Integer.parseInt(rule.getAnalyseYear());
        Integer analyseMonth = 1;
        if (rule.getCheckCycle().equals("1") || rule.getCheckCycle().equals("4")) {
            analyseMonth = Integer.parseInt(rule.getFiscalYearMonth());
        }
        LocalDate analyseDate = LocalDate.of((int)analyseYear, analyseMonth, 1);
        salesKPIRuleDto.setAnalyseDate(analyseDate);
        salesKPIRuleDto.setCheckCycle(rule.getCheckCycle());
        salesKPIRuleDto.setCheckIndex(rule.getCheckIndex());
        if (ToolUtil.isNotEmpty((Object)rule.getStageIds())) {
            salesKPIRuleDto.setStageIds(Arrays.asList(rule.getStageIds().split(",")));
        }
        if (ToolUtil.isNotEmpty((Object)(ruleDimensionList = ((LambdaQueryChainWrapper)this.ruleDimensionService.lambdaQuery().eq(RuleDimension::getRuleId, (Object)rule.getRuleId())).list()))) {
            salesKPIRuleDto.setProductList(ruleDimensionList.stream().filter(o -> "1".equals(o.getDimensionType())).map(o -> String.valueOf(o.getDimensionId())).collect(Collectors.toList()));
            salesKPIRuleDto.setCustomerList(ruleDimensionList.stream().filter(o -> "2".equals(o.getDimensionType())).map(o -> String.valueOf(o.getDimensionId())).collect(Collectors.toList()));
            salesKPIRuleDto.setPartnerList(ruleDimensionList.stream().filter(o -> "3".equals(o.getDimensionType())).map(o -> String.valueOf(o.getDimensionId())).collect(Collectors.toList()));
        }
        return salesKPIRuleDto;
    }

    @Override
    public ApiResponse<List<OpportunityStageVo>> getOpportunityStageData() {
        List stageDict = this.dicRefService.getDicListByType("salesKPI_stage");
        ArrayList<OpportunityStageVo> stageVoList = new ArrayList<OpportunityStageVo>();
        for (DicVo dict : stageDict) {
            OpportunityStageVo stageVo = new OpportunityStageVo();
            stageVo.setStageId(dict.getValue());
            stageVo.setStageName(dict.getLabel());
            stageVoList.add(stageVo);
        }
        return ApiResponse.success(stageVoList);
    }

    @Override
    public Page<ProductAPIVo> getProductData(ProductAPIDto dto) {
        return this.productAPIService.getProductPageList(dto);
    }

    @Override
    public Page<CustomerAPIVo> getCustomerData(CustomerAPIDto dto) {
        return this.customerAPIService.getCustomerPageList(dto);
    }

    @Override
    public Page getAgentData() {
        Page page = new Page();
        page.setRecords(new ArrayList());
        return page;
    }

    @Override
    public BigDecimal getPublishedKPIValueById(Long valueId) {
        if (ToolUtil.isEmpty((Object)valueId)) {
            throw new BaseException("\u76ee\u6807\u503cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ScopeValue scopeValue = (ScopeValue)((Object)((LambdaQueryChainWrapper)this.scopeValueService.lambdaQuery().eq(ScopeValue::getValueId, (Object)valueId)).one());
        return scopeValue.getKpiValue();
    }

    @Override
    public ScopeVo getSalesKPIByScopeId(Long scopeId) {
        if (ToolUtil.isEmpty((Object)scopeId)) {
            throw new BaseException("\u8003\u6838\u8303\u56f4id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Scope scope = (Scope)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Scope::getScopeId, (Object)scopeId)).one());
        ScopeVo scopeVo = (ScopeVo)BeanUtil.copy((Object)((Object)scope), ScopeVo.class);
        List<ScopeValueVo> scopeValueVoList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.scopeValueService.lambdaQuery().eq(ScopeValue::getScopeId, (Object)scopeId)).orderByAsc(ScopeValue::getSortOrder)).list().stream().map(scopeValue -> (ScopeValueVo)BeanUtil.copy((Object)scopeValue, ScopeValueVo.class)).collect(Collectors.toList());
        if (scopeVo != null) {
            scopeVo.setScopeValueList(scopeValueVoList);
        }
        return scopeVo;
    }

    @Override
    public boolean batchSave(List<Scope> scopeList) {
        return ((ScopeMapper)this.baseMapper).batchSave(scopeList);
    }

    @Override
    public boolean batchUpdateById(List<Scope> scopeList) {
        return ((ScopeMapper)this.baseMapper).batchUpdateById(scopeList);
    }
}

