/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.salesKPI.rule.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.core.api.customer.service.ICustomerAPIService;
import com.jxdinfo.crm.core.api.customer.vo.CustomerAPIVo;
import com.jxdinfo.crm.core.api.product.service.IProductAPIService;
import com.jxdinfo.crm.core.api.product.vo.ProductAPIVo;
import com.jxdinfo.crm.salesKPI.constants.CheckIndexEnum;
import com.jxdinfo.crm.salesKPI.constants.MsgConstants;
import com.jxdinfo.crm.salesKPI.message.factory.MsgServiceFactory;
import com.jxdinfo.crm.salesKPI.message.service.IMsgService;
import com.jxdinfo.crm.salesKPI.rule.dao.RuleMapper;
import com.jxdinfo.crm.salesKPI.rule.dto.RuleDto;
import com.jxdinfo.crm.salesKPI.rule.dto.RuleLockDto;
import com.jxdinfo.crm.salesKPI.rule.model.Rule;
import com.jxdinfo.crm.salesKPI.rule.model.RuleDimension;
import com.jxdinfo.crm.salesKPI.rule.model.RulePermission;
import com.jxdinfo.crm.salesKPI.rule.service.IRuleDimensionService;
import com.jxdinfo.crm.salesKPI.rule.service.IRulePermissionService;
import com.jxdinfo.crm.salesKPI.rule.service.IRuleService;
import com.jxdinfo.crm.salesKPI.rule.vo.RuleDetailVo;
import com.jxdinfo.crm.salesKPI.rule.vo.RuleDimensionVo;
import com.jxdinfo.crm.salesKPI.rule.vo.RulePermissionVo;
import com.jxdinfo.crm.salesKPI.rule.vo.RuleVo;
import com.jxdinfo.crm.salesKPI.scope.model.Scope;
import com.jxdinfo.crm.salesKPI.scope.model.ScopeDraft;
import com.jxdinfo.crm.salesKPI.scope.service.IScopeDraftService;
import com.jxdinfo.crm.salesKPI.scope.service.IScopeService;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.base.HussarDelflagEntity;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RuleServiceImpl
extends HussarBaseServiceImpl<RuleMapper, Rule>
implements IRuleService {
    @Resource
    IRuleDimensionService ruleDimensionService;
    @Resource
    IRulePermissionService rulePermissionService;
    @Resource
    IScopeService scopeService;
    @Resource
    IScopeDraftService scopeDraftService;
    @Resource
    ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private IProductAPIService productAPIService;
    @Resource
    private ICustomerAPIService customerAPIService;
    @Resource
    private MsgServiceFactory msgServiceFactory;

    @Override
    public Page<RuleVo> getSalesKPIRuleList(PageInfo pageInfo, Rule rule) {
        Page page = (Page)BeanUtil.copy((Object)pageInfo, Page.class);
        SecurityUser user = BaseSecurityUtil.getUser();
        String config = this.crmBaseConfigBoService.getCrmBaseConfigByKey("target_manager_role_id").getConfigValue();
        List targetManagerRoleIds = JSONObject.parseArray((String)config, Long.class);
        boolean isDisjoint = Collections.disjoint(user.getRolesList(), targetManagerRoleIds);
        if (isDisjoint) {
            rule.setCreator(user.getId());
        }
        List<RuleVo> ruleVoList = ((RuleMapper)this.baseMapper).getSalesKPIRuleList((Page<RuleVo>)page, rule);
        this.getRuleDimensionName(ruleVoList);
        page.setRecords(ruleVoList);
        return page;
    }

    private void setDimensionName(List<RuleDimensionVo> ruleDimensionList) {
        if (ToolUtil.isEmpty(ruleDimensionList)) {
            return;
        }
        List productIdList = ruleDimensionList.stream().filter(o -> "1".equals(o.getDimensionType())).map(RuleDimensionVo::getDimensionId).distinct().collect(Collectors.toList());
        List customerIdList = ruleDimensionList.stream().filter(o -> "2".equals(o.getDimensionType())).map(RuleDimensionVo::getDimensionId).distinct().collect(Collectors.toList());
        List agentIdList = ruleDimensionList.stream().filter(o -> "3".equals(o.getDimensionType())).map(RuleDimensionVo::getDimensionId).distinct().collect(Collectors.toList());
        List productAPIVoList = new ArrayList();
        if (ToolUtil.isNotEmpty(productIdList)) {
            productAPIVoList = this.productAPIService.getProductListByIds(productIdList);
        }
        List customerAPIVoList = new ArrayList();
        if (ToolUtil.isNotEmpty(customerIdList)) {
            customerAPIVoList = this.customerAPIService.getCustomerListByIds(customerIdList);
        }
        List finalProductAPIVoList = productAPIVoList;
        ArrayList finalCustomerAPIVoList = customerAPIVoList;
        ruleDimensionList.stream().peek(o -> {
            block5 : switch (o.getDimensionType()) {
                case "1": {
                    for (ProductAPIVo productAPIVo : finalProductAPIVoList) {
                        if (!o.getDimensionId().equals(productAPIVo.getProductId())) continue;
                        o.setDimensionName(productAPIVo.getProductName());
                        break block5;
                    }
                    break;
                }
                case "2": {
                    for (CustomerAPIVo customerAPIVo : finalCustomerAPIVoList) {
                        if (!o.getDimensionId().equals(customerAPIVo.getCustomerId())) continue;
                        o.setDimensionName(customerAPIVo.getCustomerName());
                        break block5;
                    }
                    break;
                }
                case "3": {
                    break;
                }
            }
        }).collect(Collectors.toList());
    }

    private String getDimensionName(List<RuleDimensionVo> ruleDimensionList) {
        StringBuilder productName = new StringBuilder("\u4ea7\u54c1 (");
        StringBuilder customerName = new StringBuilder("\u5ba2\u6237 (");
        StringBuilder agentName = new StringBuilder("\u4ee3\u7406\u5546 (");
        Boolean hasProduct = false;
        Boolean hasCustomer = false;
        Boolean hasAgent = false;
        for (RuleDimensionVo ruleDimension : ruleDimensionList) {
            switch (ruleDimension.getDimensionType()) {
                case "1": {
                    hasProduct = true;
                    productName.append(ruleDimension.getDimensionName()).append("\u3001");
                    break;
                }
                case "2": {
                    hasCustomer = true;
                    customerName.append(ruleDimension.getDimensionName()).append("\u3001");
                    break;
                }
                case "3": {
                    hasAgent = true;
                    agentName.append(ruleDimension.getDimensionName()).append("\u3001");
                    break;
                }
            }
        }
        StringBuilder res = new StringBuilder();
        if (hasProduct.booleanValue()) {
            res.append(productName.substring(0, productName.length() - 1)).append(");");
        }
        if (hasCustomer.booleanValue()) {
            res.append(customerName.substring(0, customerName.length() - 1)).append(");");
        }
        if (hasAgent.booleanValue()) {
            res.append(agentName.substring(0, agentName.length() - 1)).append(");");
        }
        if (ToolUtil.isEmpty((Object)res.toString())) {
            return "";
        }
        return res.substring(0, res.length() - 1);
    }

    @Override
    public List<RuleVo> getSalesKPIRuleList(Rule rule) {
        SecurityUser user = BaseSecurityUtil.getUser();
        String config = this.crmBaseConfigBoService.getCrmBaseConfigByKey("target_manager_role_id").getConfigValue();
        List targetManagerRoleIds = JSONObject.parseArray((String)config, Long.class);
        boolean isDisjoint = Collections.disjoint(user.getRolesList(), targetManagerRoleIds);
        if (isDisjoint) {
            rule.setCreator(user.getId());
        }
        rule.setDisableFlag("0");
        List<RuleVo> ruleVoList = ((RuleMapper)this.baseMapper).getSalesKPIRuleList(rule);
        this.getRuleDimensionName(ruleVoList);
        this.setTargetType(ruleVoList);
        return ruleVoList;
    }

    private List<RuleVo> setTargetType(List<RuleVo> ruleVoList) {
        String amountDisplay = this.crmBaseConfigBoService.getCrmBaseConfigByKey("amount_display").getConfigValue();
        Map<String, JSONObject> configMap = this.crmBaseConfigBoService.getCrmBaseConfigByParentId("1752871929632641026").stream().filter(Objects::nonNull).collect(Collectors.toMap(CrmBaseConfigVo::getConfigKey, vo -> JSONObject.parseObject((String)vo.getConfigValue())));
        JSONObject amountDisplayJson = JSONObject.parseObject((String)amountDisplay);
        for (RuleVo ruleVo : ruleVoList) {
            String checkIndex = ruleVo.getCheckIndex();
            CheckIndexEnum checkIndexEnum = CheckIndexEnum.getEnumByDictValue(checkIndex);
            JSONObject json = configMap.get(checkIndexEnum.getConfigKey());
            ruleVo.setDecimal((Boolean)json.get((Object)"decimal"));
            ruleVo.setUnit((String)amountDisplayJson.get((Object)"unit"));
            ruleVo.setDecimalNum((Integer)amountDisplayJson.get((Object)"decimalNum"));
        }
        return ruleVoList;
    }

    @Override
    public RuleDetailVo getSalesKPIRuleById(Long id) {
        Rule rule = (Rule)((Object)this.getById(id));
        RuleDetailVo ruleVo = (RuleDetailVo)BeanUtil.copy((Object)((Object)rule), RuleDetailVo.class);
        List<RuleDimensionVo> ruleDimensionVoList = ((LambdaQueryChainWrapper)this.ruleDimensionService.lambdaQuery().eq(RuleDimension::getRuleId, (Object)id)).list().stream().map(o -> (RuleDimensionVo)BeanUtil.copy((Object)o, RuleDimensionVo.class)).collect(Collectors.toList());
        this.setDimensionName(ruleDimensionVoList);
        ruleVo.setRuleDimensionList(ruleDimensionVoList);
        List<RulePermissionVo> rulePermissionVoList = this.rulePermissionService.listByRuleId(id);
        ruleVo.setRulePermissionList(rulePermissionVoList);
        return ruleVo;
    }

    @Override
    @HussarTransactional
    public Boolean addSalesKPIRule(RuleDto dto) {
        Rule rule = (Rule)((Object)BeanUtil.copy((Object)dto, Rule.class));
        String userName = BaseSecurityUtil.getUser().getUserName();
        Long userId = BaseSecurityUtil.getUser().getUserId();
        rule.setCreatorName(userName);
        rule.setLastEditorName(userName);
        rule.setLastEditor(userId);
        rule.setLastTime(LocalDateTime.now());
        this.save((BaseEntity)rule);
        List<RuleDimension> ruleDimensionList = dto.getRuleDimensionList();
        List<RulePermission> rulePermissionList = dto.getRulePermissionList();
        if (ToolUtil.isNotEmpty(ruleDimensionList)) {
            ruleDimensionList.stream().peek(o -> o.setRuleId(rule.getRuleId())).collect(Collectors.toList());
            this.ruleDimensionService.saveBatch(ruleDimensionList);
        }
        if (ToolUtil.isNotEmpty(rulePermissionList)) {
            rulePermissionList.stream().peek(o -> o.setRuleId(rule.getRuleId())).collect(Collectors.toList());
            this.rulePermissionService.saveBatch(rulePermissionList);
            IMsgService msgService = this.msgServiceFactory.getMsgService(MsgConstants.OperationType.SHARE.getCode());
            Map beanToMap = BeanUtil.beanToMap((Object)dto);
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            list.add(beanToMap);
            msgService.sendMsg(list);
        }
        return true;
    }

    @Override
    @HussarTransactional
    public Boolean editSalesKPIRule(RuleDto dto) {
        List scopeList = ((LambdaQueryChainWrapper)this.scopeService.lambdaQuery().eq(Scope::getRuleId, (Object)dto.getRuleId())).list();
        List scopeDraftList = ((LambdaQueryChainWrapper)this.scopeDraftService.lambdaQuery().eq(ScopeDraft::getRuleId, (Object)dto.getRuleId())).list();
        if (ToolUtil.isNotEmpty((Object)scopeList) || ToolUtil.isNotEmpty((Object)scopeDraftList)) {
            Rule oldRule = (Rule)((Object)this.getById(dto.getRuleId()));
            StringBuilder errMsg = new StringBuilder("\u5df2\u88ab\u4f7f\u7528\u7684\u89c4\u5219");
            Boolean errSign = false;
            if (!oldRule.getCheckObject().equals(dto.getCheckObject())) {
                errSign = true;
                errMsg.append("\u8003\u6838\u5bf9\u8c61\u3001");
            }
            if (!oldRule.getCheckCycle().equals(dto.getCheckCycle())) {
                errSign = true;
                errMsg.append("\u8003\u6838\u5468\u671f\u3001");
            }
            if (!oldRule.getCheckIndex().equals(dto.getCheckIndex())) {
                errSign = true;
                errMsg.append("\u8003\u6838\u6307\u6807\u3001");
            }
            if (errSign.booleanValue()) {
                throw new BaseException(errMsg.substring(0, errMsg.length() - 1) + "\u4e0d\u5141\u8bb8\u4fee\u6539");
            }
        }
        List<RuleDimension> ruleDimensionList = dto.getRuleDimensionList();
        List<RulePermission> rulePermissionList = dto.getRulePermissionList();
        Rule rule = (Rule)((Object)BeanUtil.copy((Object)dto, Rule.class));
        String userName = BaseSecurityUtil.getUser().getUserName();
        rule.setLastEditorName(userName);
        this.saveOrUpdate((BaseEntity)rule);
        ((LambdaUpdateChainWrapper)this.ruleDimensionService.lambdaUpdate().eq(RuleDimension::getRuleId, (Object)dto.getRuleId())).remove();
        if (ToolUtil.isNotEmpty(ruleDimensionList)) {
            ruleDimensionList.stream().peek(o -> o.setRuleId(dto.getRuleId())).collect(Collectors.toList());
            this.ruleDimensionService.saveBatch(ruleDimensionList);
        }
        List<RulePermissionVo> old = this.rulePermissionService.listByRuleId(dto.getRuleId());
        ((LambdaUpdateChainWrapper)this.rulePermissionService.lambdaUpdate().eq(RulePermission::getRuleId, (Object)dto.getRuleId())).remove();
        if (ToolUtil.isNotEmpty(rulePermissionList)) {
            rulePermissionList.stream().peek(o -> o.setRuleId(dto.getRuleId())).collect(Collectors.toList());
            this.rulePermissionService.saveBatch(rulePermissionList);
            IMsgService msgService = this.msgServiceFactory.getMsgService(MsgConstants.OperationType.SHARE.getCode());
            dto.setOldRulePermissionList(old.stream().map(o -> (RulePermission)BeanUtil.copy((Object)o, RulePermission.class)).collect(Collectors.toList()));
            Map beanToMap = BeanUtil.beanToMap((Object)dto);
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            list.add(beanToMap);
            msgService.sendMsg(list);
        }
        return true;
    }

    @Override
    public Boolean deleteBatchByIds(String ids) {
        List idList = Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList());
        StringBuilder stringBuilder = new StringBuilder();
        List usedIdList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.scopeService.lambdaQuery().eq(HussarDelflagEntity::getDelFlag, (Object)"0")).in(Scope::getRuleId, idList)).list().stream().map(Scope::getRuleId).collect(Collectors.toList());
        if (ToolUtil.isNotEmpty(usedIdList)) {
            List usedRule = ((LambdaQueryChainWrapper)this.lambdaQuery().in(Rule::getRuleId, usedIdList)).list();
            for (Rule rule : usedRule) {
                stringBuilder.append("\u3001");
                stringBuilder.append(rule.getRuleName());
            }
            if (ToolUtil.isNotEmpty((Object)stringBuilder)) {
                String error = stringBuilder.substring(1);
                throw new BaseException(error + "\u5df2\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
            }
        }
        String userName = BaseSecurityUtil.getUser().getUserName();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(HussarDelflagEntity::getDelFlag, (Object)"1")).set(Rule::getLastEditorName, (Object)userName)).in(Rule::getRuleId, idList)).update();
    }

    @Override
    public Boolean disableRule(Long id, String disableFlag) {
        String userName = BaseSecurityUtil.getUser().getUserName();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Rule::getDisableFlag, (Object)disableFlag)).set(Rule::getLastEditorName, (Object)userName)).eq(Rule::getRuleId, (Object)id)).update();
    }

    @Override
    public JSONObject getRuleDimension(String checkIndex) {
        CheckIndexEnum checkIndexEnum = CheckIndexEnum.getEnumByDictValue(checkIndex);
        String configValue = this.crmBaseConfigBoService.getCrmBaseConfigByKey(checkIndexEnum.getConfigKey()).getConfigValue();
        return JSONObject.parseObject((String)configValue);
    }

    @Override
    public List<RuleVo> getAuthRuleList(String ruleName, Boolean auth, Long userId, List<Long> orgIdList, String ruleType, String checkObject, boolean nowCycle) {
        boolean creator = ToolUtil.isEmpty((Object)ruleType) || ruleType.contains("1");
        boolean examine = ToolUtil.isEmpty((Object)ruleType) || ruleType.contains("2");
        boolean share = ToolUtil.isEmpty((Object)ruleType) || ruleType.contains("3");
        List<RuleVo> ruleVoList = examine ? ((RuleMapper)this.baseMapper).getAuthRuleList(ruleName, auth, userId, orgIdList, true, true) : ((RuleMapper)this.baseMapper).getAuthRuleList(ruleName, auth, userId, orgIdList, creator, share);
        ruleVoList = this.getRuleListByCheckObject(ruleVoList, checkObject);
        if (nowCycle) {
            ruleVoList = this.getNowAuthRuleList(ruleVoList);
        }
        ruleVoList = this.getRuleDimensionName(ruleVoList);
        this.setTargetType(ruleVoList);
        return ruleVoList;
    }

    private List<RuleVo> getRuleDimensionName(List<RuleVo> ruleVoList) {
        if (ToolUtil.isNotEmpty(ruleVoList)) {
            List ruleIdList = ruleVoList.stream().map(RuleVo::getRuleId).collect(Collectors.toList());
            List<RuleDimensionVo> ruleDimensionList = ((LambdaQueryChainWrapper)this.ruleDimensionService.lambdaQuery().in(RuleDimension::getRuleId, ruleIdList)).list().stream().map(o -> (RuleDimensionVo)BeanUtil.copy((Object)o, RuleDimensionVo.class)).collect(Collectors.toList());
            this.setDimensionName(ruleDimensionList);
            for (RuleVo rule : ruleVoList) {
                ArrayList<RuleDimensionVo> dimensionList = new ArrayList<RuleDimensionVo>();
                ArrayList<Long> productIdList = new ArrayList<Long>();
                ArrayList<Long> customerIdList = new ArrayList<Long>();
                ArrayList<Long> agentIdList = new ArrayList<Long>();
                for (RuleDimensionVo ruleDimension : ruleDimensionList) {
                    if (!rule.getRuleId().equals(ruleDimension.getRuleId())) continue;
                    dimensionList.add(ruleDimension);
                    Long dimensionId = ruleDimension.getDimensionId();
                    switch (ruleDimension.getDimensionType()) {
                        case "1": {
                            productIdList.add(dimensionId);
                            break;
                        }
                        case "2": {
                            customerIdList.add(dimensionId);
                            break;
                        }
                        case "3": {
                            agentIdList.add(dimensionId);
                            break;
                        }
                    }
                }
                rule.setDimensionName(this.getDimensionName(dimensionList));
                HashMap<String, ArrayList> dimensionMap = new HashMap<String, ArrayList>();
                dimensionMap.put("product", productIdList);
                dimensionMap.put("customer", customerIdList);
                dimensionMap.put("agent", agentIdList);
                rule.setDimensionMap(dimensionMap);
            }
        }
        return ruleVoList;
    }

    private List<RuleVo> getRuleListByCheckObject(List<RuleVo> ruleVoList, String checkObject) {
        Boolean dept = ToolUtil.isEmpty((Object)checkObject) || checkObject.indexOf("1") >= 0;
        Boolean user = ToolUtil.isEmpty((Object)checkObject) || checkObject.indexOf("2") >= 0;
        ArrayList<RuleVo> newRuleVoList = new ArrayList<RuleVo>();
        if (ToolUtil.isNotEmpty(ruleVoList)) {
            for (RuleVo rule : ruleVoList) {
                if ((!rule.getCheckObject().equals("1") || !dept.booleanValue()) && (!rule.getCheckObject().equals("2") || !user.booleanValue())) continue;
                newRuleVoList.add(rule);
            }
        }
        return newRuleVoList;
    }

    @Override
    public List<RuleVo> getNowAuthRuleList(List<RuleVo> ruleVoList) {
        ArrayList<RuleVo> newRuleVoList = new ArrayList<RuleVo>();
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        if (ToolUtil.isNotEmpty(ruleVoList)) {
            for (RuleVo rule : ruleVoList) {
                Integer analyseYear = Integer.parseInt(rule.getAnalyseYear());
                if (rule.getCheckCycle().equals("1") || rule.getCheckCycle().equals("4")) {
                    Integer analyseMonth = Integer.parseInt(rule.getFiscalYearMonth());
                    if ((year != analyseYear || month < analyseMonth) && (year != analyseYear + 1 || month >= analyseMonth)) continue;
                    newRuleVoList.add(rule);
                    continue;
                }
                if (!rule.getCheckCycle().equals("2") && !rule.getCheckCycle().equals("3") || year != analyseYear) continue;
                newRuleVoList.add(rule);
            }
        }
        return newRuleVoList;
    }

    @Override
    public List<RuleVo> getLastAuthRuleList(List<RuleVo> ruleVoList) {
        ArrayList<RuleVo> newRuleVoList = new ArrayList<RuleVo>();
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        if (ToolUtil.isNotEmpty(ruleVoList)) {
            for (RuleVo rule : ruleVoList) {
                int analyseMonth;
                int analyseYear = Integer.parseInt(rule.getAnalyseYear());
                if (rule.getCheckCycle().equals("1")) {
                    analyseMonth = Integer.parseInt(rule.getFiscalYearMonth());
                    if ((year - 1 != analyseYear || month <= analyseMonth) && (year - 2 != analyseYear || month >= analyseMonth)) continue;
                    newRuleVoList.add(rule);
                    continue;
                }
                if (rule.getCheckCycle().equals("2")) {
                    if (month < 7) {
                        if (year - 1 != analyseYear) continue;
                        newRuleVoList.add(rule);
                        continue;
                    }
                    if (year != analyseYear) continue;
                    newRuleVoList.add(rule);
                    continue;
                }
                if (rule.getCheckCycle().equals("3")) {
                    if (month < 4) {
                        if (year - 1 != analyseYear) continue;
                        newRuleVoList.add(rule);
                        continue;
                    }
                    if (year != analyseYear) continue;
                    newRuleVoList.add(rule);
                    continue;
                }
                if (!rule.getCheckCycle().equals("4")) continue;
                analyseMonth = Integer.parseInt(rule.getFiscalYearMonth());
                if ((analyseYear != year - 1 || analyseMonth < month) && (analyseYear != year || analyseMonth >= month)) continue;
                newRuleVoList.add(rule);
            }
        }
        return newRuleVoList;
    }

    @Override
    public List<RuleVo> getRuleListByCheckObject(String ruleName, List<Long> ruleIdList, List<Long> existRule, String ruleType, String checkObject, boolean nowCycle) {
        if (ToolUtil.isEmpty((Object)ruleType) || ruleType.indexOf("2") >= 0) {
            List<RuleVo> ruleVoList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(ToolUtil.isNotEmpty((Object)ruleName), Rule::getRuleName, (Object)ruleName)).eq(Rule::getDisableFlag, (Object)"0")).in(Rule::getRuleId, ruleIdList)).notIn(ToolUtil.isNotEmpty(existRule), Rule::getRuleId, existRule)).list().stream().map(o -> (RuleVo)BeanUtil.copy((Object)o, RuleVo.class)).collect(Collectors.toList());
            ruleVoList = this.getRuleListByCheckObject(ruleVoList, checkObject);
            if (nowCycle) {
                ruleVoList = this.getNowAuthRuleList(ruleVoList);
            }
            ruleVoList = this.getRuleDimensionName(ruleVoList);
            this.setTargetType(ruleVoList);
            return ruleVoList;
        }
        return new ArrayList<RuleVo>();
    }

    @Override
    public Boolean lockRule(RuleLockDto dto) {
        List<Long> ruleIds = dto.getRuleIds();
        if (ToolUtil.isEmpty(ruleIds)) {
            throw new BaseException("\u89c4\u5219id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String lockFlag = dto.getLockFlag();
        if (ToolUtil.isEmpty((Object)lockFlag)) {
            throw new BaseException("\u9501\u5b9a\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String operator = BaseSecurityUtil.getUser().getUserName();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Rule::getLockFlag, (Object)lockFlag)).set(Rule::getLastEditorName, (Object)operator)).set(HussarBaseEntity::getLastTime, (Object)LocalDateTime.now())).in(Rule::getRuleId, ruleIds)).update();
    }
}

