/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.salesKPI.message.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.jxdinfo.crm.salesKPI.constants.MsgConstants;
import com.jxdinfo.crm.salesKPI.message.service.BaseMsgService;
import com.jxdinfo.crm.salesKPI.message.service.IMsgService;
import com.jxdinfo.crm.salesKPI.rule.model.Rule;
import com.jxdinfo.crm.salesKPI.scope.vo.ScopeVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class DeleteGoal
extends BaseMsgService
implements IMsgService {
    @Override
    public void sendMsg(List<Map<String, Object>> list) {
        if (list.isEmpty()) {
            return;
        }
        List<ScopeVo> voList = list.stream().map(map -> (ScopeVo)BeanUtil.mapToBean((Map)map, ScopeVo.class, (boolean)true)).collect(Collectors.toList());
        Long ruleId = ((ScopeVo)voList.get(0)).getRuleId();
        Rule rule = (Rule)((Object)this.ruleService.getById(ruleId));
        String checkObject = rule.getCheckObject();
        String ruleName = rule.getRuleName();
        String userName = BaseSecurityUtil.getUser().getUserName();
        Long userId = BaseSecurityUtil.getUser().getUserId();
        if (MsgConstants.CheckObject.DEPT.getCode().toString().equals(checkObject)) {
            this.sendDeptGoalDeleteMsg(userName, userId, ruleName, voList);
        } else if (MsgConstants.CheckObject.PERSON.getCode().toString().equals(checkObject)) {
            this.sendPersonGoalDeleteMsg(userName, userId, ruleName, voList);
        }
    }

    private void sendDeptGoalDeleteMsg(String userName, Long userId, String ruleName, List<ScopeVo> voList) {
        List deptIdList = voList.stream().map(ScopeVo::getObjectId).collect(Collectors.toList());
        Map chargePersonList = this.dataRightBoService.getChargePersonList(deptIdList);
        if (null == chargePersonList || chargePersonList.isEmpty()) {
            return;
        }
        voList.forEach(scopeVo -> {
            String deptName = scopeVo.getObjectName();
            Long deptId = scopeVo.getObjectId();
            List SecurityUsers = (List)chargePersonList.get(deptId);
            if (null == SecurityUsers || SecurityUsers.isEmpty()) {
                return;
            }
            List<String> sendMsgUserIds = SecurityUsers.stream().map(UserDetails::getUserId).map(String::valueOf).filter(id -> !userId.toString().equals(id)).collect(Collectors.toList());
            if (sendMsgUserIds.isEmpty()) {
                return;
            }
            String title = "\u3010\u9500\u552e\u76ee\u6807\u63d0\u9192\u3011";
            String content = userName + "\u5c06\u60a8\u8d1f\u8d23\u7684\u3010" + deptName + "\u3011\u9500\u552e\u76ee\u6807\u3010" + ruleName + "\u3011\u5220\u9664\uff0c\u8bf7\u77e5\u6089";
            this.sendNoteMsg(title, content, "#/crm/salesTarget/index", sendMsgUserIds, LocalDateTime.now());
            String mobileTitle = userName + "\u5220\u9664\u4e86\u60a8\u8d1f\u8d23\u7684\u3010" + deptName + "\u3011\u7684\u9500\u552e\u76ee\u6807";
            String mobileContent = "\u9500\u552e\u76ee\u6807\u540d\u79f0\u3010" + ruleName + "\u3011\uff0c\u8bf7\u77e5\u6089";
            this.sendJqxNoteMsg(mobileTitle, mobileContent, "/crm/sy/yddsy", sendMsgUserIds);
        });
    }

    private void sendPersonGoalDeleteMsg(String userName, Long userId, String ruleName, List<ScopeVo> voList) {
        List<String> sendMessageUserIds = voList.stream().map(ScopeVo::getObjectId).map(String::valueOf).filter(id -> !userId.toString().equals(id)).collect(Collectors.toList());
        if (sendMessageUserIds.isEmpty()) {
            return;
        }
        String title = "\u3010\u9500\u552e\u76ee\u6807\u63d0\u9192\u3011";
        String content = userName + "\u5c06\u60a8\u7684\u9500\u552e\u76ee\u6807\u3010" + ruleName + "\u3011\u5220\u9664\uff0c\u8bf7\u77e5\u6089";
        this.sendNoteMsg(title, content, "#/crm/salesTarget/index", sendMessageUserIds, LocalDateTime.now());
        String mobileTitle = userName + "\u5220\u9664\u4e86\u9500\u552e\u76ee\u6807";
        String mobileContent = "\u9500\u552e\u76ee\u6807\u540d\u79f0\u3010" + ruleName + "\u3011\uff0c\u8bf7\u77e5\u6089";
        this.sendJqxNoteMsg(mobileTitle, mobileContent, "/crm/sy/yddsy", sendMessageUserIds);
    }
}

