/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.salesKPI.job.processor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.salesKPI.constants.MsgConstants;
import com.jxdinfo.crm.salesKPI.job.service.IStatisticService;
import com.jxdinfo.crm.salesKPI.message.Dto.RuleCompletionMsgDto;
import com.jxdinfo.crm.salesKPI.message.factory.MsgServiceFactory;
import com.jxdinfo.crm.salesKPI.message.service.IMsgService;
import com.jxdinfo.crm.salesKPI.rule.model.Rule;
import com.jxdinfo.crm.salesKPI.rule.service.IRuleService;
import com.jxdinfo.crm.salesKPI.rule.vo.RuleVo;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProgressOrFinishMsgProcessor
implements BasicProcessor {
    private final Logger logger = LoggerFactory.getLogger(ProgressOrFinishMsgProcessor.class);
    @Resource
    private IRuleService ruleService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private IStatisticService statisticService;
    @Resource
    private MsgServiceFactory msgServiceFactory;

    public ProcessResult process(TaskContext taskContext) throws Exception {
        String jobParams = taskContext.getJobParams();
        JSONObject jobParamsJson = JSONObject.parseObject((String)jobParams);
        String config = jobParamsJson.getString("config");
        Integer beforeOrAfter = jobParamsJson.getInteger("noteBeforeOrAfter");
        List<RuleVo> ruleVoList = ((LambdaQueryChainWrapper)this.ruleService.lambdaQuery().eq(Rule::getDisableFlag, (Object)"0")).list().stream().map(rule -> (RuleVo)BeanUtil.copyProperties((Object)rule, RuleVo.class)).collect(Collectors.toList());
        List<RuleVo> ruleList = MsgConstants.BeforeOrAfter.BEFORE.getCode().equals(beforeOrAfter) ? this.ruleService.getNowAuthRuleList(ruleVoList) : this.ruleService.getLastAuthRuleList(ruleVoList);
        String jsonStr = this.crmBaseConfigBoService.getCrmBaseConfigByKey(config).getConfigValue();
        JSONObject msgNoteDaysConfig = JSON.parseObject((String)jsonStr);
        List<RuleVo> alterRuleVoList = this.statisticService.filterAlertRule(ruleList, msgNoteDaysConfig, beforeOrAfter);
        ArrayList<RuleCompletionMsgDto> param = new ArrayList<RuleCompletionMsgDto>();
        for (MsgConstants.CheckCycle checkCycle : MsgConstants.CheckCycle.values()) {
            param.addAll(this.statisticService.getStatisticCompletion(alterRuleVoList, checkCycle.getCode().toString(), beforeOrAfter));
        }
        IMsgService msgService = MsgConstants.BeforeOrAfter.BEFORE.getCode().equals(beforeOrAfter) ? this.msgServiceFactory.getMsgService(MsgConstants.OperationType.PROGRESS.getCode()) : this.msgServiceFactory.getMsgService(MsgConstants.OperationType.FINISH.getCode());
        msgService.sendMsg(param.stream().map(BeanUtil::beanToMap).collect(Collectors.toList()));
        return new ProcessResult(true, "\u6d88\u606f\u63a8\u9001\u4efb\u52a1\u6267\u884c\u6210\u529f");
    }
}

