/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.product.utils;

import com.jxdinfo.crm.product.dao.ProductCategoryMapper;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class ProductCategoryUtils {
    private static final ProductCategoryMapper productCategoryMapper = (ProductCategoryMapper)SpringUtil.getBean(ProductCategoryMapper.class);

    public static List<Long> getProductCategoryIdsByParentId(List<Long> parentIds, List<Long> productCategoryIds) {
        productCategoryIds.addAll(parentIds);
        List<Long> categoryIds = productCategoryMapper.selectByParentId(parentIds);
        if (HussarUtils.isNotEmpty(categoryIds)) {
            ProductCategoryUtils.getProductCategoryIdsByParentId(categoryIds, productCategoryIds);
        }
        return productCategoryIds;
    }

    public static List<JSTreeModel> merge(List<JSTreeModel> items) {
        ArrayList<Long> parentIds = new ArrayList<Long>();
        if (!HussarUtils.isNotEmpty(items)) {
            return new ArrayList<JSTreeModel>();
        }
        LinkedHashMap<Long, JSTreeModel> map = new LinkedHashMap<Long, JSTreeModel>();
        for (JSTreeModel item : items) {
            map.put(item.getId(), item);
        }
        for (JSTreeModel item : items) {
            JSTreeModel temp = (JSTreeModel)map.get(item.getParentId());
            if (temp != null) {
                temp.getChildrenList().add(item);
                continue;
            }
            parentIds.add(item.getId());
        }
        ArrayList<JSTreeModel> roots = new ArrayList<JSTreeModel>();
        for (Long productCategoryId : parentIds) {
            JSTreeModel temp = (JSTreeModel)map.get(productCategoryId);
            if (!HussarUtils.isNotEmpty((Object)temp)) continue;
            roots.add(temp);
        }
        return roots;
    }
}

