/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.marketing.wallchart.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.marketing.wallchart.dao.WallchartMapper;
import com.jxdinfo.crm.marketing.wallchart.dao.WallchartRuleMapper;
import com.jxdinfo.crm.marketing.wallchart.dto.WallchartRuleEntityDto;
import com.jxdinfo.crm.marketing.wallchart.model.Wallchart;
import com.jxdinfo.crm.marketing.wallchart.model.WallchartRule;
import com.jxdinfo.crm.marketing.wallchart.service.WallchartRuleService;
import com.jxdinfo.crm.marketing.wallchart.service.WallchartService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WallchartRuleServiceImpl
extends ServiceImpl<WallchartRuleMapper, WallchartRule>
implements WallchartRuleService {
    @Resource
    private WallchartMapper wallchartMapper;
    @Resource
    private WallchartService wallchartService;

    @Override
    @Transactional
    public Long saveWallchartRule(WallchartRuleEntityDto wallchartRuleEntityDto, Long wallchartId) {
        WallchartRule wallchartRule = new WallchartRule();
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        if (null == wallchartRuleEntityDto) {
            wallchartRule.setWallchartId(wallchartId);
            wallchartRule.setWallchartShowType("1,2");
            wallchartRule.setShowCustomerStatus("0,1,2,3,4");
            wallchartRule.setConnectRule("1");
            wallchartRule.setFollowRule("1");
            wallchartRule.setOpportunityStage("2");
            wallchartRule.setSignRule("1");
            wallchartRule.setStatisticsBeforeStart("1");
            wallchartRule.setRelationType("1");
            wallchartRule.setCustomerPermission("1");
            wallchartRule.setDelFlag("0");
            wallchartRule.setCreateTime(date);
            wallchartRule.setCreator(user.getUserId());
            wallchartRule.setCreatorName(user.getUserName());
            wallchartRule.setCreateDepartment(user.getDeptId());
            wallchartRule.setCreateDepartmentName(user.getDeptName());
            wallchartRule.setOwnUnit(user.getTenantId());
            wallchartRule.setOwnUnitName(user.getTenantName());
            ArrayList appliedRangeContentList = new ArrayList();
            HashMap<String, Object> appliedRangeContentMap = new HashMap<String, Object>();
            appliedRangeContentMap.put("value", user.getDeptId());
            appliedRangeContentMap.put("label", user.getDeptName());
            appliedRangeContentMap.put("type", "organ");
            appliedRangeContentMap.put("checked", false);
            appliedRangeContentList.add(appliedRangeContentMap);
            wallchartRule.setAppliedRangeContent(JSONObject.toJSONString(appliedRangeContentList));
        } else {
            wallchartRule = (WallchartRule)BeanUtil.copy((Object)wallchartRuleEntityDto, WallchartRule.class);
            Wallchart wallchart = (Wallchart)this.wallchartService.getById(wallchartId);
            if (CollectionUtil.isNotEmpty((Object)wallchartRuleEntityDto.getProductIds())) {
                wallchart.setProductIds(wallchartRuleEntityDto.getProductIds());
                wallchart.setProductNames(wallchartRuleEntityDto.getProductNames());
            }
            assert (wallchartRule != null);
            wallchartRule.setLastTime(date);
            wallchartRule.setLastEditor(user.getUserId());
            wallchartRule.setLastEditorName(user.getUserName());
            if (ToolUtil.isNotEmpty((Object)wallchartRuleEntityDto.getAppliedRange())) {
                wallchart.setAppliedRange(wallchartRuleEntityDto.getAppliedRange());
            }
            this.wallchartMapper.updateById(wallchart);
        }
        this.saveOrUpdate(wallchartRule);
        return wallchartRule.getWallchartRuleId();
    }
}

