/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.aiqa.aiqarecords.service.support;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.knowledge.aiqa.aiqarecords.dao.QuestionRecordsDao;
import com.jxdinfo.crm.knowledge.aiqa.aiqarecords.model.QQuestionRecords;
import com.jxdinfo.crm.knowledge.aiqa.aiqarecords.model.QQuestionRecordsQo;
import com.jxdinfo.crm.knowledge.aiqa.aiqarecords.service.IQuestionRecordsService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuestionRecordsServiceImpl
extends ServiceImpl<QuestionRecordsDao, QQuestionRecords>
implements IQuestionRecordsService {
    @Autowired
    private QuestionRecordsDao questionrecordsDao;

    @Override
    public List<QQuestionRecords> getList(Page page, QQuestionRecordsQo questionrecordsQo) {
        return this.questionrecordsDao.getList(page, questionrecordsQo);
    }

    @Override
    public boolean insertOrUpdate(QQuestionRecords questionrecords) {
        this.saveOrUpdate((Object)questionrecords);
        return true;
    }

    @Override
    public QQuestionRecords formQuery(String id) {
        QQuestionRecords questionrecords = (QQuestionRecords)((Object)this.getById((Serializable)((Object)id)));
        return questionrecords;
    }

    @Override
    public boolean del(List<String> ids) {
        if (null != ids && ids.size() > 0) {
            this.removeByIds(ids);
        }
        return true;
    }

    @Override
    public Map<String, Object> getRecordList() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        QQuestionRecords questionRecords = new QQuestionRecords();
        questionRecords.setCreator(BaseSecurityUtil.getUser().getUserId());
        List<QQuestionRecords> qQuestionRecordsList = this.questionrecordsDao.getRecordList(questionRecords);
        res.put("data", qQuestionRecordsList);
        res.put("code", 200);
        return res;
    }

    @Override
    public Map<String, Object> getRecord(QQuestionRecords questionRecords) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        questionRecords.setCreator(BaseSecurityUtil.getUser().getUserId());
        List<QQuestionRecords> qQuestionRecordsList = this.questionrecordsDao.getRecord(questionRecords);
        res.put("data", qQuestionRecordsList);
        res.put("code", 200);
        return res;
    }

    @Override
    public boolean deleteRecord(QQuestionRecords questionRecords) {
        this.questionrecordsDao.deleteRecord(questionRecords);
        return true;
    }

    @Override
    public Map<String, Object> getPopularRecord() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        List<Object> contentList = new ArrayList();
        contentList = this.questionrecordsDao.getPopularRecord();
        res.put("data", contentList);
        res.put("code", 200);
        return res;
    }

    @Override
    public Map<String, Object> insertRecord(QQuestionRecords questionrecords) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        SecurityUser userInfo = BaseSecurityUtil.getUser();
        if (null == questionrecords.getDialogId() || "".equals(questionrecords.getDialogId())) {
            questionrecords.setDialogId(UUID.randomUUID().toString().replace("-", ""));
        }
        questionrecords.setDelFlag("1");
        questionrecords.setCreator(userInfo.getUserId());
        questionrecords.setCreatorName(userInfo.getUserName());
        questionrecords.setCreateTime(new Date());
        this.saveOrUpdate((Object)questionrecords);
        res.put("code", 200);
        res.put("dialogId", questionrecords.getDialogId());
        return res;
    }

    @Override
    public boolean updateRecord(QQuestionRecords questionrecords) {
        boolean res = false;
        int num = this.questionrecordsDao.updateRecord(questionrecords);
        if (num > 0) {
            res = true;
        }
        return res;
    }
}

